/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import jp.kitec.lib.gui.KFileChooser;
import jp.kitec.lib.gui.KFileFilters;

public class KFileChooserImplementedByFileDialog
implements KFileChooser {
    private FileDialog mFileDialog = null;
    private FileFilter mFilter = null;
    private String mTitle = "";
    private int mDialogType = 0;

    @Override
    public int showOpenDialog(Component parent) {
        if (parent == null) {
            throw new IllegalArgumentException("component is null.");
        }
        if (!(parent instanceof Frame) && !(parent instanceof Dialog)) {
            throw new IllegalArgumentException("component is not Frame or Dialog.");
        }
        while (!(parent instanceof Frame)) {
            if ((parent = parent.getParent()) != null) continue;
            return -1;
        }
        this.mFileDialog = new FileDialog((Frame)parent);
        this.mFileDialog.setMode(0);
        this.mFileDialog.setTitle(this.mTitle);
        return -1;
    }

    @Override
    public int showSaveDialog(Component parent) {
        if (parent == null) {
            throw new IllegalArgumentException("component is null.");
        }
        if (!(parent instanceof Frame) && !(parent instanceof Dialog)) {
            throw new IllegalArgumentException("component is not Frame or Dialog.");
        }
        while (!(parent instanceof Frame)) {
            if ((parent = parent.getParent()) != null) continue;
            return -1;
        }
        this.mFileDialog = new FileDialog((Frame)parent);
        this.mFileDialog.setMode(1);
        this.mFileDialog.setTitle(this.mTitle);
        return -1;
    }

    @Override
    public void setDialogTitle(String dialogTitle) {
        this.mTitle = dialogTitle;
    }

    @Override
    public String getDialogTitle() {
        return this.mTitle;
    }

    @Override
    public void setDialogType(int dialogType) {
        this.mDialogType = dialogType;
    }

    @Override
    public int getDialogType() {
        return this.mDialogType;
    }

    @Override
    public File getSelectedFile() {
        int answer;
        if (this.mFileDialog == null) {
            throw new IllegalStateException("does not open dialog.");
        }
        File result = null;
        FileFilter orgFilter = this.mFilter;
        KFileFilters.ExtFileFilter filter = null;
        filter = orgFilter instanceof KFileFilters.ExtFileFilter ? (KFileFilters.ExtFileFilter)orgFilter : null;
        if (filter != null) {
            this.mFileDialog.setFile("*" + filter.getExtension());
            ExtFilenameFilter filter2 = new ExtFilenameFilter();
            filter2.setExtension(filter.getExtension());
            this.mFileDialog.setFilenameFilter(filter2);
        }
        this.mFileDialog.setVisible(true);
        if (this.mFileDialog.getFile() == null) {
            return null;
        }
        boolean addExtension = false;
        if (filter != null && !this.mFileDialog.getFile().toLowerCase().endsWith(filter.getExtension())) {
            this.mFileDialog.setFile(this.mFileDialog.getFile() + filter.getExtension());
            addExtension = true;
        }
        result = new File(this.mFileDialog.getDirectory(), this.mFileDialog.getFile());
        if (addExtension && this.mFileDialog.getMode() == 1 && result.exists() && (answer = JOptionPane.showConfirmDialog(this.mFileDialog.getParent(), "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u3059\u3002\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b?", "\u8b66\u544a", 2, 2)) != 0) {
            return null;
        }
        return result;
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        this.mFilter = filter;
    }

    @Override
    public FileFilter getFileFilter() {
        return this.mFilter;
    }

    public void dispose() {
        if (this.mFileDialog == null) {
            return;
        }
        this.mFileDialog.dispose();
        this.mFileDialog = null;
    }

    @Override
    public boolean accept(File f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addActionListener(ActionListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void approveSelection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancelSelection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeToParentDirectory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureFileIsVisible(File f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileFilter getAcceptAllFileFilter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JComponent getAccessory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActionListener[] getActionListeners() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getApproveButtonMnemonic() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getApproveButtonText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getApproveButtonToolTipText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileFilter[] getChoosableFileFilters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getControlButtonsAreShown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getCurrentDirectory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDescription(File f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getDragEnabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFileSelectionMode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileSystemView getFileSystemView() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileView getFileView() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Icon getIcon(File f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName(File f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File[] getSelectedFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTypeDescription(File f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileChooserUI getUI() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUIClassID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAcceptAllFileFilterUsed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDirectorySelectionEnabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFileHidingEnabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFileSelectionEnabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMultiSelectionEnabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTraversable(File f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeActionListener(ActionListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeChoosableFileFilter(FileFilter f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rescanCurrentDirectory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetChoosableFileFilters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAccessory(JComponent newAccessory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setApproveButtonMnemonic(char mnemonic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setApproveButtonMnemonic(int mnemonic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setApproveButtonText(String approveButtonText) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setApproveButtonToolTipText(String toolTipText) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setControlButtonsAreShown(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCurrentDirectory(File dir) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDragEnabled(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFileHidingEnabled(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFileSelectionMode(int mode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFileSystemView(FileSystemView fsv) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFileView(FileView fileView) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMultiSelectionEnabled(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedFile(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedFiles(File[] selectedFiles) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateUI() {
        throw new UnsupportedOperationException();
    }

    private static class ExtFilenameFilter
    implements FilenameFilter {
        private String mExt;

        private ExtFilenameFilter() {
        }

        public void setExtension(String ext) {
            this.mExt = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.mExt);
        }
    }
}

