/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.util.timer;

import java.util.Calendar;
import java.util.Date;

public class KTimerIterator {
    public static final short TIMER_DAY = 5;
    public static final short TIMER_HOUR = 11;
    public static final short TIMER_MIN = 12;
    public static final short TIMER_SEC = 13;
    private int mOffset;
    private short mTimerType;
    private final Calendar calendar = Calendar.getInstance();

    public KTimerIterator(int hourOfDay, int minute, int second, short type, int offset) {
        this.mTimerType = type;
        this.mOffset = offset;
        Date date = new Date();
        this.calendar.setTime(date);
        this.calendar.set(11, hourOfDay);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        this.calendar.set(14, 0);
        while (this.calendar.getTime().before(date)) {
            this.add(this.mOffset);
        }
        this.add(-this.mOffset);
    }

    private Date add(int offset) {
        switch (this.mTimerType) {
            case 5: {
                this.calendar.add(5, offset);
                break;
            }
            case 11: {
                this.calendar.add(10, offset);
                break;
            }
            case 12: {
                this.calendar.add(12, offset);
                break;
            }
            case 13: {
                this.calendar.add(13, offset);
                break;
            }
            default: {
                this.calendar.add(5, offset > 0 ? 1 : -1);
            }
        }
        return this.calendar.getTime();
    }

    public Date next() {
        return this.add(this.mOffset);
    }
}

