/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.util.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class HttpGetter {
    public String get(String url) {
        StringBuffer sb = new StringBuffer();
        try {
            URL urlObj = new URL(url);
            HttpURLConnection urlCon = (HttpURLConnection)urlObj.openConnection();
            urlCon.setRequestMethod("GET");
            BufferedReader urlIn = new BufferedReader(new InputStreamReader(this.openConnectionCheckRedirects(urlCon)));
            String str = null;
            while ((str = urlIn.readLine()) != null) {
                sb.append(str + "\n");
            }
            urlIn.close();
            urlCon.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    private InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }
}

