/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.io.FileIOUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import jp.kitec.lib.util.xml.XMLManager;
import jp.kitec.lib.util.xml.XMLWriter;

public class ObjectFolderDao {
    protected AbstFile mInputAbstFile = null;
    protected OutputStream mOutputStream = null;
    protected AbstFile mOutputAbstFile = null;

    public ObjectFolder load() {
        XMLManager manager = new XMLManager();
        manager.load(this.mInputAbstFile);
        return manager.getTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ObjectFolder folder) throws IOException {
        PrintStream ps = new PrintStream(this.mOutputAbstFile.openOutputStream("Shift_JIS"));
        ps.println("<?xml version='1.0' encoding='Shift_JIS'?>");
        try {
            XMLWriter.write((ObjectNode)folder, (String)"", (PrintStream)ps);
            ps.close();
            this.mOutputAbstFile.write(this.mOutputStream);
        }
        finally {
            FileIOUtil.close((OutputStream)ps);
            FileIOUtil.close((OutputStream)this.mOutputStream);
        }
    }

    public void setInput(File file) {
        InputStream is = null;
        try {
            is = new GZIPInputStream(new FileInputStream(file));
        }
        catch (Exception e) {
            try {
                is = new FileInputStream(file);
            }
            catch (Exception e2) {
                throw new RuntimeException(e);
            }
        }
        this.setInput(is);
    }

    public void setInput(InputStream stream) {
        AbstFile abstFile = new AbstFile();
        abstFile.read(stream, "");
        this.setInput(abstFile);
    }

    public void setInput(String path) {
        this.setInput(new File(path));
    }

    public void setInput(AbstFile abstFile) {
        this.mInputAbstFile = abstFile;
    }

    public void setOutput(File file) {
        this.setOutput(file, false);
    }

    public void setOutput(File file, boolean compress) {
        OutputStream os = null;
        try {
            os = new FileOutputStream(file);
            if (compress) {
                os = new GZIPOutputStream(os);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setOutput(os);
    }

    public void setOutput(OutputStream stream) {
        this.mOutputStream = stream;
        AbstFile abstFile = new AbstFile();
        this.setOutput(abstFile);
    }

    public void setOutput(String path) {
        this.setOutput(new File(path));
    }

    protected void setOutput(AbstFile abstFile) {
        this.mOutputAbstFile = abstFile;
    }
}

