/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KFontMetrics;
import jp.kitec.kwt.KRichGraphics;

public class KAwtFont
extends KFont {
    private static final long serialVersionUID = 1L;
    protected Font mFontObject;
    protected Font mScaledFontObject;

    public KAwtFont(String fontname, int fonttype, double fontsize) {
        super(fontname, fonttype, fontsize);
        this.mFontObject = new Font(fontname, fonttype, (int)fontsize).deriveFont((float)fontsize);
        if (fontsize < 5.0) {
            this.mScaledFontObject = this.mFontObject.deriveFont(12.0f);
        }
    }

    public Object getFontObject() {
        return this.mFontObject;
    }

    public KFontMetrics getFontMetrics(Object context) {
        if (this.mScaledFontObject != null) {
            FontMetrics afm = this.getFontMetrics(this.mScaledFontObject, context);
            return new ScaleAwtFontMetrics(this.mFontObject.getSize2D(), 12.0, afm);
        }
        FontMetrics afm = this.getFontMetrics(this.mFontObject, context);
        return new FontAwtFontMetrics(afm);
    }

    FontMetrics getFontMetrics(Font font, Object context) {
        try {
            if (context instanceof Graphics) {
                Graphics g = (Graphics)context;
                return g.getFontMetrics(font);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (context instanceof Component) {
                Component comp = (Component)context;
                return comp.getFontMetrics(font);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (context instanceof KRichGraphics) {
                KRichGraphics rg = (KRichGraphics)((Object)context);
                return this.getFontMetrics(font, rg.getGC());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    static class FontAwtFontMetrics
    implements KFontMetrics {
        FontMetrics mFontMetrics;

        FontAwtFontMetrics(FontMetrics fm) {
            this.mFontMetrics = fm;
        }

        public double stringWidth(String s) {
            return this.mFontMetrics.stringWidth(s);
        }

        public double getHeight() {
            return this.mFontMetrics.getHeight();
        }

        public double getAscent() {
            return this.mFontMetrics.getAscent();
        }

        public double getDescent() {
            return this.mFontMetrics.getDescent();
        }
    }

    static class ScaleAwtFontMetrics
    implements KFontMetrics {
        double mFontSize;
        double mRefFontSize;
        FontMetrics mFontMetrics;

        ScaleAwtFontMetrics(double size, double refSize, FontMetrics fm) {
            this.mFontSize = size;
            this.mRefFontSize = refSize;
            this.mFontMetrics = fm;
        }

        public double stringWidth(String s) {
            return (double)this.mFontMetrics.stringWidth(s) * this.mFontSize / this.mRefFontSize;
        }

        public double getHeight() {
            return this.mFontSize;
        }

        public double getAscent() {
            return (double)this.mFontMetrics.getAscent() * this.mFontSize / this.mRefFontSize;
        }

        public double getDescent() {
            return (double)this.mFontMetrics.getDescent() * this.mFontSize / this.mRefFontSize;
        }
    }
}

