/*
 * Copyright (c) 2009 KITec Inc,.. All rights reserved.
 */
package option.gad.core.util;

import java.util.Collection;

import option.gad.core.annotation.GdVersion;



/**
 * Framework用、バージョン関連ユーティリティ
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class GdVersionUtil {

	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected GdVersionUtil() {
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	/**
	 * Classリスト中の任意のバージョンクラスを探索する。
	 *
	 * @param classes 探索対象Classコレクション
	 * @param version バージョン
	 * @return 一致したクラス
	 */
	public static Class<?> findClass(Collection<Class<?>> classes, String version) {
		Class<?> currentClazz = null;
		for (Class<?> clazz: classes) {
			GdVersion annoVer = clazz.getAnnotation(GdVersion.class);
			if (annoVer == null) continue;
			if (!annoVer.value().equals(version)) continue;

			currentClazz = clazz;
			break;
		}
		return currentClazz;
	}



} // end-class
