/*
 * Copyright (c) 2014 KITec Inc,.. All rights reserved.
 */
package option.gad.core.util;

import java.util.Map;



/**
 * Flyweightパターンの抽象実装<br/>
 * 生成されたオブジェクトの保持は、LRUCacheにて行う<br/>
 */
public abstract class GdAbstractLRUFlyweightFactory<K, V>
	extends GdAbstractFlyweightFactory<K, V> {

	protected GdLRUCache<K, V> pool = new GdLRUCache<K, V>();

	@Override
	protected Map<K, V> getPool() {
		return pool;
	}

}
