/*
 * Copyright (c) 2014 KITec Inc,.. All rights reserved.
 */
package option.gad.core.util;

import java.util.HashMap;
import java.util.Map;



/**
 * Flyweightパターンの抽象実装<br/>
 * 生成されたオブジェクトは全て保持する<br/>
 */
public abstract class GdAbstractAllFlyweightFactory<K, V>
	extends GdAbstractFlyweightFactory<K, V> {

	protected HashMap<K, V> pool = new HashMap<K, V>();

	@Override
	protected Map<K, V> getPool() {
		return pool;
	}

}
