/*
 * Copyright (c) 2009-2010 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dxo;

import java.util.Collection;

import jp.kitec.lib.util.ReflectUtil;
import jp.kitec.lib.util.StringUtil;
import option.gad.core.annotation.GdVersion;
import option.gad.core.inject.GdInstanceFactory;
import option.gad.core.util.GdVersionUtil;



/**
 * オブジェクト変換クラスの抽象実装<br/>
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public abstract class GdAbstractObjectConverter {

	protected GdAbstractObjectConverter() {
	}



	public <FROM, TO> TO convert(FROM from) {
		GdVersion annoVersion = from.getClass().getAnnotation(GdVersion.class);
		String version = null;
		if (annoVersion != null) version = annoVersion.value();
		return convert(version, from);
	}

	@SuppressWarnings("unchecked")
	public <FROM, TO> TO convert(String version, FROM from) {
		if (StringUtil.isEmpty(version)) throw new IllegalStateException("version not found.");

		Collection<Class<?>> classes = configTargetClasses();
		Class<?> currentClazz = GdVersionUtil.findClass(classes, version);

		Object params = from;
		boolean match = false;
		for (Class<?> clazz: classes) {
			if (!match && currentClazz != clazz) continue;
			if (currentClazz == clazz) match = true;

			GdObjectConvertLogic<?, ?> converter =
				(GdObjectConvertLogic<?, ?>)GdInstanceFactory.getInstance().getInstance(clazz);
			ReflectUtil.invokeMethod(converter, "repairBefore", params);
			Object result = ReflectUtil.invokeMethod(converter, "convert", params);
			ReflectUtil.invokeMethod(converter, "repairAfter", params, result);
			params = result;
		}
		return (TO)params;
	}

	protected abstract Collection<Class<?>> configTargetClasses();



} // end-interface
