/*
 * Copyright (c) 2009 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dxo;

import java.lang.reflect.Field;
import java.util.Collection;

import jp.kitec.lib.util.ReflectUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * データ変換ユーティリティー
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class DxoUtil {

	//------------------------------------------------------------------
	//- fields
	//------------------------------------------------------------------

	/** ログ */
	@SuppressWarnings("unused")
	private static final Log mLog = LogFactory.getLog(DxoUtil.class);



	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected DxoUtil() {
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	/**
	 * オブジェクトを変換する。<br/>
	 * その際、フィールド値をできるだけコピーする。<br/>
	 *
	 * @param dstClazz 変換クラス
	 * @param src 変換元オブジェクト
	 * @return 内容が変換された新たなオブジェクト
	 */
	public static <T, U> U convert(Class<U> dstClazz, T src) {
		U dst = ReflectUtil.newInstance(dstClazz, new Object[]{});
		convert(src, dst);
		return dst;
	}

	/**
	 * オブジェクトの変換を行う。<br/>
	 *
	 * @param src 変換元オブジェクト
	 * @param dst 変換先オブジェクト
	 * @return 変換されたオブジェクト
	 */
	public static <T, U> U convert(T src, U dst) {
		for (Field srcField: ReflectUtil.getFields(src)) {
			Field dstField = ReflectUtil.getField(dst, srcField.getName());
			if (dstField == null) continue;

			Object srcValue = ReflectUtil.getFieldValue(src, srcField);
			Object dstValue = TypeConvertUtil.convert(dstField.getType(), srcValue);
			if (dstValue == null) continue;

			ReflectUtil.setFieldValue(dst, dstField, dstValue);
		}
		return dst;
	}

	/**
	 * コレクションの変換を行う。<br/>
	 *
	 * @param srcs 変換元オブジェクトコレクション
	 * @return 内容が変換された新たなオブジェクトのコレクション
	 */
	@SuppressWarnings("unchecked")
	public static <T> Collection<T> convert(Collection<T> srcs) {
		Collection<T> tos = ReflectUtil.newInstance(srcs.getClass(), new Object[]{});
		for (T src: srcs) {
			T dst = (T)ReflectUtil.newInstance(src.getClass(), new Object[]{});
			convert(srcs, dst);
			tos.add(dst);
		}
		return tos;
	}



} // end-class
