/*
 * Copyright (c) 2009-2014 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dao;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;

import jp.kitec.lib.io.AbstFile;
import option.gad.core.io.FileIOUtil;



/**
 * ローカルに存在するCSVファイルへアクセスするDaoの抽象実装
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public abstract class AbstractLocalCsvDao<E> extends AbstractCsvDao<E> {

	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected AbstractLocalCsvDao() {
		super();
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	@Override
	protected void loadResource() {
		try {
			InputStream is = FileIOUtil.openInReadingMode(mFile);
			if (is != null) mCsv = mCsvBuilder.build(is, mHeadExist, configDefaultCharacterEncoding());
		} catch (FileNotFoundException e) {
			throw new RuntimeException(e);
		}
	}



	//------------------------------------------------------------------
	//- setter / getter
	//------------------------------------------------------------------

	public void setInput(File file) {
		mFile = file;
		mAbstFile = new AbstFile();
	}

	public void setOutput(OutputStream os) {
		mOutputStream = os;
		mAbstFile = new AbstFile();
	}

	public void setOutput(AbstFile abstFile) {
		mAbstFile = abstFile;
	}

	public void setOutput(File file) {
		mFile = file;
		mAbstFile = new AbstFile();
	}



} // end-class
