/*
 * Copyright (c) 2014 KITec Inc,.. All rights reserved.
 */
package option.gad.core.util;

import java.util.Map;



/**
 * Flyweightパターンの抽象実装<br/>
 * 生成されたオブジェクトの保持は、FIFOCacheにて行う<br/>
 */
public abstract class GdAbstractFIFOFlyweightFactory<K, V>
	extends GdAbstractFlyweightFactory<K, V> {

	protected GdFIFOCache<K, V> pool = new GdFIFOCache<K, V>();

	@Override
	protected Map<K, V> getPool() {
		return pool;
	}

}
