/*
 * Copyright (c) 2005-2009 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dao;

import nethome5.doc.Document;




/**
 * セクションの読み込みを行う抽象基底クラス。
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
abstract class SectionReader {

	/** セクション名 */
	private String mSectionName;



	/**
	 * コンストラクタ
	 *
	 * @param sectionName セクション名
	 */
	public SectionReader(final String sectionName) {
		setSectionName(sectionName);
	}

	/**
	 * セクション名を設定する。
	 *
	 * @param sectionName セクション名
	 */
	public void setSectionName(final String sectionName) {
		mSectionName = sectionName;
	}

	/**
	 * セクション名を返す。
	 *
	 * @return セクション名
	 */
	public String getSectionName() {
		return mSectionName;
	}

	/**
	 * セクションを読み込む。
	 *
	 * @param doc ドキュメント
	 * @param section セクション
	 * @return セクションが正常に読み込めた場合true。
	 */
	abstract public boolean readSection(final Document doc,
											final Section section);
}
