/*
 * Copyright (c) 2009-2010 KITec Inc,.. All rights reserved.
 */
package option.gad.toex.entity;

import java.io.Serializable;

import jp.kitec.lib.annotation.Reflectable;
import jp.kitec.lib.util.ObjectUtil;
import option.gad.core.annotation.GdProperty;
import option.gad.core.entity.GdEntity;



/**
 * 見積明細行を表すクラス
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
@GdEntity
@Reflectable(name="EstimateRow")
public class EstimateRow implements Serializable {

	//------------------------------------------------------------------
	//- fields
	//------------------------------------------------------------------

	/** 拾い出しID */
	@GdProperty
	public Integer mPickupId;

	/** 商品コード */
	@GdProperty
	public String mCode;

	/** 商品ID */
	@GdProperty
	public String mId;

	/** 商品SubID */
	@GdProperty
	public String mSubId;

	/** 名称 */
	@GdProperty
	public String mName;

	/** 単価 */
	@GdProperty
	public Integer mPrice;

	/** ソートNo */
	@GdProperty
	public Integer mSortNo;

	/** カテゴリコード */
	@GdProperty
	public String mCategoryCode;

	/** カテゴリ名 */
	@GdProperty
	public String mCategoryName;

	/** カテゴリソートNo */
	@GdProperty
	public Integer mCategorySortNo;

	/** 数量 */
	@GdProperty
	public Integer mQuantity;



	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	public EstimateRow() {
		super();
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	/**
	 * このインスタンスの文字列表現を取得します。
	 *
	 * @return このインスタンスの文字列表現
	 */
	@Override
	public String toString() {
		return ObjectUtil.toString(this);
	}



} // end-class
