/*
 * Copyright (c) 2009-2010 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dao;



/**
 * Framework用、保存ファイルDaoのインターフェース
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public interface GdSaveFileDao<IN, OUT, DOC> {

	/**
	 * データを永続層に保存する。
	 *
	 * @param out 永続層
	 * @param doc ドキュメント
	 */
	public void save(OUT out, DOC doc);

	/**
	 * 永続層からデータを復元する。
	 *
	 * @param in 永続層
	 * @param doc ドキュメント
	 */
	public void load(IN in, DOC doc);



} // end-class
