/*
 * Copyright (c) 2008 KITec Inc,.. All rights reserved.
 */
package option.gad.core.util;

import jp.kitec.lib.util.tree.ObjectNode;




/**
 * ObjectNodeユーティリティクラス
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class ObjectNodeUtil {

	/**
	 * コンストラクタ
	 */
	protected ObjectNodeUtil() {
	}



	/**
	 * Stringの取得
	 * 存在しない場合はnullを返す
	 *
	 * @param node
	 * @return
	 */
	public static String toString(ObjectNode node) {
		String res = null;
		if (node != null && node.getObject() != null && node.getObject() instanceof String) {
			res = (String)node.getObject();
		}
		return res;
	}

	/**
	 * nodeからIntegerを取得する。<br/>
	 * node値がIntegerで無い場合nullを返す。<br/>
	 *
	 * @param node {@link ObjectNode}
	 * @return node値
	 */
	public static Integer toInteger(ObjectNode node) {
		Integer result = null;
		if (node == null) return result;

		if (node.getObject() instanceof Integer) {
			result = (Integer)node.getObject();
		} else if (node.getObject() instanceof String) {
			try {
				result = Integer.valueOf((String)node.getObject());
			} catch (Exception e) {
			}
		}

		return result;
	}

	/**
	 * nodeからFloatを取得する。<br/>
	 * node値がFloatで無い場合nullを返す。<br/>
	 *
	 * @param node {@link ObjectNode}
	 * @return node値
	 */
	public static Float toFloat(ObjectNode node) {
		Float result = null;
		if (node == null) return result;

		if (node.getObject() instanceof Float) {
			result = (Float)node.getObject();
		} else if (node.getObject() instanceof String) {
			try {
				result = Float.valueOf((String)node.getObject());
			} catch (Exception e) {
			}
		}

		return result;
	}

	/**
	 * nodeからBooleanを取得する。<br/>
	 * node値がBooleanで無い場合nullを返す。<br/>
	 *
	 * @param node {@link ObjectNode}
	 * @return node値
	 */
	public static Boolean toBoolean(ObjectNode node) {
		Boolean result = null;
		if (node == null) return result;

		if (node.getObject() instanceof Boolean) {
			result = (Boolean)node.getObject();
		} else if (node.getObject() instanceof String) {
			if (node.getObject().equals("1") || node.getObject().equals("true")) {
				result = Boolean.TRUE;
			} else {
				result = Boolean.FALSE;
			}
		}

		return result;
	}



} // end-class
