/*
 * Copyright (c) 2013 KITec Inc,.. All rights reserved.
 */
package option.gad.core.util;



/**
 * ビット列に関するユーティリティクラス
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class BitUtil {


	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected BitUtil() {
		super();
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	public static boolean matchOR(Integer targetValue, Integer... caseValues) {
		if (targetValue == null) return false;
		if (caseValues == null) return false;
		if (caseValues.length == 0) return false;

		for (Integer caseValue: caseValues) {
			if ((targetValue & caseValue) == caseValue) return true;
		}
		return false;
	}

	public static boolean matchAND(Integer targetValue, Integer... caseValues) {
		if (targetValue == null) return false;
		if (caseValues == null) return false;
		if (caseValues.length == 0) return false;

		boolean result = true;
		int value = 0;
		for (Integer caseValue: caseValues) {
			value |= caseValue;
			result = targetValue == value;
		}
		return result;
	}



} // end-class
