package option.gad.core.dao;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;

import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.io.FileIOUtil;


/**
 * セクションの管理を行う。
 *
 * @since		2005/01/07
 * @author		fujita
 * @version	2005/04/11	fujita
 * 							セクション名がない場合、
 * 							匿名のセクション名を
 * 							使用するよう変更。
 *
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
 */
public class SectionManager {
	/** セクション名がない場合の仮の名前 */
	public static final String DEF_ANONYMOUS = "anonymous";


	/** すべてのセクション */
	private Vector mSections;


	/**
	 * 空の内容を持つ新たな SectionManager を作成する。
	 *
	 * @since		2005/02/09
	 * @author		fujita
	 * @version	2005/02/09
	 */
	public SectionManager() {
		mSections = new Vector();
	}

	/**
	 * 指定された section を、新たなセクションとして追加する。
	 *
	 * @param		section		セクション
	 * @since		2005/02/09
	 * @author		fujita
	 * @version	2005/02/09
	 */
	public void addSection(final Section section) {
		mSections.addElement(section);
	}

	/**
	 * セクションの数を返す。
	 *
	 * @return	セクションの数
	 * @since		2005/02/09
	 * @author		fujita
	 * @version	2005/02/09
	 */
	public int getSectionCount() {
		return mSections.size();
	}

	/**
	 * 指定されたインデックスをセクションを返す。
	 *
	 * @param		index	セクションのインデックス
	 * @return	セクション
	 * @since		2005/02/09
	 * @author		fujita
	 * @version	2005/02/09
	 */
	public Section getSection(final int index) {
		return (Section)mSections.elementAt(index);
	}

	/**
	 * 指定されたセクション名を持つセクションを検索する。
	 *
	 * @param		sectionName		セクション名
	 * @return	指定されたセクション名に一致する
	 * 				セクションが存在する場合、そのセクション。
	 * 				そうでない場合は、null
	 * @since		2005/02/09
	 * @author		fujita
	 * @version	2005/02/09
	 */
	public Section searchSection(final String sectionName) {
		Section section;
		final int count = getSectionCount();
		for (int i = 0; i < count; i++) {
			section = getSection(i);
			if (section.equals(sectionName)) {
				return section;
			}
		}
		return null;
	}

	/**
	 * 指定された file から、セクション、および
	 * セクションのデータを展開する。
	 *
	 * @param		file	データの読み込み元となるオブジェクト
	 * @return	データを正常に読み込めた場合、true。
	 * 				そうでない場合は、false
	 * @since		2005/02/09
	 * @author		fujita
	 * @version	2005/04/11	fujita
	 * 							セクションが存在しない場合
	 * 							匿名のセクションを作成する
	 * 							よう変更。
	 */
	public boolean deploySection(final AbstFile file) {
		Section section = null;
		String str;
		BufferedReader r = file.openBufferedReader();

		try {
		while (true) {
			str = r.readLine();
			switch (Section.getType(str)) {
			case Section.TYPE_EOF:
				return true;
			case Section.TYPE_SPACE:
				break;
			case Section.TYPE_SECTION:
				section = newSection(str);
				break;
			case Section.TYPE_DATA:
				if (section != null) {
					section.addData(str.trim());
				}
				else {
					//--> 20050411 fujita update start
					/*
					return false;
					*/
					section = newSection(Section.toSectionString(DEF_ANONYMOUS));
					section.addData(str.trim());
					//<-- update ene
				}
				break;
			}
		}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			FileIOUtil.close(r);
		}
		return false;
	}

	/**
	 * 指定されたセクション名を持つ新たなセクションを作成する。
	 *
	 * @param		sectionName		セクション名
	 * @return	指定されたセクション名を持つセクション
	 * @since		2005/02/09
	 * @author		fujita
	 * @version	2005/02/09
	 */
	private Section newSection(final String sectionName) {
		Section section = new Section();
		final String s = sectionName.trim();
		section.setSectionName(s.substring(1, s.length() - 1));
		addSection(section);
		return section;
	}
}
