/*
 * Copyright (c) 2010 KITec Inc,.. All rights reserved.
 */
package option.gad.core.util;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * 更新を管理するクラス。
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public abstract class GdUpdateManager {

	/** ログ */
	private static final Log log = LogFactory.getLog(GdUpdateManager.class);

	protected Map<GdUpdateTargetType, Boolean> stateMap = new HashMap<GdUpdateTargetType, Boolean>();

	protected GdUpdateTargetType[] updateTargetTypes;



	/**
	 * コンストラクタ
	 */
	protected <T extends GdUpdateTargetType> GdUpdateManager(T[] updateTargetTypes) {
		super();
		this.updateTargetTypes = updateTargetTypes;
	}



	public void setAllState(boolean state) {
		for (GdUpdateTargetType updateTargetType: updateTargetTypes) {
			setState(updateTargetType, state);
		}
	}

	public void setState(GdUpdateTargetType updateTargetType, boolean state) {
		stateMap.put(updateTargetType, state);
	}

	public boolean getState(GdUpdateTargetType updateTargetType) {
		Boolean state = stateMap.get(updateTargetType);
		if (state == null) state = false;
		stateMap.put(updateTargetType, state);
log.debug("getState targetType[" + updateTargetType + "] state[" + state + "]");
		return state;
	}

	public boolean isChanged() {
		boolean result = false;
		for (GdUpdateTargetType updateTargetType: updateTargetTypes) {
			result |= getState(updateTargetType);
		}
log.debug("isChanged result[" + result + "]");
		return result;
	}



} // end-class
