/*
 * Copyright (c) 2009 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import jp.kitec.lib.io.AbstFile;
import option.gad.core.io.FileIOUtil;



/**
 * テキストDao
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class TextDao {

	//------------------------------------------------------------------
	//- fields
	//------------------------------------------------------------------

	/** 入力元AbstFile */
	protected AbstFile mInputAbstFile = null;

	/** 出力先Stream */
	protected OutputStream mOutputStream = null;

	/** 出力先AbstFile */
	protected AbstFile mOutputAbstFile = null;



	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	public TextDao() {
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	/**
	 * 永続層からObjectFolderを復元する。
	 *
	 * @return ObjectFolder
	 */
	public String load() {
		String text = FileIOUtil.readText(this.mInputAbstFile.openInputStream(), "MS932");
		return text;
	}

	/**
	 * ObjectFolderを永続層に保存する。
	 *
	 * @param text テキスト
	 */
	public void save(String text) {
		PrintStream ps = new PrintStream(this.mOutputAbstFile.openOutputStream(""));
		ps.print(text);
		ps.close();
		try {
			this.mOutputAbstFile.write(this.mOutputStream);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		FileIOUtil.close(ps);
		FileIOUtil.close(this.mOutputStream);
	}



	//------------------------------------------------------------------
	//- setter / getter
	//------------------------------------------------------------------

	/**
	 * 入力元Fileを設定する。
	 *
	 * @param file 入力元File
	 */
	public void setInput(File file) {
		InputStream is = null;
		try {
			is = new GZIPInputStream(new FileInputStream(file));
		} catch (Exception e) {
			try {
				is = new FileInputStream(file);
			} catch (Exception e2) {
				throw new RuntimeException(e);
			}
		}
		this.setInput(is);
	}

	/**
	 * 入力元Streamを設定する。
	 *
	 * @param stream 入力元Stream
	 */
	public void setInput(InputStream stream) {
		AbstFile abstFile = new AbstFile();
		abstFile.read(stream, "");
		this.setInput(abstFile);
	}

	/**
	 * 入力元AbstFileを設定する。
	 *
	 * @param abstFile 入力元AbstFile
	 */
	public void setInput(AbstFile abstFile) {
		this.mInputAbstFile = abstFile;
	}

	/**
	 * 出力先Fileを設定する。
	 *
	 * @param file 出力先File
	 */
	public void setOutput(File file) {
		this.setOutput(file, false);
	}

	/**
	 * 出力先Fileを設定する。
	 *
	 * @param file 出力先File
	 * @param compress 圧縮する場合true。
	 */
	public void setOutput(File file, boolean compress) {
		OutputStream os = null;
		try {
			os = new FileOutputStream(file);
			if (compress) os = new GZIPOutputStream(os);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		this.setOutput(os);
	}

	/**
	 * 出力先Streamを設定する。
	 *
	 * @param stream 出力先Stream
	 */
	public void setOutput(OutputStream stream) {
		this.mOutputStream = stream;
		AbstFile abstFile = new AbstFile();
//		abstFile.openNewFileToBuffer("");
		this.setOutput(abstFile);
	}

	/**
	 * 出力先AbstFileを設定する。
	 *
	 * @param abstFile 出力先AbstFile
	 */
	public void setOutput(AbstFile abstFile) {
		this.mOutputAbstFile = abstFile;
	}



} // end-class
