/*
 * Copyright (c) 2009-2010 KITec Inc,.. All rights reserved.
 */
package option.gad.toex.entity;

import java.io.Serializable;

import jp.kitec.lib.annotation.Reflectable;
import jp.kitec.lib.util.ObjectUtil;
import option.gad.core.annotation.GdProperty;
import option.gad.core.annotation.GdQuote;
import option.gad.core.entity.GdEntity;



/**
 * TOEX Framework用見積情報を表すクラス
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
@GdEntity
@Reflectable(name="Estimate")
public class Estimate implements Serializable {

	//------------------------------------------------------------------
	//- fields
	//------------------------------------------------------------------

	/** 商品コード */
	@GdProperty
	@GdQuote(add=false)
	public String mCode;

	/** 名称 */
	@GdProperty
	public String mName;

	/** 数量 */
	@GdProperty
	public Integer mQuantity;

	/** 単価 */
	@GdProperty
	public Integer mPrice;

	/** 価格 */
	@GdProperty
	public Integer mAmount;



	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	public Estimate() {
		super();
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	/**
	 * このインスタンスの文字列表現を取得します。
	 *
	 * @return このインスタンスの文字列表現
	 */
	@Override
	public String toString() {
		return ObjectUtil.toString(this);
	}



} // end-class
