/*
 * Copyright (c) 2009-2012 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dao;

import java.io.File;

import jp.kitec.lib.dao.ObjectFolderDao;
import jp.kitec.lib.util.StringUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import option.gad.core.annotation.GdProperty;
import option.gad.core.entity.GdSystemInfo;
import option.gad.core.util.ObjectFolderUtil;



/**
 * Framework用、Xml保存ファイルDaoファクトリーの抽象実装<br/>
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public abstract class GdXmlSaveFileDaoFactory<DAO> extends GdAbstractSaveFileDaoFactory<DAO, File, ObjectFolder> {

	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected GdXmlSaveFileDaoFactory() {
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	@Override
	public DAO createByPersistent(File file) {
		ObjectFolderDao dao = new ObjectFolderDao();
		dao.setInput(file);
		ObjectFolder rootFolder = dao.load();
		return createByDocument(rootFolder);
	}

	@Override
	protected String getVersion(ObjectFolder folder) {
		GdSystemInfo systemInfo = ObjectFolderUtil.createObject(GdSystemInfo.class, folder, GdProperty.class);
		if (StringUtil.isEmpty(systemInfo.mSaveFileVersion)) systemInfo.mSaveFileVersion = "Unknown";
		return systemInfo.mSaveFileVersion;
	}



} // end-class
