/*
 * Copyright (c) 2009 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dao;

import java.io.File;
import java.io.OutputStream;

import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.io.AbstFileUtil;



/**
 * ローカルに存在するKitecFormatファイルへアクセスするDaoの抽象実装
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public abstract class AbstractLocalKitecFormatDao<E> extends AbstractKitecFormatDao<E> {

	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected AbstractLocalKitecFormatDao() {
		super();
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	@Override
	protected void loadResource() {
		AbstFileUtil.read(mAbstFile, mFile);
		mSectionManager = new SectionManager();
		try {
			boolean result = mSectionManager.deploySection(mAbstFile);
			if (!result) throw new RuntimeException();
		} finally {
		}
	}



	//------------------------------------------------------------------
	//- setter / getter
	//------------------------------------------------------------------

	public void setInput(File file) {
		mFile = file;
		mAbstFile = new AbstFile();
	}

	public void setOutput(OutputStream os) {
		mOutputStream = os;
		mAbstFile = new AbstFile();
	}

	public void setOutput(AbstFile abstFile) {
		mAbstFile = abstFile;
	}

	public void setOutput(File file) {
		mFile = file;
		mAbstFile = new AbstFile();
	}



} // end-class
