package option.gad.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;



/**
 * LogRecord の概要を判読可能な形式で出力します。
 * 全情報を1行で出力します。
 * 
 * @author $Author$
 * @version $Revision$ $Date::                           $
 *
 * Copyright (c) 2007 KITec Inc,.. All rights reserved.
 */
public class OneLineFormatter extends Formatter {

	Date dat = new Date();
	private final static String format = "{0,date} {0,time}";
	private MessageFormat formatter;

	private Object args[] = new Object[1];

	// Line separator string.  This is the value of the line.separator
	// property at the moment that the OneLineFormatter was created.
	private String lineSeparator = (String)System.getProperty("line.separator"); 
//	java.security.AccessController.doPrivileged(
//			   new sun.security.action.GetPropertyAction("line.separator"));

	/**
	 * 指定された LogRecord をフォーマットします。
	 * @param   record フォーマットされるログレコード
	 * @return  フォーマットされたログレコード
	 */
	public synchronized String format(LogRecord record) {
		StringBuffer sb = new StringBuffer();
		// Minimize memory allocations here.
		dat.setTime(record.getMillis());
		args[0] = dat;
		StringBuffer text = new StringBuffer();
		if (formatter == null) {
			formatter = new MessageFormat(format);
		}
		formatter.format(args, text, null);
		sb.append(text);
		sb.append(" ");
		if (record.getSourceClassName() != null) {
			sb.append(record.getSourceClassName());
		} else {
			sb.append(record.getLoggerName());
		}
		if (record.getSourceMethodName() != null) {
			sb.append("#");
			sb.append(record.getSourceMethodName());
		}
		sb.append(" ");
		sb.append(record.getLevel().getName());
		sb.append(" ");
		String message = formatMessage(record);
		sb.append(message);
		sb.append(lineSeparator);
		if (record.getThrown() != null) {
			try {
				StringWriter sw = new StringWriter();
				PrintWriter pw = new PrintWriter(sw);
				record.getThrown().printStackTrace(pw);
				pw.close();
				sb.append(sw.toString());
			} catch (Exception ex) {
			}
		}
		return sb.toString();
	}



} // end-class
