/*
 * Copyright (c) 2014 KITec Inc,.. All rights reserved.
 */
package option.gad.core.util;

import java.util.Map;



/**
 * Flyweightパターンの抽象実装
 */
public abstract class GdAbstractFlyweightFactory<K, V> {

	public synchronized V get(K key) {
		V value = getPool().get(key);
		if (value == null) {
			value = createValue(key);
			getPool().put(key, value);
		}
		return value;
	}

	protected abstract Map<K, V> getPool();

	protected abstract V createValue(K key);

}
