/*
 * Copyright (c) 2009 KITec Inc,.. All rights reserved.
 */
package option.gad.core.entity;

import java.io.Serializable;

import jp.kitec.lib.util.ObjectUtil;
import option.gad.core.annotation.GdProperty;



/**
 * Framework用、保存情報
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
@GdEntity
public class GdSystemInfo implements Serializable {

	//------------------------------------------------------------------
	//- fields
	//------------------------------------------------------------------

	/** システム名 */
	@GdProperty
	public String mSystemName;

	/** ビルド番号 */
	@GdProperty
	public Integer mBuildNumber;

	/** 保存ファイルバージョン番号 */
	@GdProperty
	public String mSaveFileVersion;

	/** 保存日時 */
	@GdProperty
	public String mSaveTime;



	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	public GdSystemInfo() {
		super();
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	/**
	 * このインスタンスの文字列表現を取得します。
	 *
	 * @return このインスタンスの文字列表現
	 */
	@Override
	public String toString() {
		return ObjectUtil.toString(this);
	}



} // end-class
