/*
 * Copyright (c) 2009-2010 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dxo;

import jp.kitec.lib.annotation.Reflectable;




/**
 * オブジェクト変換ロジックインターフェース。
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public interface GdObjectConvertLogic<FROM, TO> {

	/**
	 * 変換処理前に修復を行う。<br/>
	 * このメソッドの実装にも、@Reflectableを付ける必要がある。<br/>
	 *
	 * @param from 変換前オブジェクト
	 */
	@Reflectable(name="repairBefore")
	public void repairBefore(FROM from);

	/**
	 * 変換処理を行う。<br/>
	 * このメソッドの実装にも、@Reflectableを付ける必要がある。<br/>
	 *
	 * @param from 変換対象オブジェクト
	 * @return 変換されたオブジェクト
	 */
	@Reflectable(name="convert")
	public TO convert(FROM from);

	/**
	 * 変換処理後に修復を行う。<br/>
	 * このメソッドの実装にも、@Reflectableを付ける必要がある。<br/>
	 *
	 * @param from 変換前オブジェクト
	 * @param to 修復対象オブジェクト
	 */
	@Reflectable(name="repairAfter")
	public void repairAfter(FROM from, TO to);



} // end-interface
