/*
 * Copyright (c) 2014 KITec Inc,.. All rights reserved.
 */
package option.gad.core.util;

import java.util.LinkedHashMap;
import java.util.Map;



/**
 * LRU Cache
 */
public class GdLRUCache<K, V> extends LinkedHashMap<K, V> {

	protected static final int DEFAULT_INITIAL_CAPACITY = 16;
	protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
	protected static final int DEFAULT_CACHE_SIZE = 1024;

	protected final int cacheSize;

	public GdLRUCache() {
		this(DEFAULT_INITIAL_CAPACITY, DEFAULT_LOAD_FACTOR, DEFAULT_CACHE_SIZE);
	}

	public GdLRUCache(int capacity, float loadFactor, int cacheSize) {
		super(capacity, loadFactor, true);
		this.cacheSize = cacheSize;
	}

	@Override
	protected boolean removeEldestEntry(Map.Entry<K,V> eldest) {
		return size() > cacheSize;
	}

}
