/*
 * Copyright (c) 2014 KITec Inc,.. All rights reserved.
 */
package option.gad.core.util;

import java.util.LinkedHashMap;
import java.util.Map;



/**
 * FIFO Cache
 */
public class GdFIFOCache<K, V> extends LinkedHashMap<K, V> {

	protected static final int DEFAULT_CACHE_SIZE = 1024;

	protected int cacheSize;

	public GdFIFOCache() {
		this(DEFAULT_CACHE_SIZE);
	}

	public GdFIFOCache(int cacheSize) {
		super(cacheSize);
		this.cacheSize = cacheSize;
	}

	@Override
	protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
		return size() > this.cacheSize;
	}

}
