/*
 * Copyright (c) 2009-2010 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dao;

import java.util.Collection;
import java.util.LinkedList;

import jp.kitec.lib.util.StringUtil;
import option.gad.core.annotation.GdVersion;
import option.gad.core.inject.GdInstanceFactory;
import option.gad.core.util.GdVersionUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * Framework用、保存ファイルDaoファクトリーの抽象実装<br/>
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public abstract class GdAbstractSaveFileDaoFactory<DAO, PER, DOC> implements GdSaveFileDaoFactory<DAO, PER, DOC> {

	//------------------------------------------------------------------
	//- fields
	//------------------------------------------------------------------

	/** ログ */
	private static Log mLog = LogFactory.getLog(GdAbstractSaveFileDaoFactory.class);



	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected GdAbstractSaveFileDaoFactory() {
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	public DAO create() {
		return createByVersion(configDefaultVersion());
	}

	public DAO createByPersistent(PER per) {
		throw new UnsupportedOperationException();
	}

	public DAO createByDocument(DOC doc) {
		return createByVersion(getVersion(doc));
	}

	public DAO createByVersion(String version) {
		return createInstance(version);
	}

	@SuppressWarnings("unchecked")
	protected DAO createInstance(String version) {
mLog.debug("saveFileVersion[" + version + "]");
		if (StringUtil.isEmpty(version)) version = configDefaultVersion();

		Collection<Class<?>> classes = configTargetClasses();
		Class<?> clazz = GdVersionUtil.findClass(classes, version);
		if (clazz == null) throw new IllegalStateException(clazz + " not found.");

		return (DAO)GdInstanceFactory.getInstance().getInstance(clazz);
	}

	protected abstract Collection<Class<?>> configTargetClasses();

	/**
	 * デフォルトバージョン番号を定義する。<br/>
	 * configTargetClassesメソッドにて一番最後後ろ定義されたクラスのバージョンを、<br/>
	 * 最新バージョン/デフォルトバージョンとして返す。<br/>
	 *
	 * @return デフォルトバージョン番号
	 */
	protected String configDefaultVersion() {
		LinkedList<Class<?>> targetClasses = new LinkedList<Class<?>>(configTargetClasses());
		Class<?> targetClass = targetClasses.getLast();
		GdVersion annoVersion = targetClass.getAnnotation(GdVersion.class);
		return StringUtil.emptyToDefault(annoVersion.value(), "Unknown");
	}

	protected abstract String getVersion(DOC doc);



} // end-class
