/*
 * Copyright (c) 2008 KITec Inc,.. All rights reserved.
 */
package option.gad.core.inject;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import jp.kitec.lib.util.ReflectUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * 依存性注入を行う。
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class GdInjector {

	//-----------------------------------------------------------------------
	//- fields
	//-----------------------------------------------------------------------

	/** ログ */
	@SuppressWarnings("unused")
	private static final Log mLog = LogFactory.getLog(GdInjector.class);

	/** インスタンス */
	private static GdInjector mInstance = new GdInjector();

	/** インジェクション試行済みセット */
	private Set<Object> mInjectedSet = new HashSet<Object>();



	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected GdInjector() {
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	/**
	 * インスタンスを取得する。
	 *
	 * @return インスタンス
	 */
	public static GdInjector getInstance() {
		return mInstance;
	}

	public void inject(final Object instance) {
		if (this.mInjectedSet.contains(instance)) return;
		this.mInjectedSet.add(instance);

		this.injectMethods(instance, ReflectUtil.getMethods(instance));
		this.injectFields(instance, ReflectUtil.getFields(instance));
	}

	public void injectMethods(final Object instance, final Collection<Method> methods) {
		for (Method method: methods) {
			this.injectMethod(instance, method);
		}
	}

	public boolean injectMethod(final Object instance, final Method method) {
		if (method.getAnnotation(GdInject.class) == null) return false;
		if (method.getParameterTypes() == null) return false;
		if (method.getParameterTypes().length != 1) return false;

		Class<?> injectionClazz = method.getParameterTypes()[0];
		Object injectionValue = GdInstanceFactory.getInstance().getInstance(injectionClazz);
		if (injectionValue == null) return false;

		ReflectUtil.invokeMethod(instance, method, injectionValue);
		return true;
	}

	public void injectFields(final Object instance, final Collection<Field> fields) {
		for (Field field: fields) {
			if (!this.injectField(instance, field)) continue;

			this.inject(GdInstanceFactory.getInstance().getInstance(field.getType()));
		}
	}

	public boolean injectField(final Object instance, final Field field) {
		if (field.getAnnotation(GdInject.class) == null) return false;
		if (ReflectUtil.getFieldValue(instance, field) != null) return false;

		Class<?> injectionClazz = field.getType();
		Object injectionValue = GdInstanceFactory.getInstance().getInstance(injectionClazz);
		if (injectionValue == null) return false;

		ReflectUtil.setFieldValue(instance, field, injectionValue);
		return true;
	}

	public void clear() {
		this.mInjectedSet.clear();
	}



} // end-class
