/*
 * Copyright (c) 2010 KITec Inc,.. All rights reserved.
 */
package option.gad.core.dxo;

import java.util.ArrayList;
import java.util.Collection;

import jp.kitec.lib.util.ClassInfo;
import jp.kitec.lib.util.ClassInfoManager;
import jp.kitec.lib.util.Closure;
import jp.kitec.lib.util.ObjectUtil;
import jp.kitec.lib.util.ReflectUtil;
import option.gad.core.annotation.GdConvertable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * オブジェクト変換ロジックの抽象実装。
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public abstract class GdAbstractObjectConvertLogic<FROM, TO> implements GdObjectConvertLogic<FROM, TO> {

	//------------------------------------------------------------------
	//- fields
	//------------------------------------------------------------------

	/** ログ */
	private static final Log mLog = LogFactory.getLog(GdAbstractObjectConvertLogic.class);



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	@SuppressWarnings("unchecked")
	protected <FROMT, TOT> TOT newInstance(FROMT from) {
mLog.debug("from[" + ObjectUtil.toString(from) + "]");
		if (from == null) return null;

		ClassInfo classInfo = ClassInfoManager.getInstance().getClassInfo(from.getClass());
		GdConvertable annoConvertable = classInfo.getType().getAnnotation(GdConvertable.class);
mLog.debug("annoConvertable[" + annoConvertable + "]");
		assert annoConvertable != null: "GdConvertable not found from " + classInfo.getType().getSimpleName()  + ".";

		TOT to = (TOT)ReflectUtil.newInstance(annoConvertable.next());
		ObjectUtil.shallowCopy(from, to);
mLog.debug("to[" + ObjectUtil.toString(to) + "]");
		return to;
	}

	protected <FROMT, TOT> Collection<TOT> newInstanceList(Collection<FROMT> from) {
		ArrayList<TOT> to = new ArrayList<TOT>();
		if (from == null) return to;

		for (FROMT fromRow: from) {
			TOT toRow = newInstance(fromRow);
			to.add(toRow);
		}
		return to;
	}

	@Deprecated
	protected <FROMT, TOT> Collection<TOT> newInstanceList(Collection<FROMT> from, Closure<FROMT, TOT> from2to) {
		ArrayList<TOT> to = new ArrayList<TOT>();
		if (from == null) return to;

		for (FROMT fromRow: from) {
			to.add(from2to.execute(fromRow));
		}
		return to;
	}



} // end-class
