/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui.command;

import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KRichGraphics;
import nethome.geom.util.ToolMath;
import nethome.ui.Canvas2D;
import nethome.ui.CanvasBase;
import nethome.ui.MainComponent;
import nethome.ui.command.Command;
import nethome.ui.command.CommandUtil;

public class ComViewZoomArea
extends Command
implements ActionListener {
    private int az;
    private int aA;
    private int aB;
    private int aC;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private boolean aD = false;

    public void play() {
        CommandUtil.setActiveUI(((ComViewZoomArea)eventListener).mComponent, true);
        EventListener eventListener = MainComponent.getInstance();
        eventListener = ((MainComponent)eventListener).getActiveCanvas();
        if (eventListener == null) {
            return;
        }
        ((Canvas2D)eventListener).setCursor(Canvas2D.MOUSE_CROSS);
    }

    public void end() {
        CommandUtil.setActiveUI(((ComViewZoomArea)eventListener).mComponent, false);
        ((ComViewZoomArea)eventListener).y2 = 0.0f;
        ((ComViewZoomArea)eventListener).x2 = 0.0f;
        ((ComViewZoomArea)eventListener).y1 = 0.0f;
        ((ComViewZoomArea)eventListener).x1 = 0.0f;
        EventListener eventListener = MainComponent.getInstance();
        eventListener = ((MainComponent)eventListener).getActiveCanvas();
        if (eventListener == null) {
            return;
        }
        ((Canvas2D)eventListener).setCursor(Canvas2D.MOUSE_DEF);
    }

    public void mouseMove(int n, int n2, int n3) {
    }

    public void mousePress(int n, int n2, int n3) {
        Panel panel = MainComponent.getInstance();
        if ((panel = panel.getActiveCanvas()) == null) {
            return;
        }
        this.aD = true;
        this.az = this.aB = n;
        this.aA = this.aC = n2;
        this.x1 = this.x2 = ((Canvas2D)panel).mAbstCanvas.devToRealX(this.az);
        this.y1 = this.y2 = ((Canvas2D)panel).mAbstCanvas.devToRealY(this.aA);
    }

    public void mouseDrag(int n, int n2, int n3) {
        Panel panel = MainComponent.getInstance();
        if ((panel = ((MainComponent)panel).getActiveCanvas()) == null) {
            return;
        }
        this.aB = n;
        this.aC = n2;
        this.x2 = ((Canvas2D)panel).mAbstCanvas.devToRealX(this.aB);
        this.y2 = ((Canvas2D)panel).mAbstCanvas.devToRealY(this.aC);
        panel.repaint();
    }

    public void mouseRelease(int n, int n2, int n3) {
        ComViewZoomArea comViewZoomArea = this;
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D != null) {
            if (Math.abs(comViewZoomArea.aB - comViewZoomArea.az) > 10 && Math.abs(comViewZoomArea.aC - comViewZoomArea.aA) > 10) {
                canvas2D.mAbstCanvas.setView(comViewZoomArea.x1, comViewZoomArea.y1, comViewZoomArea.x2, comViewZoomArea.y2);
                canvas2D.forceImageUpdate();
                canvas2D.repaint();
                canvas2D.updateViewControl();
                mainComponent.updateUserInterface();
            }
            if (!comViewZoomArea.mContinue) {
                canvas2D.setMouseCommand(null);
            }
            canvas2D.repaint();
        }
        this.aD = false;
    }

    public void actionPerformed(ActionEvent serializable) {
        serializable = MainComponent.getInstance();
        if ((serializable = ((MainComponent)serializable).getActiveCanvas()) == null) {
            return;
        }
        ((CanvasBase)serializable).setMouseCommand(this);
        this.play();
        serializable = MainComponent.getInstance();
        serializable = ((MainComponent)serializable).getActiveCanvas();
        if (serializable != null) {
            this.aD = false;
            ((Component)serializable).repaint();
        }
    }

    public void drawCommand(IRichGraphics iRichGraphics) {
        if (this.aD) {
            iRichGraphics.setColor(Color.red);
            if (!ToolMath.isSame2D(this.x1, this.y1, this.x2, this.y2)) {
                iRichGraphics.drawRect(this.x1, this.y1, this.x2, this.y2, KRichGraphics.LINE_1);
            }
        }
    }
}

