/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KRichGraphics;
import nethome.doc.Document;
import nethome.ui.command.Command;

public class CanvasBase
extends Panel {
    protected Document mDoc = null;
    protected Command mActiveCommand = null;
    protected Command mActiveMaskCommand = null;
    protected Command mAllowCommand = null;
    protected Command mViewControlCommand;
    protected Command mNullCommand = null;
    protected static final KFont mDefFont = KFont.getFont((String)"Dialog", (int)0, (float)12.0f);
    protected Color mBackColor = Color.white;
    protected Graphics mBufferGraphics;
    protected Image mBufferImage;
    protected Graphics mOffGraphics;
    protected Image mOffImage;
    public KRichGraphics mAbstCanvas = new KRichGraphics();

    public CanvasBase() {
        this.setBackground(Color.white);
    }

    public Command getMouseCommand() {
        return this.mActiveCommand;
    }

    public void setNullCommand(Command command) {
        this.mNullCommand = command;
        this.setMouseCommand(command);
    }

    public void registAllowKeyCommand(Command command) {
        this.mAllowCommand = command;
    }

    public void setViewControlCommand(Command command) {
        this.mViewControlCommand = command;
    }

    public Command getViewControlCommand() {
        return this.mViewControlCommand;
    }

    public void updateViewControl() {
        if (this.mViewControlCommand != null) {
            this.mViewControlCommand.updateInterface();
        }
    }

    public void setMouseCommand(Command command) {
        if (this.mActiveCommand != null) {
            this.mActiveCommand.end();
        }
        if (command == null) {
            this.mActiveCommand = this.mNullCommand;
            if (this.mNullCommand != null) {
                this.mNullCommand.updateInterface();
                this.mNullCommand.play();
            }
        } else {
            this.mActiveCommand = command;
        }
        this.repaint();
    }

    public float getXdotlength(int n) {
        return (float)n / this.mAbstCanvas.mDotPerLen;
    }

    public void forceImageUpdate() {
    }

    protected boolean isChengeCanvasSize() {
        if (this.mBufferImage == null || this.mBufferGraphics == null) {
            return true;
        }
        return this.mAbstCanvas.mDimension.width != this.mBufferImage.getWidth(this) || this.mAbstCanvas.mDimension.height != this.mBufferImage.getHeight(this);
    }
}

