/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui;

import com.kt.gui.event.AccelKey;
import com.kt.io.AbstFile;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KKeyEvent;
import jp.kitec.kwt.KRichGraphics;
import jp.kitec.kwt.KViewPort;
import nethome.NethomeLookAndFeel;
import nethome.doc.Document;
import nethome.doc.Project;
import nethome.geom.AreaControl;
import nethome.geom.WorkSheet;
import nethome.geom.primitive.Geometory;
import nethome.ui.CanvasBase;
import nethome.ui.MainComponent;
import nethome.ui.command.Command;

public class Canvas2D
extends CanvasBase
implements MouseListener,
MouseMotionListener {
    public static final short DRAW_FULL = 0;
    public static final short DRAW_SIMPLE = 1;
    public static final short DRAW_LINE = 2;
    public static final Cursor MOUSE_DEF = new Cursor(0);
    public static final Cursor MOUSE_WAIT = new Cursor(3);
    public static final Cursor MOUSE_MOVE = new Cursor(13);
    public static final Cursor MOUSE_HAND = new Cursor(12);
    public static final Cursor MOUSE_CROSS = new Cursor(1);
    protected boolean mDispGrid = true;
    protected Vector2 mAdditionalDrawGeoms = new Vector2();
    protected Object mSelectObject;
    protected PopupMenu mPopup;
    protected Point mCurrentMouse;
    protected Point mPopUpPos;
    protected Vector mOptionalDrawElement;
    protected Vector mOptionalDrawElementDependCanvas;
    protected boolean mDispContext = false;
    protected short mDrawMode = 0;
    private long an = 0L;

    public Canvas2D() {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mPopup = new PopupMenu();
        this.mPopUpPos = new Point(0, 0);
        this.mCurrentMouse = new Point();
        this.mOptionalDrawElement = new Vector();
        this.mOptionalDrawElementDependCanvas = new Vector();
        this.add(this.mPopup);
    }

    public void setDocument(Document document) {
        this.mDoc = document;
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.resetView();
    }

    public Document getDocument() {
        return this.mDoc;
    }

    public Project getProject() {
        return this.mDoc.getProject();
    }

    public void setSelectObject(Object object) {
        this.mSelectObject = object;
        this.repaint();
    }

    public Object getSelectObject() {
        return this.mSelectObject;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public void showContext(int n, int n2) {
        PopupMenu popupMenu = this.getPopupMenu();
        this.mPopUpPos.setLocation(n, n2);
        if (popupMenu != null) {
            popupMenu.show(this, n, n2);
        }
        this.mDispContext = true;
    }

    public PopupMenu getPopupMenu() {
        return this.mPopup;
    }

    public Point getPopupPos() {
        return this.mPopUpPos;
    }

    public void endContext() {
        this.mDispContext = false;
        this.requestFocus();
    }

    public boolean isShowContext() {
        return this.mDispContext;
    }

    public Vector getOptionalDrawList() {
        return this.mOptionalDrawElement;
    }

    public Vector getOptionalDrawListCanvasDepend() {
        return this.mOptionalDrawElementDependCanvas;
    }

    public void addOptionalDrawObject(Object object) {
        if (this.mOptionalDrawElement.contains(object)) {
            return;
        }
        this.mOptionalDrawElement.addElement(object);
    }

    public void addOptionalDrawObjectCanvasDepend(Object object) {
        if (this.mOptionalDrawElementDependCanvas.contains(object)) {
            return;
        }
        this.mOptionalDrawElementDependCanvas.addElement(object);
    }

    public void removeOptionalDrawObject(Object object) {
        if (!this.mOptionalDrawElement.contains(object)) {
            return;
        }
        this.mOptionalDrawElement.removeElement(object);
    }

    public void removeOptionalDrawObjectCanvasDepend(Object object) {
        if (!this.mOptionalDrawElementDependCanvas.contains(object)) {
            return;
        }
        this.mOptionalDrawElementDependCanvas.removeElement(object);
    }

    public void addAdditionalDrawingGeometory(Geometory geometory) {
        if (this.mAdditionalDrawGeoms.contains((Object)geometory)) {
            return;
        }
        this.mAdditionalDrawGeoms.addElement((Object)geometory);
    }

    public void removeAdditionalDrawingGeometory(Geometory geometory) {
        if (!this.mAdditionalDrawGeoms.contains((Object)geometory)) {
            return;
        }
        this.mAdditionalDrawGeoms.removeElement((Object)geometory);
    }

    public void removeAllAdditionalDrawingGeometory() {
        this.mAdditionalDrawGeoms.removeAllElements();
    }

    public static KViewPort readData(AbstFile abstFile, Document document, float f) throws Exception {
        document = new KViewPort();
        Object object = new StringTokenizer(abstFile.readLineFromBuffer(), " ,");
        ((KViewPort)document).x1 = Float.valueOf((String)((StringTokenizer)object).nextElement()).floatValue();
        ((KViewPort)document).y1 = Float.valueOf((String)((StringTokenizer)object).nextElement()).floatValue();
        ((KViewPort)document).x2 = Float.valueOf((String)((StringTokenizer)object).nextElement()).floatValue();
        ((KViewPort)document).y2 = Float.valueOf((String)((StringTokenizer)object).nextElement()).floatValue();
        while ((object = abstFile.readLineFromBuffer()) != null && object != null && !((String)object).trim().equalsIgnoreCase("</VIEW>")) {
        }
        return document;
    }

    public void saveGeom(AbstFile abstFile, String string) throws Exception {
        Canvas2D canvas2D = canvas2D.getViewPort();
        String string2 = new StringBuffer(String.valueOf(string)).append(" ").toString();
        abstFile.writeStringToBuffer(new StringBuffer(String.valueOf(string)).append("<VIEW>\r\n").toString());
        abstFile.writeStringToBuffer(string2);
        abstFile.writeStringToBuffer(new StringBuffer(String.valueOf(((KViewPort)canvas2D).x1)).append("f,").append(((KViewPort)canvas2D).y1).append("f,").append(((KViewPort)canvas2D).x2).append("f,").append(((KViewPort)canvas2D).y2).append("f\r\n").toString());
        abstFile.writeStringToBuffer(new StringBuffer(String.valueOf(string)).append("</VIEW>\r\n").toString());
    }

    public void save(ObjectFolder objectFolder) {
    }

    public void load(ObjectFolder objectFolder) {
    }

    public void updateView() {
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.forceImageUpdate();
        this.repaint();
    }

    public KViewPort getViewPort() {
        if (((Canvas2D)((Object)project)).mDoc == null || ((Canvas2D)((Object)project)).mDoc.getProject() == null) {
            return ((Canvas2D)((Object)project)).mAbstCanvas.getViewPort();
        }
        Project project = ((Canvas2D)((Object)project)).mDoc.getProject();
        return project.getCurrentLayer().getViewPort();
    }

    public void setZoomAsScale(float f) {
        Project project = this.mDoc.getProject();
        KViewPort kViewPort = this.mAbstCanvas.getViewPort();
        if (kViewPort != null && this.mAbstCanvas.mDimension != null) {
            float f2 = project.getCurrentLayer().getWorkSheet().getModule();
            project = project.getCurrentLayer().getWorkSheet().getArea();
            float f3 = ((Area)project).maxX + f2 - (((Area)project).minX - f2);
            float f4 = ((Area)project).maxY + f2 - (((Area)project).minY - f2);
            float f5 = f2 /= 10.0f;
            if (f3 > f4) {
                f2 = f3 * 100.0f / f / 2.0f;
            } else {
                f5 = f4 * 100.0f / f / 2.0f;
            }
            this.mAbstCanvas.setView(kViewPort.cx - f2, kViewPort.cy - f5, kViewPort.cx + f2, kViewPort.cy + f5);
        }
    }

    public int getZoomRatio() {
        float f;
        float f2;
        Object object = this.getViewPort();
        if (object == null) {
            return 0;
        }
        object = this.mDoc.getProject();
        if (this.mAbstCanvas.mDimension == null) {
            return 100;
        }
        Area area = ((Project)object).getCurrentLayer().getWorkSheet().getArea();
        float f3 = ((Project)object).getCurrentLayer().getWorkSheet().getModule();
        float f4 = area.maxX + f3 - (area.minX - f3);
        if (f4 > (f3 = area.maxY + f3 - (area.minY - f3))) {
            f2 = this.mAbstCanvas.devToRealX(0);
            f = this.mAbstCanvas.devToRealX(this.mAbstCanvas.mDimension.width);
            f2 = f - f2;
            f = f4;
        } else {
            f2 = this.mAbstCanvas.devToRealY(this.mAbstCanvas.mDimension.height);
            f = this.mAbstCanvas.devToRealY(0);
            f2 = f - f2;
            f = f3;
        }
        return (int)(f / f2 * 100.0f);
    }

    public WorkSheet getWorkSheet() {
        Project project = ((Canvas2D)((Object)project)).mDoc.getProject();
        if (project != null) {
            return project.getCurrentLayer().getWorkSheet();
        }
        return null;
    }

    public void resetView() {
        KViewPort kViewPort = this.getViewPort();
        if (kViewPort != null) {
            Project project = this.mDoc.getProject();
            float f = project.getCurrentLayer().getWorkSheet().getModule();
            project = project.getCurrentLayer().getWorkSheet().getArea();
            kViewPort.x1 = ((Area)project).minX - f;
            kViewPort.y1 = ((Area)project).minY - f;
            kViewPort.x2 = ((Area)project).maxX + f;
            kViewPort.y2 = ((Area)project).maxY + f;
            kViewPort.cx = (kViewPort.x1 + kViewPort.x2) / 2.0f;
            kViewPort.cy = (kViewPort.y1 + kViewPort.y2) / 2.0f;
            this.mAbstCanvas.setView(kViewPort.x1, kViewPort.y1, kViewPort.x2, kViewPort.y2, this.mAbstCanvas.mDimension);
            this.forceImageUpdate();
            this.repaint();
        }
    }

    public void setDispGrid(boolean bl) {
        this.mDispGrid = bl;
        this.forceImageUpdate();
        this.repaint();
    }

    public boolean isDispGrid() {
        return this.mDispGrid;
    }

    public void paint(Graphics graphics) {
        if (this.mDoc == null) {
            return;
        }
        this.update(graphics);
    }

    public void setDrawMode(short s) {
        this.mDrawMode = s;
    }

    public short getDrawMode() {
        return this.mDrawMode;
    }

    public void update(Graphics graphics) {
        if (this.mDoc == null) {
            return;
        }
        this.createOffGraphics();
        this.mAbstCanvas.updateViewScale(this.mAbstCanvas.mDimension);
        this.drawPlan();
        this.mAbstCanvas.setGC(this.mOffGraphics);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.drawCommand((IRichGraphics)this.mAbstCanvas);
        }
        if (this.mActiveCommand != null) {
            this.mActiveCommand.drawCommand((IRichGraphics)this.mAbstCanvas);
        }
        super.paint(this.mOffGraphics);
        this.mAbstCanvas.setGC(null);
        graphics.drawImage(this.mOffImage, 0, 0, this);
    }

    protected void drawPlan() {
        if (this.isChengeCanvasSize()) {
            this.forceImageUpdate();
        }
        this.mAbstCanvas.setGC(this.mOffGraphics);
        this.forceCurrentRepaint(this.mAbstCanvas);
        this.drawSelectedObject(this.mAbstCanvas);
        this.mAbstCanvas.setGC(null);
    }

    protected void createOffGraphics() {
        this.mAbstCanvas.setSize(this.getSize().width, this.getSize().height);
        if (this.mOffImage == null || this.mOffImage.getWidth(this) != this.mAbstCanvas.mDimension.width || this.mOffImage.getHeight(this) != this.mAbstCanvas.mDimension.height) {
            if (this.mOffGraphics != null) {
                this.mOffGraphics.dispose();
            }
            if (this.mOffImage != null) {
                this.mOffImage.flush();
            }
            this.mOffImage = this.createImage(this.mAbstCanvas.mDimension.width, this.mAbstCanvas.mDimension.height);
            this.mOffGraphics = this.mOffImage.getGraphics();
        }
    }

    public void forceCurrentRepaint(KRichGraphics kRichGraphics) {
        kRichGraphics.drawBufferImage(this.mBufferImage);
        int n = 0;
        while (n < this.mAdditionalDrawGeoms.size()) {
            ((Geometory)this.mAdditionalDrawGeoms.elementAt(n)).drawGeom((IRichGraphics)kRichGraphics);
            ++n;
        }
    }

    protected void drawSelectedObject(KRichGraphics kRichGraphics) {
        if ((this = ((Canvas2D)this).getSelectObject()) != null && this instanceof Geometory) {
            AreaControl areaControl = ((Geometory)this).getAreaControl();
            if (areaControl != null) {
                areaControl.drawGeomHilight((IRichGraphics)kRichGraphics);
                return;
            }
            ((Geometory)this).drawHighLight((IRichGraphics)kRichGraphics, NethomeLookAndFeel.SELECT_CADELEM_COLOR, false);
        }
    }

    protected void drawOptionalObject(KRichGraphics kRichGraphics) {
        int n = 0;
        while (n < this.mOptionalDrawElement.size()) {
            Object e = this.mOptionalDrawElement.elementAt(n);
            if (e instanceof Geometory) {
                ((Geometory)e).drawGeom((IRichGraphics)kRichGraphics);
            } else if (e instanceof Command) {
                ((Command)e).drawCommand((IRichGraphics)kRichGraphics);
            }
            ++n;
        }
    }

    protected void drawOptionalObjectCanvasDepend(KRichGraphics kRichGraphics) {
        int n = 0;
        while (n < this.mOptionalDrawElementDependCanvas.size()) {
            Object e = this.mOptionalDrawElementDependCanvas.elementAt(n);
            if (e instanceof Geometory) {
                ((Geometory)e).drawGeom((IRichGraphics)kRichGraphics);
            } else if (e instanceof Command) {
                ((Command)e).drawCommand((IRichGraphics)kRichGraphics);
            }
            ++n;
        }
    }

    protected void drawGrid(KRichGraphics kRichGraphics, boolean bl) {
    }

    public synchronized void forceImageUpdate() {
        if (this.mAbstCanvas.mDimension == null) {
            return;
        }
        this.mAbstCanvas.updateViewScale(this.mAbstCanvas.mDimension);
        if (this.mBufferImage != null && this.mBufferGraphics != null) {
            int n = this.mBufferImage.getWidth(this);
            int n2 = this.mBufferImage.getHeight(this);
            if (this.mAbstCanvas.mDimension.width != n || this.mAbstCanvas.mDimension.height != n2) {
                this.mBufferImage.flush();
                this.mBufferGraphics.dispose();
                this.mBufferGraphics = null;
                this.mBufferImage = null;
            }
        }
        if (this.mBufferImage == null) {
            this.mBufferImage = this.createImage(this.mAbstCanvas.mDimension.width, this.mAbstCanvas.mDimension.height);
            this.mBufferGraphics = this.mBufferImage.getGraphics();
        }
        this.mAbstCanvas.setGC(this.mBufferGraphics);
        this.mAbstCanvas.setColor(this.mBackColor);
        float f = this.mAbstCanvas.devToRealX(-1);
        float f2 = this.mAbstCanvas.devToRealY(-1);
        float f3 = this.mAbstCanvas.devToRealX(this.mAbstCanvas.mDimension.width + 2);
        float f4 = this.mAbstCanvas.devToRealY(this.mAbstCanvas.mDimension.height + 2);
        this.mAbstCanvas.drawFillRect(f, f2, f3, f4, null);
        this.drawGrid(this.mAbstCanvas, this.mDispGrid);
        this.mAbstCanvas.setGC(null);
    }

    protected void drawPreGridObject(IRichGraphics iRichGraphics) {
    }

    protected void drawPostGridObject(IRichGraphics iRichGraphics) {
    }

    public Point getCurrentMousePos() {
        return this.mCurrentMouse;
    }

    public void mouseWheelUp(MouseEvent mouseEvent) {
        if (this.mViewControlCommand != null) {
            this.mViewControlCommand.wheelUp(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseWheelDown(MouseEvent mouseEvent) {
        if (this.mViewControlCommand != null) {
            this.mViewControlCommand.wheelDown(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void updateCurrentMousePos(MouseEvent mouseEvent) {
        this.mCurrentMouse.x = mouseEvent.getX();
        this.mCurrentMouse.y = mouseEvent.getY();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mActiveMaskCommand != null) {
            return;
        }
        this.updateCurrentMousePos(mouseEvent);
        if (this.mActiveMaskCommand != null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.an < 300L && this.mActiveCommand != null) {
            this.mActiveCommand.mouseDoubleClicked(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
        this.an = l;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mousePress(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
            return;
        }
        if (this.mActiveCommand != null) {
            this.mActiveCommand.mousePress(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseRelease(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
            return;
        }
        if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseRelease(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseDrag(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
            return;
        }
        if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseDrag(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseMove(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
            return;
        }
        if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseMove(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
    }

    public void keyPress(KeyEvent object) {
        MainComponent mainComponent = MainComponent.getInstance();
        int n = ((KeyEvent)object).getKeyCode();
        int n2 = ((InputEvent)object).getModifiers();
        if (this.mActiveCommand != null && this.mActiveCommand.keyPress(n, n2)) {
            return;
        }
        if (this.mAllowCommand != null && (KKeyEvent.isMutchKey((int)n, (String)"UP") || KKeyEvent.isMutchKey((int)n, (String)"DOWN") || KKeyEvent.isMutchKey((int)n, (String)"LEFT") || KKeyEvent.isMutchKey((int)n, (String)"RIGHT") || KKeyEvent.isMutchKey((int)n, (String)"PAGE_UP") || KKeyEvent.isMutchKey((int)n, (String)"PAGE_DOWN") || KKeyEvent.isMutchKey((int)n, (String)"HOME")) && this.mAllowCommand.keyPress(n, n2)) {
            return;
        }
        AccelKey accelKey = mainComponent.getAccel((KeyEvent)object);
        if (accelKey != null) {
            ((Command)accelKey.getObject()).accelerate();
            if (this.mActiveCommand != null) {
                this.mActiveCommand.restoration();
            }
            if (this.mActiveMaskCommand != null) {
                this.mActiveMaskCommand.end();
                this.mActiveMaskCommand = null;
            }
            return;
        }
        if (KKeyEvent.isMutchKey((int)((KeyEvent)object).getKeyCode(), (String)"ESCAPE")) {
            if (this.mActiveCommand != null) {
                this.mActiveCommand.restoration();
            }
            this.setMouseCommand(null);
            this.repaint();
            return;
        }
        if ((object = mainComponent.getMaskCommand(((InputEvent)object).getModifiers())) != this.mActiveMaskCommand) {
            if (this.mActiveMaskCommand != null) {
                this.mActiveMaskCommand.end();
            }
            this.mActiveMaskCommand = object;
            if (this.mActiveMaskCommand != null) {
                if (this.mActiveCommand != null) {
                    this.mActiveCommand.restoration();
                }
                this.mActiveMaskCommand.play();
            }
        }
    }

    public void keyRelease(KeyEvent keyEvent) {
        MainComponent mainComponent = MainComponent.getInstance();
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.end();
            this.mActiveMaskCommand = null;
        }
        this.mActiveMaskCommand = mainComponent.getMaskCommand(keyEvent.getModifiers());
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.play();
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseMove(this.mCurrentMouse.x, this.mCurrentMouse.y, keyEvent.getModifiers());
        }
        this.repaint();
    }
}

