/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.util;

public class ToolMath {
    public static final float EPS = 0.001f;
    public static final float D2R = (float)Math.PI / 180;

    public static float kirisute(float f, int n) {
        float f2 = (float)Math.pow(10.0, n - 1);
        return (float)(Math.floor(f * f2) / (double)f2);
    }

    public static float getNaiseki(float f, float f2, float f3, float f4, float f5, float f6) {
        f3 -= f;
        f4 -= f2;
        f = f5 - f;
        f2 = f6 - f2;
        return f3 * f2 - f * f4;
    }

    public static double getAnglGapDeg(double d, double d2) {
        return ToolMath.getAngl360(d2 -= d);
    }

    public static double getAnglGapRad(double d, double d2) {
        d = ToolMath.getAngl2PI(d);
        d2 = ToolMath.getAngl2PI(d2);
        return Math.abs(d - d2);
    }

    public static boolean isInnerAngl2PI(double d, double d2, double d3) {
        return ToolMath.isInnderAngl360(ToolMath.getAngl360(d), ToolMath.getAngl360(d2), ToolMath.getAngl360(d3));
    }

    public static boolean isInnderAngl360(double d, double d2, double d3) {
        double d4 = d2;
        while (d > d4) {
            d4 += 360.0;
        }
        double d5 = d - d;
        d4 -= d;
        double d6 = d3 - d;
        while (d6 < 0.0) {
            d6 += 360.0;
        }
        return d5 < d6 && d6 < d4;
    }

    public static double getLengthToArcStartEnd(double d, double d2, double d3, double d4, float f, float f2) {
        double d5 = d + d3 * Math.cos(d4 * 0.01745329238474369);
        double d6 = d2 + d3 * Math.sin(d4 * 0.01745329238474369);
        return ToolMath.getLength2D(f, f2, d5, d6);
    }

    public static double rachet(double d, int n) {
        d += (double)((float)Math.PI * 2 / (float)n);
        while (d >= Math.PI * 2) {
            d -= Math.PI * 2;
        }
        int n2 = 0;
        while (n2 < n + 1) {
            if (Math.abs(d - (double)n2 * Math.PI * 2.0 / (double)n) < Math.PI / (double)n) {
                d = (float)(Math.PI * 2 / (double)n * (double)n2);
                break;
            }
            ++n2;
        }
        return d;
    }

    public static double getAngle2Lines(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = ToolMath.getAngle2D(d3, d4, d, d2);
        double d8 = ToolMath.getAngle2D(d3, d4, d5, d6);
        return ToolMath.getAngl2PI(d8 -= d7);
    }

    public static double getAngle2D(double d, double d2, double d3, double d4) {
        int n;
        double d5 = d3 - d;
        double d6 = d4 - d2;
        if (d5 >= 0.0) {
            if (d6 >= 0.0) {
                n = 0;
            } else {
                n = 3;
                double d7 = d5;
                d5 = -d6;
                d6 = d7;
            }
        } else if (d6 >= 0.0) {
            n = 1;
            double d8 = d5;
            d5 = d6;
            d6 = -d8;
        } else {
            n = 2;
            d5 = -d5;
            d6 = -d6;
        }
        double d9 = d6 > d5 ? 1.5707963267948966 - Math.atan(d5 / d6) : Math.atan(d6 / d5);
        return d9 + (double)n * 1.5707963267948966;
    }

    public static double getX(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = ToolMath.getAngle2D(d3, d4, d5, d6);
        double d8 = Math.cos(d7);
        double d9 = Math.sin(d7);
        return ToolMath.norm((d -= d3) * d8 + (d2 -= d4) * d9);
    }

    public static boolean inIncludeLine(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return ToolMath.isOnLimitLinePoint2D(d, d2, d5, d6, d7, d8) && ToolMath.isOnLimitLinePoint2D(d3, d4, d5, d6, d7, d8);
    }

    public static double getY(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = ToolMath.getAngle2D(d3, d4, d5, d6);
        double d8 = Math.cos(d7);
        double d9 = Math.sin(d7);
        return ToolMath.norm(-(d -= d3) * d9 + (d2 -= d4) * d8);
    }

    public static int getQuadrant(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = ToolMath.getAngle2D(d3, d4, d5, d6);
        double d10 = ToolMath.getAngle2D(d3, d4, d, d2);
        double d11 = d8 = d7 - d9 < 0.0 ? d10 - d9 + Math.PI * 2 : d10 - d9;
        if (d11 >= 0.0 && d8 < 1.5707963267948966) {
            return 1;
        }
        if (d8 >= 1.5707963267948966 && d8 < Math.PI) {
            return 2;
        }
        if (d8 >= Math.PI && d8 < 4.71238898038469) {
            return 3;
        }
        return 4;
    }

    public static double getAngl2PI(double d) {
        if (Math.abs(d) < (double)0.001f) {
            d = 0.0;
        }
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        while (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        return d;
    }

    public static double getAngl360(double d) {
        while (d < 0.0) {
            d += 360.0;
        }
        while (d > 360.0) {
            d -= 360.0;
        }
        return d;
    }

    public static void rotation2D(double d, double d2, double d3, double d4, double d5, float[] fArray) {
        double d6 = Math.cos(-d3);
        double d7 = Math.sin(-d3);
        d4 -= d;
        d5 -= d2;
        if (fArray != null) {
            fArray[0] = ToolMath.norm(d4 * d6 + d5 * d7 + d);
            fArray[1] = ToolMath.norm(-d4 * d7 + d5 * d6 + d2);
        }
    }

    public static double getLength2D(double d, double d2, double d3, double d4) {
        return ToolMath.norm(Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4)));
    }

    public static boolean isSame2D(double d, double d2, double d3, double d4) {
        return Math.abs(d3 - d) < (double)0.001f && Math.abs(d4 - d2) < (double)0.001f;
    }

    public static boolean isSameLine(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return ToolMath.isSame2D(d, d2, d5, d6) && ToolMath.isSame2D(d3, d4, d7, d8) || ToolMath.isSame2D(d, d2, d7, d8) && ToolMath.isSame2D(d3, d4, d5, d6);
    }

    public static boolean isIncludeLine(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return ToolMath.isOnLimitLinePoint2D(d, d2, d5, d6, d7, d8) && ToolMath.isOnLimitLinePoint2D(d3, d4, d5, d6, d7, d8);
    }

    public static boolean isRelatePara2Line(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (!ToolMath.isOnLine(d, d2, d3, d4, d5, d6, d7, d8)) {
            return false;
        }
        return ToolMath.isOnLimitLinePoint2D(d, d2, d5, d6, d7, d8) || ToolMath.isOnLimitLinePoint2D(d3, d4, d5, d6, d7, d8) || ToolMath.isOnLimitLinePoint2D(d5, d6, d, d2, d3, d4) || ToolMath.isOnLimitLinePoint2D(d7, d8, d, d2, d3, d4);
    }

    public static boolean isVerticalLimitLineToPoint2D(double d, double d2, double d3, double d4, double d5, double d6, float[] fArray) {
        double d7;
        double d8 = d3 - d;
        double d9 = d4 - d2;
        double d10 = d5 - d3;
        double d11 = d6 - d4;
        double d12 = d10 * d10 + d11 * d11;
        double d13 = -(d8 * d10 + d9 * d11) / d12;
        if (d7 >= 0.0 && d13 <= 1.0) {
            if (fArray != null) {
                double d14 = d8 + d13 * d10;
                double d15 = d9 + d13 * d11;
                fArray[0] = (float)(d + d14);
                fArray[1] = (float)(d2 + d15);
            }
            return true;
        }
        return false;
    }

    public static boolean isCrossPointVertLimitlessLineToPoint2D(double d, double d2, double d3, double d4, double d5, double d6, float[] fArray) {
        double d7;
        double d8 = ToolMath.getLineEquatin2Da(d3, d4, d5, d6);
        double d9 = ToolMath.getLineEquatin2Db(d3, d4, d5, d6);
        double d10 = ToolMath.getLineEquatin2Dc(d3, d4, d5, d6);
        double d11 = -d8;
        double d12 = d8 * d2 - d9 * d;
        double d13 = d8 * d11 - d9 * d9;
        if (Math.abs(d7) < (double)0.001f) {
            return false;
        }
        if (fArray != null) {
            fArray[0] = ToolMath.norm((d9 * d12 - d11 * d10) / d13);
            fArray[1] = ToolMath.norm((d9 * d10 - d8 * d12) / d13);
        }
        return true;
    }

    public static double getLengthLimitLineToPoint2D(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = d3 - d;
        double d9 = d4 - d2;
        double d10 = d5 - d3;
        double d11 = d6 - d4;
        double d12 = d10 * d10 + d11 * d11;
        double d13 = -(d8 * d10 + d9 * d11) / d12;
        if (d7 >= 0.0 && d13 <= 1.0) {
            double d14 = d8 + d13 * d10;
            double d15 = d9 + d13 * d11;
            return ToolMath.norm(Math.sqrt(d14 * d14 + d15 * d15));
        }
        return -1.0;
    }

    public static double getLengthLimitlessLineToPoint2D(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (ToolMath.isSame2D(d3, d4, d5, d6)) {
            return -1.0;
        }
        double d8 = ToolMath.getLineEquatin2Da(d3, d4, d5, d6);
        double d9 = ToolMath.getLineEquatin2Db(d3, d4, d5, d6);
        double d10 = ToolMath.getLineEquatin2Dc(d3, d4, d5, d6);
        double d11 = d8 * d8 + d9 * d9;
        if (d7 < (double)0.001f) {
            return -1.0;
        }
        double d12 = d8 * d + d9 * d2 + d10;
        return ToolMath.norm(Math.sqrt(d12 * d12 / d11));
    }

    public static boolean isPointPickUporDown(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = ToolMath.getLineEquatin2Da(d3, d4, d5, d6);
        return d9 * d + (d8 = ToolMath.getLineEquatin2Db(d3, d4, d5, d6)) * d2 + (d7 = ToolMath.getLineEquatin2Dc(d3, d4, d5, d6)) >= 0.0;
    }

    public static void getOffsetPoint2D(double d, double d2, double d3, double d4, double d5, double d6, float[] fArray) {
        double d7 = ToolMath.getAngle2D(d, d2, d3, d4);
        if (fArray != null) {
            fArray[0] = ToolMath.norm(d + d5 * Math.cos(d7) + d6 * Math.cos(d7 + 1.5707963267948966));
            fArray[1] = ToolMath.norm(d2 + d5 * Math.sin(d7) + d6 * Math.sin(d7 + 1.5707963267948966));
        }
    }

    public static void getOffsetLength2D(double d, double d2, double d3, double d4, double d5, double d6, float[] fArray) {
        double d7 = ToolMath.getAngle2D(d, d2, d3, d4);
        if (fArray != null) {
            fArray[0] = (float)(d5 * Math.cos(d7) + d6 * Math.cos(d7 + 1.5707963267948966));
            fArray[1] = (float)(d5 * Math.sin(d7) + d6 * Math.sin(d7 + 1.5707963267948966));
        }
    }

    public static double get3PointCircle(float f, float f2, float f3, float f4, float f5, float f6, float[] fArray) {
        float f7 = (f3 + f) / 2.0f;
        float f8 = (f4 + f2) / 2.0f;
        float f9 = (f5 + f) / 2.0f;
        float f10 = (f6 + f2) / 2.0f;
        if (ToolMath.isCrossInfinity(f7, f8, f4 = f7 - (f4 - f2), f3 = f8 + (f3 - f), f9, f10, f6 = f9 - (f6 - f2), f5 = f10 + (f5 - f), fArray)) {
            return ToolMath.getLength2D(fArray[0], fArray[1], f, f2);
        }
        return -1.0;
    }

    public static double get2LineArc(float f, float f2, float f3, float f4, float f5, float f6, float[] fArray) {
        float f7 = f - (f4 - f2);
        float f8 = f2 + (f3 - f);
        if (ToolMath.isCrossInfinity(f, f2, f7, f8, f5, f6, f4 = f5 - (f6 - f4), f3 = f6 + (f5 - f3), fArray)) {
            return ToolMath.getLength2D(fArray[0], fArray[1], f, f2);
        }
        return -1.0;
    }

    public static boolean isCrossSegment(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, float[] fArray) {
        double d9;
        double d10 = d3 - d;
        double d11 = d4 - d2;
        double d12 = d7 - d5;
        double d13 = d8 - d6;
        double d14 = d5 - d;
        double d15 = d6 - d2;
        double d16 = d12 * d11 - d13 * d10;
        if (Math.abs(d9) < (double)0.001f) {
            return false;
        }
        double d17 = (d12 * d15 - d13 * d14) / d16;
        double d18 = (d10 * d15 - d11 * d14) / d16;
        if (d17 < (double)-0.001f || d17 > 1.0010000000474975 || d18 < (double)-0.001f || d18 > 1.0010000000474975) {
            return false;
        }
        if (fArray != null) {
            fArray[0] = ToolMath.norm(d + d10 * d17);
            fArray[1] = ToolMath.norm(d2 + d11 * d17);
        }
        return true;
    }

    public static boolean isCrossInfinity(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, float[] fArray) {
        double d9;
        double d10 = ToolMath.getLineEquatin2Da(d, d2, d3, d4);
        double d11 = ToolMath.getLineEquatin2Db(d, d2, d3, d4);
        double d12 = ToolMath.getLineEquatin2Dc(d, d2, d3, d4);
        double d13 = ToolMath.getLineEquatin2Da(d5, d6, d7, d8);
        double d14 = ToolMath.getLineEquatin2Db(d5, d6, d7, d8);
        double d15 = ToolMath.getLineEquatin2Dc(d5, d6, d7, d8);
        double d16 = d10 * d14 - d13 * d11;
        if (Math.abs(d9) < (double)0.001f) {
            return false;
        }
        if (fArray != null) {
            fArray[0] = ToolMath.norm((d11 * d15 - d14 * d12) / d16);
            fArray[1] = ToolMath.norm((d13 * d12 - d10 * d15) / d16);
        }
        return true;
    }

    public static boolean isCrossInfinity(double d, double d2, double d3, double d4, double d5, double d6, float[] fArray) {
        double d7;
        double d8 = d * d5 - d4 * d2;
        if (Math.abs(d7) < (double)0.001f) {
            return false;
        }
        if (fArray != null) {
            fArray[0] = ToolMath.norm((d2 * d6 - d5 * d3) / d8);
            fArray[1] = ToolMath.norm((d4 * d3 - d * d6) / d8);
        }
        return true;
    }

    public static boolean isCrossInfinityPointAndAngle(double d, double d2, double d3, double d4, double d5, double d6, float[] fArray) {
        double d7 = d + 100.0 * Math.cos(d3);
        double d8 = d2 + 100.0 * Math.sin(d3);
        double d9 = d4 + 100.0 * Math.cos(d6);
        double d10 = d5 + 100.0 * Math.sin(d6);
        return ToolMath.isCrossInfinity(d, d2, d7, d8, d4, d5, d9, d10, fArray);
    }

    public static boolean isCrossXandLimitLine(double d, double d2, double d3, double d4, double d5, float[] fArray) {
        float f;
        float f2;
        double d6;
        double d7 = ToolMath.getLineEquatin2Da(d, 0.0, d, 100.0);
        double d8 = ToolMath.getLineEquatin2Db(d, 0.0, d, 100.0);
        double d9 = ToolMath.getLineEquatin2Dc(d, 0.0, d, 100.0);
        double d10 = ToolMath.getLineEquatin2Da(d2, d3, d4, d5);
        double d11 = ToolMath.getLineEquatin2Db(d2, d3, d4, d5);
        double d12 = ToolMath.getLineEquatin2Dc(d2, d3, d4, d5);
        double d13 = d7 * d11 - d10 * d8;
        if (Math.abs(d6) < (double)0.001f) {
            return false;
        }
        if (fArray != null && ToolMath.isOnLimitLinePoint2D(f2 = ToolMath.norm((d8 * d12 - d11 * d9) / d13), f = ToolMath.norm((d10 * d9 - d7 * d12) / d13), d2, d3, d4, d5)) {
            fArray[0] = f2;
            fArray[1] = f;
            return true;
        }
        return false;
    }

    public static boolean isCrossYandLimitLine(double d, double d2, double d3, double d4, double d5, float[] fArray) {
        float f;
        float f2;
        double d6;
        double d7 = ToolMath.getLineEquatin2Da(0.0, d, 100.0, d);
        double d8 = ToolMath.getLineEquatin2Db(0.0, d, 100.0, d);
        double d9 = ToolMath.getLineEquatin2Dc(0.0, d, 100.0, d);
        double d10 = ToolMath.getLineEquatin2Da(d2, d3, d4, d5);
        double d11 = ToolMath.getLineEquatin2Db(d2, d3, d4, d5);
        double d12 = ToolMath.getLineEquatin2Dc(d2, d3, d4, d5);
        double d13 = d7 * d11 - d10 * d8;
        if (Math.abs(d6) < (double)0.001f) {
            return false;
        }
        if (fArray != null && ToolMath.isOnLimitLinePoint2D(f2 = ToolMath.norm((d8 * d12 - d11 * d9) / d13), f = ToolMath.norm((d10 * d9 - d7 * d12) / d13), d2, d3, d4, d5)) {
            fArray[0] = f2;
            fArray[1] = f;
            return true;
        }
        return false;
    }

    public static boolean isOnLine(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = ToolMath.getLengthLimitlessLineToPoint2D(d5, d6, d, d2, d3, d4);
        double d10 = ToolMath.getLengthLimitlessLineToPoint2D(d7, d8, d, d2, d3, d4);
        return d9 >= 0.0 && d9 < (double)0.001f && d10 >= 0.0 && d10 < (double)0.001f;
    }

    public static boolean isOnLimitLinePoint2D(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (ToolMath.isSame2D(d, d2, d3, d4) || ToolMath.isSame2D(d, d2, d5, d6)) {
            return true;
        }
        double d8 = ToolMath.getLengthLimitLineToPoint2D(d, d2, d3, d4, d5, d6);
        return d7 < (double)0.001f && d8 >= 0.0;
    }

    public static boolean isParallel2D(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10 = ToolMath.getLineEquatin2Da(d, d2, d3, d4);
        double d11 = ToolMath.getLineEquatin2Db(d, d2, d3, d4);
        double d12 = ToolMath.getLineEquatin2Da(d5, d6, d7, d8);
        double d13 = ToolMath.getLineEquatin2Db(d5, d6, d7, d8);
        double d14 = d10 * d13 - d12 * d11;
        return Math.abs(d9) < (double)0.001f;
    }

    public static boolean get2LineOffsetCross(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, float[] fArray) {
        if (ToolMath.isParallel2D(d, d2, d3, d4, d3, d4, d5, d6)) {
            ToolMath.getOffsetPoint2D(d3, d4, d5, d6, 0.0, d7, fArray);
            return true;
        }
        ToolMath.getOffsetPoint2D(d, d2, d3, d4, 0.0, d7, fArray);
        double d9 = ToolMath.norm(fArray[0]);
        double d10 = ToolMath.norm(fArray[1]);
        ToolMath.getOffsetPoint2D(d3, d4, d, d2, 0.0, -d7, fArray);
        double d11 = ToolMath.norm(fArray[0]);
        double d12 = ToolMath.norm(fArray[1]);
        ToolMath.getOffsetPoint2D(d3, d4, d5, d6, 0.0, d8, fArray);
        double d13 = ToolMath.norm(fArray[0]);
        double d14 = ToolMath.norm(fArray[1]);
        ToolMath.getOffsetPoint2D(d5, d6, d3, d4, 0.0, -d8, fArray);
        double d15 = ToolMath.norm(fArray[0]);
        double d16 = ToolMath.norm(fArray[1]);
        return ToolMath.isCrossInfinity(d9, d10, d11, d12, d13, d14, d15, d16, fArray);
    }

    public static void getCrossPointEllipse(double d, double d2, double d3, double d4, double d5, double d6, float[] fArray) {
        double d7;
        double d8;
        if (d - d3 != 0.0) {
            double d9 = (d2 - d4) / (d - d3);
            d8 = d6 * d5 / Math.sqrt(Math.abs(d5 * d5 + d6 * d9 * d6 * d9));
            if (d - d3 < 0.0) {
                d8 = -d8;
            }
            d7 = d8 * d9;
        } else {
            d8 = 0.0;
            d7 = d2 - d4 >= 0.0 ? d5 : -d5;
        }
        double d10 = d7;
        fArray[0] = (float)(d8 + d3);
        fArray[1] = (float)(d10 + d4);
    }

    public static double getEllipseAngl(double d, double d2, double d3) {
        double d4 = Math.atan(d / d2 * Math.tan(d3));
        int n = ToolMath.getQuadrant(Math.cos(d3), Math.sin(d3), 0.0, 0.0, 100.0, 0.0);
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                if (d4 > 0.0) {
                    d4 = -d4;
                }
                d4 = (float)(d4 + Math.PI);
                break;
            }
            case 3: {
                if (d4 < 0.0) {
                    d4 = -d4;
                }
                d4 = (float)(d4 + Math.PI);
                break;
            }
            case 4: {
                if (d4 > 0.0) {
                    d4 = -d4;
                }
                d4 = (float)(d4 + Math.PI * 2);
            }
        }
        return d4;
    }

    protected static double getLineEquatin2Da(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = d5 * d5 + d6 * d6;
        double d8 = 1.0 / Math.sqrt(d7);
        return ToolMath.norm(-d6 * d8);
    }

    protected static double getLineEquatin2Db(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = d5 * d5 + d6 * d6;
        double d8 = 1.0 / Math.sqrt(d7);
        return ToolMath.norm(d5 * d8);
    }

    protected static double getLineEquatin2Dc(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = d5 * d5 + d6 * d6;
        double d8 = 1.0 / Math.sqrt(d7);
        return ToolMath.norm((d * d4 - d3 * d2) * d8);
    }

    protected static float norm(double d) {
        return (float)((double)Math.round(d * 1.0E8) / 1.0E8);
    }

    public static float normalizeVector(float[] fArray) {
        float f;
        float f2 = 1.0E-6f;
        float f3 = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        if (f > f2) {
            f2 = (float)(1.0 / (double)f3);
            fArray[0] = fArray[0] * f2;
            fArray[1] = fArray[1] * f2;
            fArray[2] = fArray[2] * f2;
        }
        return f3;
    }

    public static float getDistanceOn3D(float[] fArray, float[] fArray2) {
        float f = fArray[0] - fArray2[0];
        float f2 = fArray[1] - fArray2[1];
        float f3 = fArray[2] - fArray2[2];
        double d = f * f + f2 * f2 + f3 * f3;
        return (float)Math.sqrt(d);
    }

    public static void calcOuterProduct(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray[1] * fArray2[2] - fArray[2] * fArray2[1];
        fArray3[1] = fArray[2] * fArray2[0] - fArray[0] * fArray2[2];
        fArray3[2] = fArray[0] * fArray2[1] - fArray[1] * fArray2[0];
    }
}

