/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.primitive;

import com.kt.util.RefList;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.Color;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KFont;
import nethome.NethomeResource;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

public class GText
extends Geometory {
    private static final String GEOMNAME = "TEXT";
    public GPoint2Df mCp;
    public float mAngl;
    protected float mSize;
    protected String mText;
    public float mMinx;
    public float mMiny;
    public float mMaxx;
    public float mMaxy;
    protected String mScaleFontName;
    protected boolean mDir = true;
    protected boolean mFillBack = false;
    private Color mFillColor;
    protected boolean mBold = false;

    protected GText() {
        this.setGeomName(GEOMNAME);
        this.mCp = new GPoint2Df();
    }

    public GText(GPoint2Df gPoint2Df, String string, String string2, float f, float f2, boolean bl) {
        this();
        this.mCp.setXY(gPoint2Df.x, gPoint2Df.y);
        this.mAngl = f;
        this.mText = string2;
        this.mSize = f2;
        this.mScaleFontName = string;
        this.mBold = bl;
        this.mGeomColor = Color.black;
    }

    public void setFillMode(boolean bl, Color color) {
        this.mFillBack = bl;
        this.mFillColor = color;
    }

    public void updateMinMax(Area area) {
        area.updateMinMax(this.mMinx, this.mMiny);
        area.updateMinMax(this.mMaxx, this.mMaxy);
    }

    public Geometory getCopy() {
        return this.getCopy(new GText());
    }

    protected Geometory getCopy(Geometory geometory) {
        if (geometory == null || !(geometory instanceof GText)) {
            return null;
        }
        geometory = (GText)geometory;
        super.getCopy(geometory);
        ((GText)geometory).mCp = (GPoint2Df)this.mCp.getCopy();
        ((GText)geometory).mAngl = this.mAngl;
        ((GText)geometory).mText = new String(this.mText);
        ((GText)geometory).mSize = this.mSize;
        ((GText)geometory).mScaleFontName = this.mScaleFontName;
        ((GText)geometory).mBold = this.mBold;
        ((GText)geometory).setFillMode(this.mFillBack, this.mFillColor);
        ((GText)geometory).mDir = this.mDir;
        return geometory;
    }

    public float getDistanceToPoint(float f, float f2) {
        double d;
        double d2;
        double d3;
        double d4;
        if (f > this.mMinx && f < this.mMaxx && f2 > this.mMiny && f2 < this.mMaxy) {
            return 0.0f;
        }
        double d5 = Double.MAX_VALUE;
        double d6 = ToolMath.getLengthLimitLineToPoint2D(f, f2, this.mMinx, this.mMiny, this.mMaxx, this.mMiny);
        if (d4 >= 0.0) {
            d5 = Math.min(d6, d5);
        }
        d6 = ToolMath.getLengthLimitLineToPoint2D(f, f2, this.mMaxx, this.mMiny, this.mMaxx, this.mMaxy);
        if (d3 >= 0.0) {
            d5 = Math.min(d6, d5);
        }
        d6 = ToolMath.getLengthLimitLineToPoint2D(f, f2, this.mMaxx, this.mMaxy, this.mMinx, this.mMaxy);
        if (d2 >= 0.0) {
            d5 = Math.min(d6, d5);
        }
        d6 = ToolMath.getLengthLimitLineToPoint2D(f, f2, this.mMinx, this.mMaxy, this.mMinx, this.mMiny);
        if (d >= 0.0) {
            d5 = Math.min(d6, d5);
        }
        return (float)d5;
    }

    public void offset(float f, float f2) {
        this.mMinx += f;
        this.mMiny += f2;
        this.mMaxx += f;
        this.mMaxy += f2;
        this.mCp.x += f;
        this.mCp.y += f2;
    }

    public void rotate(float f, float f2, float f3) {
        this.mCp.rotate(f, f2, f3);
        this.mAngl += f3;
    }

    public boolean isInner(float f, float f2, float f3, float f4) {
        return this.mMinx >= f && this.mMaxx <= f3 && this.mMiny >= f2 && this.mMaxy <= f4;
    }

    public boolean isInner(RefList refList) {
        return ToolPolygon.isInnerPolygon(refList, this.mMinx, this.mMiny) && ToolPolygon.isInnerPolygon(refList, this.mMaxx, this.mMaxy);
    }

    public void setDir(boolean bl) {
        this.mDir = bl;
    }

    public boolean isDir() {
        return this.mDir;
    }

    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        super.save(objectFolder);
        objectFolder.addChild(new ObjectNode("x", (Object)Float.toString(this.mCp.x)));
        objectFolder.addChild(new ObjectNode("y", (Object)Float.toString(this.mCp.y)));
        objectFolder.addChild(new ObjectNode("scalefontname", (Object)this.mScaleFontName));
        objectFolder.addChild(new ObjectNode("string", (Object)this.mText));
        objectFolder.addChild(new ObjectNode("angl", (Object)Float.toString(this.mAngl)));
        objectFolder.addChild(new ObjectNode("textsize", (Object)Float.toString(this.mSize)));
        objectFolder.addChild(new ObjectNode("dir", (Object)(this.mDir ? "1" : "0")));
        objectFolder.addChild(new ObjectNode("fillback", (Object)(this.mFillBack ? "1" : "0")));
        objectFolder.addChild(new ObjectNode("bold", (Object)(this.mBold ? "1" : "0")));
    }

    public void drawHighLight(IRichGraphics iRichGraphics, Color color, boolean bl) {
        GPoint2Df.drawHighLight(iRichGraphics, color, this.mMinx, this.mMiny);
        GPoint2Df.drawHighLight(iRichGraphics, color, this.mMaxx, this.mMiny);
        GPoint2Df.drawHighLight(iRichGraphics, color, this.mMaxx, this.mMaxy);
        GPoint2Df.drawHighLight(iRichGraphics, color, this.mMinx, this.mMaxy);
    }

    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawGeom(iRichGraphics, this.mGeomColor, this.mFillColor);
    }

    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        if (color == null) {
            color = this.mGeomColor;
        }
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, null);
    }

    public void drawAlias(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
    }

    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        this.update();
        if (this.mFillBack) {
            iRichGraphics.setColor(color2);
            iRichGraphics.drawFillRect(this.mMinx, this.mMiny, this.mMaxx, this.mMaxy, null);
        }
        color2 = NethomeResource.getScaleFont(this.mScaleFontName);
        float f = this.mSize / (float)NethomeResource.SCALEFONTSIZE;
        if (this.mDir) {
            float f2;
            float f3;
            float f4 = this.mCp.x;
            float f5 = this.mCp.y;
            float f6 = this.mAngl;
            float f7 = (float)color2.stringWidth(this.mText) * f;
            float f8 = this.mSize;
            if (localAxis2Df != null) {
                f6 = (float)((double)f6 + (double)(localAxis2Df.mRot * 180.0f) / Math.PI);
                f8 = localAxis2Df.getGlobalX(f4, f5, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                float f9 = localAxis2Df.getGlobalY(f4, f5, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                f4 = f8;
                f5 = f9;
                f8 = this.mSize * localAxis2Df.getScaleX();
                if (localAxis2Df.getFlipY()) {
                    f6 += 180.0f;
                }
                ToolMath.rotation2D(0.0, 0.0, f6 * ((float)Math.PI / 180), -f7 / 2.0f, -((float)(color2.getAscent() - color2.getDescent()) * f) / 2.0f, _tmpf);
                f3 = f4 + _tmpf[0] * localAxis2Df.getScaleX();
                f2 = f5 + _tmpf[1] * localAxis2Df.getScaleX();
            } else {
                ToolMath.rotation2D(0.0, 0.0, f6 * ((float)Math.PI / 180), -f7 / 2.0f, -((float)(color2.getAscent() - color2.getDescent()) * f) / 2.0f, _tmpf);
                f3 = f4 + _tmpf[0];
                f2 = f5 + _tmpf[1];
            }
            iRichGraphics.setColor(color);
            iRichGraphics.drawText(this.mText, f3, f2, color2.getName(), color2.getStyle(), f8, f6);
            return;
        }
        int n = 0;
        while (n < this.mText.length()) {
            String string = this.mText.substring(n, n + 1);
            float f10 = (float)color2.stringWidth(string) * f;
            float f11 = (float)color2.getHeight() * f;
            float f12 = (float)(color2.getDescent() + color2.getAscent()) * f;
            float f13 = this.mCp.x - f10 / 2.0f;
            float f14 = this.mMaxy - f12 * (float)(n + 1);
            f12 = f13 + f10;
            float f15 = f14 + f11;
            f12 = (f13 + f12) / 2.0f;
            f14 = (f14 + f15) / 2.0f;
            f13 = (float)color2.getDescent() * f;
            iRichGraphics.setColor(color);
            if (NethomeResource.TATE_STRING.indexOf(string) >= 0) {
                iRichGraphics.drawText(string, f12 - f11 / 2.0f + f13, f14 + f10 / 2.0f, color2.getName(), color2.getStyle(), this.mSize, this.mAngl - 90.0f);
            } else {
                iRichGraphics.drawText(string, f12 - f10 / 2.0f, f14 - f11 / 2.0f + f13, color2.getName(), color2.getStyle(), this.mSize, this.mAngl);
            }
            ++n;
        }
    }

    public void update() {
        KFont kFont = NethomeResource.getScaleFont(this.mScaleFontName);
        float f = this.mSize / kFont.getSize();
        if (this.mDir) {
            float f2 = kFont.getDescent() + kFont.getAscent();
            float f3 = kFont.stringWidth(this.mText);
            float f4 = f3 * f / 2.0f;
            this.mMinx = this.mCp.x - f4 - f2 / 10.0f * f;
            this.mMaxx = this.mCp.x + f4 + f2 / 10.0f * f;
            this.mMiny = this.mCp.y - f2 / 2.0f * f;
            this.mMaxy = this.mCp.y + f2 / 2.0f * f;
        } else {
            float f5;
            float f6 = 0.0f;
            int n = 0;
            while (n < this.mText.length()) {
                String string = this.mText.substring(n, n + 1);
                f5 = kFont.stringWidth(string) / 2;
                f6 = Math.max(f6, f5);
                ++n;
            }
            this.mMinx = this.mCp.x - f6 * f;
            this.mMaxx = this.mCp.x + f6 * f;
            f5 = kFont.getDescent() + kFont.getAscent();
            float f7 = (float)this.mText.length() * f5 * f / 2.0f;
            this.mMiny = this.mCp.y - f7;
            this.mMaxy = this.mCp.y + f7;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String string) {
        this.mText = string;
        this.update();
    }

    public float getSize() {
        return this.mSize;
    }

    public void setSize(float f) {
        this.mSize = f;
    }

    public void flipx(float f, float f2) {
        this.mCp.flipx(f, f2);
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void flipy(float f, float f2) {
        this.mCp.flipy(f, f2);
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void rot(float f, float f2, float f3, float f4) {
        this.mCp.rot(f, f2, f3, f4);
        this.mDir = !this.mDir;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
}

