/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.primitive;

import com.kt.util.KCollection;
import com.kt.util.RefList;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.Color;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.IFillableGeometory;
import nethome.geom.primitive.Primitive;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolMathEx;
import nethome.geom.util.ToolPolygon;

public class GRect
extends Geometory
implements IFillableGeometory,
Primitive {
    private static final String GEOMNAME = "RECT";
    protected RefList mPoints;
    public float mLineWidth;
    protected transient RefList _pbuf;
    protected boolean mFill = false;
    protected Color mFillColor;

    public GRect() {
        this(0.0f, 0.0f, 0.0f, 0.0f, false);
    }

    public GRect(float f, float f2, float f3, float f4, boolean bl) {
        this(f, f2, f3, f2, f3, f4, f, f4, bl);
    }

    public GRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl) {
        this.setGeomName(GEOMNAME);
        this.mGeomColor = Color.black;
        this.mFillColor = Color.black;
        this.mFill = bl;
        this.mLineWidth = 0.0f;
        this.mPoints = new RefList();
        this.mPoints.addElement((Object)new GPoint2Df(f, f2));
        this.mPoints.addElement((Object)new GPoint2Df(f3, f4));
        this.mPoints.addElement((Object)new GPoint2Df(f5, f6));
        this.mPoints.addElement((Object)new GPoint2Df(f7, f8));
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public GPoint2Df getP1() {
        return (GPoint2Df)this.mPoints.elementAt(0);
    }

    public GPoint2Df getP2() {
        return (GPoint2Df)this.mPoints.elementAt(2);
    }

    public void setRect(float f, float f2, float f3, float f4) {
        float f5 = f < f3 ? f : f3;
        float f6 = f2 < f4 ? f2 : f4;
        f = f > f3 ? f : f3;
        f2 = f2 > f4 ? f2 : f4;
        int n = 0;
        while (n < 4) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            ((GPoint2Df)this.mPoints.elementAt(n)).x = n == 0 || n == 3 ? f5 : f;
            gPoint2Df.y = n == 0 || n == 1 ? f6 : f2;
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public boolean getSnapNode(float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, float f5, short s) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ++n;
        }
        return false;
    }

    public void getSnapLoop(Vector2 vector2) {
        int n = 0;
        while (n <= this.mPoints.size()) {
            vector2.addElement(this.mPoints.elementAt(n));
            ++n;
        }
    }

    public void getCenter(GPoint2Df gPoint2Df) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n);
            f += gPoint2Df2.x;
            f2 += gPoint2Df2.y;
            ++n;
        }
        gPoint2Df.x = f / (float)this.mPoints.size();
        gPoint2Df.y = f2 / (float)this.mPoints.size();
    }

    public GPoint2Df getNearNode(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, float f) {
        float f2 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df3 = null;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f3;
            GPoint2Df gPoint2Df4 = (GPoint2Df)this.mPoints.elementAt(n);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(gPoint2Df4.x, gPoint2Df4.y, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (f3 >= 0.0f && f4 < f && f4 < f2) {
                f2 = f4;
                gPoint2Df3 = gPoint2Df4;
            }
            ++n;
        }
        return gPoint2Df3;
    }

    public boolean getNearLine(float f, float f2, float f3, GPoint2Df[] gPoint2DfArray) {
        boolean bl = false;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f4;
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n + 1);
            float f5 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (f4 >= 0.0f && f5 < f3) {
                gPoint2DfArray[0] = gPoint2Df;
                gPoint2DfArray[1] = gPoint2Df2;
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public GPoint2Df getRotbasePoint() {
        return (GPoint2Df)this.mPoints.elementAt(0);
    }

    public void updateMinMax(Area area) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            area.updateMinMax(gPoint2Df.x, gPoint2Df.y);
            ++n;
        }
    }

    public Geometory getCopy() {
        return this.getCopy(new GRect());
    }

    protected Geometory getCopy(Geometory geometory) {
        if (geometory == null || !(geometory instanceof GRect)) {
            return null;
        }
        geometory = (GRect)geometory;
        super.getCopy(geometory);
        float f = ((GPoint2Df)this.mPoints.elementAt((int)0)).x;
        float f2 = ((GPoint2Df)this.mPoints.elementAt((int)0)).y;
        float f3 = ((GPoint2Df)this.mPoints.elementAt((int)2)).x;
        float f4 = ((GPoint2Df)this.mPoints.elementAt((int)2)).y;
        ((GRect)geometory).setRect(f, f2, f3, f4);
        ((GRect)geometory).area.maximize();
        ((GRect)geometory).setFillMode(this.mFill);
        ((GRect)geometory).setFillColor(this.mFillColor);
        ((GRect)geometory).updateMinMax(((GRect)geometory).area);
        return geometory;
    }

    public GPoint2Df getNearNode(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df = null;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f4;
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n);
            float f5 = (float)ToolMath.getLength2D(f, f2, gPoint2Df2.x, gPoint2Df2.y);
            if (f4 < f3) {
                gPoint2Df = gPoint2Df2;
                f3 = f5;
            }
            ++n;
        }
        return gPoint2Df;
    }

    public float getDistanceToPoint(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f4;
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n + 1);
            float f5 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (f4 >= 0.0f && f5 < f3) {
                f3 = f5;
            }
            ++n;
        }
        return f3;
    }

    public void offset(float f, float f2) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            gPoint2Df.offset(f, f2);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void rotate(float f, float f2, float f3) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            gPoint2Df.rotate(f, f2, f3);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public boolean isInner(float f, float f2, float f3, float f4) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df;
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n);
            if (!(gPoint2Df.x > f && gPoint2Df2.x < f3 && gPoint2Df2.y > f2 && gPoint2Df2.y < f4)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isInner(RefList refList) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n + 1);
            boolean bl = ToolPolygon.isInnerPolygon(refList, gPoint2Df.x, gPoint2Df.y);
            boolean bl2 = ToolPolygon.isInnerPolygon(refList, gPoint2Df2.x, gPoint2Df2.y);
            if (!bl || !bl2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        super.save(objectFolder);
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            objectFolder.addChild(new ObjectNode(new StringBuffer("x").append(n + 1).toString(), (Object)Float.toString(gPoint2Df.x)));
            objectFolder.addChild(new ObjectNode(new StringBuffer("y").append(n + 1).toString(), (Object)Float.toString(gPoint2Df.y)));
            ++n;
        }
        objectFolder.addChild(new ObjectNode("fill", (Object)(this.mFill ? "1" : "0")));
        objectFolder.addChild(new ObjectNode("width", (Object)Float.toString(this.mLineWidth)));
    }

    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawGeom(iRichGraphics, Color.black, null);
    }

    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, null);
    }

    public void drawAlias(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        this.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
    }

    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (this.mFill) {
            if (localAxis2Df != null) {
                int n;
                if (this._pbuf == null) {
                    this._pbuf = new RefList();
                }
                if (this._pbuf.size() != this.mPoints.size()) {
                    this._pbuf.removeAllElements();
                    n = 0;
                    while (n < this.mPoints.size()) {
                        this._pbuf.addElement((Object)new GPoint2Df());
                        ++n;
                    }
                }
                n = 0;
                while (n < this.mPoints.size()) {
                    GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
                    GPoint2Df gPoint2Df2 = (GPoint2Df)this._pbuf.elementAt(n);
                    ((GPoint2Df)this._pbuf.elementAt(n)).x = localAxis2Df.getGlobalX(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                    gPoint2Df2.y = localAxis2Df.getGlobalY(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                    ++n;
                }
                iRichGraphics.setColor(color2);
                iRichGraphics.drawFillPolygon((KCollection)this._pbuf, null);
            } else {
                iRichGraphics.setColor(color2);
                iRichGraphics.drawFillPolygon((KCollection)this.mPoints, null);
            }
        }
        iRichGraphics.setColor(color);
        iRichGraphics.drawFillPolygon((KCollection)this.mPoints, null);
    }

    public void drawHighLight(IRichGraphics iRichGraphics, Color color, boolean n) {
        if (n != 0) {
            iRichGraphics.setColor(color);
            iRichGraphics.drawPolygon((KCollection)this.mPoints, IRichGraphics.LINE_DASH_1);
        }
        n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            gPoint2Df.drawHighLight(iRichGraphics, color, false);
            ++n;
        }
    }

    public Object getNearControlPoint(float f, float f2) {
        float f3 = Float.POSITIVE_INFINITY;
        GPoint2Df gPoint2Df = null;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f4;
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n);
            float f5 = gPoint2Df2.getDistanceToPoint(f, f2);
            if (f4 < f3) {
                f3 = f5;
                gPoint2Df = gPoint2Df2;
            }
            ++n;
        }
        return gPoint2Df;
    }

    public void moveControlPoint(Object object, float f, float f2) {
        double d;
        double d2;
        GPoint2Df gPoint2Df = (GPoint2Df)object;
        Object object2 = this.mPoints.itemAt((Object)gPoint2Df).nextItem.getObject();
        gPoint2Df = object2 != null && object2 instanceof GPoint2Df ? (GPoint2Df)object2 : null;
        object2 = this.mPoints.itemAt((Object)object2).nextItem.getObject();
        GPoint2Df gPoint2Df2 = object2 != null && object2 instanceof GPoint2Df ? (GPoint2Df)object2 : null;
        object2 = this.mPoints.itemAt((Object)object2).nextItem.getObject();
        Object object3 = object2 = object2 != null && object2 instanceof GPoint2Df ? (GPoint2Df)object2 : null;
        if (!(gPoint2Df == null || gPoint2Df2 == null || gPoint2Df2 == null || ToolMathEx.isPointPickUporDown(f, f2, gPoint2Df, gPoint2Df2) && ToolMathEx.isPointPickUporDown(f, f2, gPoint2Df2, (GPoint2Df)object2))) {
            return;
        }
        double d3 = ToolMathEx.getLengthLimitlessLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
        if (d2 >= 0.0 && d3 < (double)0.001f) {
            return;
        }
        d3 = ToolMathEx.getLengthLimitlessLineToPoint2D(f, f2, gPoint2Df2.x, gPoint2Df2.y, ((GPoint2Df)object2).x, ((GPoint2Df)object2).y);
        if (d >= 0.0 && d3 < (double)0.001f) {
            return;
        }
        int n = 0;
        while (n < this.mPoints.size()) {
            gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n);
            if (gPoint2Df2 == object) {
                object = (GPoint2Df)this.mPoints.elementAt(n - 2);
                object2 = (GPoint2Df)this.mPoints.elementAt(n - 1);
                GPoint2Df gPoint2Df3 = (GPoint2Df)this.mPoints.elementAt(n + 1);
                gPoint2Df2.x = f;
                gPoint2Df2.y = f2;
                ToolMath.isCrossPointVertLimitlessLineToPoint2D(f, f2, ((GPoint2Df)object).x, ((GPoint2Df)object).y, ((GPoint2Df)object2).x, ((GPoint2Df)object2).y, _tmpf);
                ((GPoint2Df)object2).x = _tmpf[0];
                ((GPoint2Df)object2).y = _tmpf[1];
                ToolMath.isCrossPointVertLimitlessLineToPoint2D(f, f2, ((GPoint2Df)object).x, ((GPoint2Df)object).y, gPoint2Df3.x, gPoint2Df3.y, _tmpf);
                gPoint2Df3.x = _tmpf[0];
                gPoint2Df3.y = _tmpf[1];
                break;
            }
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void flipx(float f, float f2) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).flipx(f, f2);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void flipy(float f, float f2) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).flipy(f, f2);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void rot(float f, float f2, float f3, float f4) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).rot(f, f2, f3, f4);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    protected void updateShape() {
        GPoint2Df gPoint2Df = (GPoint2Df)geometory.mPoints.elementAt(0);
        GPoint2Df gPoint2Df2 = (GPoint2Df)geometory.mPoints.elementAt(1);
        GPoint2Df gPoint2Df3 = (GPoint2Df)geometory.mPoints.elementAt(2);
        Geometory geometory = (GPoint2Df)geometory.mPoints.elementAt(3);
        gPoint2Df2.x = gPoint2Df3.x;
        gPoint2Df2.y = gPoint2Df.y;
        ((GPoint2Df)geometory).x = gPoint2Df.x;
        ((GPoint2Df)geometory).y = gPoint2Df3.y;
    }

    public void setFillMode(boolean bl) {
        this.mFill = bl;
    }

    public boolean isFillMode() {
        return this.mFill;
    }

    public Color getFillColor() {
        return this.mFillColor;
    }

    public void setFillColor(Color color) {
        this.mFillColor = color;
    }
}

