/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.primitive;

import com.kt.io.AbstFile;
import com.kt.util.KCollection;
import com.kt.util.RefList;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.Color;
import java.util.StringTokenizer;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GLine;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.IFillableGeometory;
import nethome.geom.primitive.Primitive;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

public class GPolygon
extends Geometory
implements IFillableGeometory,
Primitive {
    private static final String GEOMNAME = "POLYGON";
    protected RefList mPoints;
    private transient RefList _pbuf = new RefList();
    public float mLineWidth;
    public int mSmooth;
    public boolean mFill = false;
    private Color mFillColor;

    public GPolygon() {
        this(new RefList(), 0);
    }

    public GPolygon(RefList refList, int n) {
        this.setGeomName(GEOMNAME);
        this.mPoints = refList;
        this.mSmooth = n;
        this.mGeomColor = Color.black;
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public boolean getSnapNode(float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, float f5, short s) {
        return false;
    }

    public void getSnapLoop(Vector2 vector2) {
        int n = 0;
        while (n <= this.mPoints.size()) {
            vector2.addElement(this.mPoints.elementAt(n));
            ++n;
        }
    }

    public void getCenter(GPoint2Df gPoint2Df) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n);
            f += gPoint2Df2.x;
            f2 += gPoint2Df2.y;
            ++n;
        }
        gPoint2Df.x = f / (float)this.mPoints.size();
        gPoint2Df.y = f2 / (float)this.mPoints.size();
    }

    public GPoint2Df getNearNode(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, float f) {
        float f2 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df3 = null;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f3;
            GPoint2Df gPoint2Df4 = (GPoint2Df)this.mPoints.elementAt(n);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(gPoint2Df4.x, gPoint2Df4.y, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (f3 >= 0.0f && f4 < f && f4 < f2) {
                f2 = f4;
                gPoint2Df3 = gPoint2Df4;
            }
            ++n;
        }
        return gPoint2Df3;
    }

    public boolean getNearLine(float f, float f2, float f3, GPoint2Df[] gPoint2DfArray) {
        boolean bl = false;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f4;
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n + 1);
            float f5 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (f4 >= 0.0f && f5 < f3) {
                gPoint2DfArray[0] = gPoint2Df;
                gPoint2DfArray[1] = gPoint2Df2;
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public GPoint2Df getRotbasePoint() {
        return (GPoint2Df)this.mPoints.elementAt(0);
    }

    public void updateMinMax(Area area) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            area.updateMinMax(gPoint2Df.x, gPoint2Df.y);
            ++n;
        }
    }

    public Geometory getCopy() {
        return this.getCopy(new GPolygon());
    }

    protected Geometory getCopy(Geometory geometory) {
        if (geometory == null || !(geometory instanceof GPolygon)) {
            return null;
        }
        geometory = (GPolygon)geometory;
        RefList refList = new RefList();
        int n = 0;
        while (n < this.mPoints.size()) {
            refList.addElement((Object)((Geometory)this.mPoints.elementAt(n)).getCopy());
            ++n;
        }
        ((GPolygon)geometory).mPoints = refList;
        ((GPolygon)geometory).mFill = this.mFill;
        ((GPolygon)geometory).setFillColor(this.mFillColor);
        geometory.setGeomColor(this.mGeomColor);
        ((GPolygon)geometory).mSmooth = this.mSmooth;
        ((GPolygon)geometory).area.maximize();
        ((GPolygon)geometory).updateMinMax(((GPolygon)geometory).area);
        return geometory;
    }

    public GPoint2Df getNearNode(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df = null;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f4;
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n);
            float f5 = (float)ToolMath.getLength2D(f, f2, gPoint2Df2.x, gPoint2Df2.y);
            if (f4 < f3) {
                f3 = f5;
                gPoint2Df = gPoint2Df2;
            }
            ++n;
        }
        return gPoint2Df;
    }

    public float getDistanceToPoint(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = n == this.mPoints.size() - 1 ? (GPoint2Df)this.mPoints.elementAt(0) : (GPoint2Df)this.mPoints.elementAt(n + 1);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f4 < 0.0f) && f4 < f3) {
                f3 = f4;
            }
            ++n;
        }
        return f3;
    }

    public void offset(float f, float f2) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).offset(f, f2);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void rotate(float f, float f2, float f3) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).rotate(f, f2, f3);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public boolean isInner(float f, float f2, float f3, float f4) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = n == this.mPoints.size() - 1 ? (GPoint2Df)this.mPoints.elementAt(0) : (GPoint2Df)this.mPoints.elementAt(n + 1);
            boolean bl = false;
            boolean bl2 = false;
            if (gPoint2Df.x > f && gPoint2Df.x < f3 && gPoint2Df.y > f2 && gPoint2Df.y < f4) {
                bl = true;
            }
            if (gPoint2Df2.x > f && gPoint2Df2.x < f3 && gPoint2Df2.y > f2 && gPoint2Df2.y < f4) {
                bl2 = true;
            }
            if (!bl || !bl2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isInner(RefList refList) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = n == this.mPoints.size() - 1 ? (GPoint2Df)this.mPoints.elementAt(0) : (GPoint2Df)this.mPoints.elementAt(n + 1);
            boolean bl = ToolPolygon.isInnerPolygon(refList, gPoint2Df.x, gPoint2Df.y);
            boolean bl2 = ToolPolygon.isInnerPolygon(refList, gPoint2Df2.x, gPoint2Df2.y);
            if (!bl || !bl2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public RefList getPoints() {
        return this.mPoints;
    }

    public static Object readData(AbstFile abstFile, float f) throws Exception {
        String string;
        Object object = new RefList();
        int n = Integer.valueOf(abstFile.readLineFromBuffer().trim());
        int n2 = Integer.valueOf(abstFile.readLineFromBuffer().trim());
        int n3 = 0;
        while (n3 < n2) {
            StringTokenizer stringTokenizer = new StringTokenizer(abstFile.readLineFromBuffer(), " ,");
            float f2 = Float.valueOf((String)stringTokenizer.nextElement()).floatValue();
            float f3 = Float.valueOf((String)stringTokenizer.nextElement()).floatValue();
            object.addElement((Object)new GPoint2Df(f2, f3));
            ++n3;
        }
        object = new GPolygon((RefList)object, n);
        while ((string = abstFile.readLineFromBuffer()) != null && !string.trim().equalsIgnoreCase("</POLYGON>")) {
        }
        return object;
    }

    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        objectFolder.setName(GEOMNAME);
        super.save(objectFolder);
        objectFolder.addChild(new ObjectNode("smooth", (Object)Integer.toString(this.mSmooth)));
        objectFolder.addChild(new ObjectNode("fill", (Object)(this.mFill ? "1" : "0")));
        objectFolder.addChild(new ObjectNode("pointsize", (Object)Integer.toString(this.mPoints.size())));
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            objectFolder.addChild(new ObjectNode(new StringBuffer("x").append(n + 1).toString(), (Object)Float.toString(gPoint2Df.x)));
            objectFolder.addChild(new ObjectNode(new StringBuffer("y").append(n + 1).toString(), (Object)Float.toString(gPoint2Df.y)));
            ++n;
        }
    }

    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawAbstDevice(iRichGraphics, this.mGeomColor, this.mFillColor, null);
    }

    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, null);
    }

    public void drawAlias(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (color == null) {
            color = this.mGeomColor;
        }
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
    }

    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        int n;
        if (this._pbuf != null) {
            this._pbuf.removeAllElements();
        } else {
            this._pbuf = new RefList();
        }
        if (localAxis2Df != null) {
            n = 0;
            while (n < this.mPoints.size()) {
                GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
                float f = localAxis2Df.getGlobalX(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                float f2 = localAxis2Df.getGlobalY(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                this._pbuf.addElement((Object)new GPoint2Df(f, f2));
                ++n;
            }
            localAxis2Df = this._pbuf;
        } else {
            localAxis2Df = this.mPoints;
        }
        n = 0;
        if (color != null && color2 != null && color.getRed() == color2.getRed() && color.getGreen() == color2.getGreen() && color.getBlue() == color2.getBlue()) {
            n = 1;
        }
        if (localAxis2Df.size() > 1) {
            if (this.mFill && color2 != null) {
                iRichGraphics.setColor(color2);
                iRichGraphics.drawFillPolygon((KCollection)localAxis2Df, null);
            }
            if (this.mFill && n != 0) {
                return;
            }
            if (color != null) {
                iRichGraphics.setColor(color);
                iRichGraphics.drawPolygon((KCollection)localAxis2Df, null);
            }
        }
        this._pbuf.removeAllElements();
    }

    public void drawHighLight(IRichGraphics iRichGraphics, Color color, boolean n) {
        if (n != 0) {
            n = this.mFill;
            this.mFill = false;
            this.drawAbstDevice(iRichGraphics, color, color, null);
            this.mFill = n;
        }
        n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).drawHighLight(iRichGraphics, color, false);
            ++n;
        }
    }

    public GLine getNearAsLine(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df = null;
        GPoint2Df gPoint2Df2 = null;
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df3 = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df4 = (GPoint2Df)this.mPoints.elementAt(n + 1);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df3.x, gPoint2Df3.y, gPoint2Df4.x, gPoint2Df4.y);
            if (!(f4 < 0.0f) && f4 < f3) {
                f3 = f4;
                gPoint2Df = gPoint2Df3;
                gPoint2Df2 = gPoint2Df4;
            }
            ++n;
        }
        if (gPoint2Df != null && gPoint2Df2 != null) {
            return new GLine(gPoint2Df, gPoint2Df2);
        }
        return null;
    }

    public void flipx(float f, float f2) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).flipx(f, f2);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void flipy(float f, float f2) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).flipy(f, f2);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void rot(float f, float f2, float f3, float f4) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).rot(f, f2, f3, f4);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void setFillMode(boolean bl) {
        this.mFill = bl;
    }

    public boolean isFillMode() {
        return this.mFill;
    }

    public Color getFillColor() {
        return this.mFillColor;
    }

    public void setFillColor(Color color) {
        this.mFillColor = color;
    }
}

