/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.primitive;

import com.kt.util.KCollection;
import com.kt.util.RefList;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.Color;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import nethome.geom.GeomPerser;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.Primitive;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

public class GPolyLine
extends Geometory
implements Primitive {
    private static final String GEOMNAME = "POLYLINE";
    protected RefList mPoints;
    protected RefList _pbuf = new RefList();
    public float mLineWidth;
    public int mType;
    public int mSmooth;

    public GPolyLine() {
        this(new RefList(), 0, 0);
    }

    public GPolyLine(RefList refList, int n, int n2) {
        this.setGeomName(GEOMNAME);
        this.mGeomColor = Color.black;
        this.mPoints = refList;
        this.mType = n;
        this.mSmooth = n2;
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void addPoint(GPoint2Df gPoint2Df) {
        this.mPoints.addElement((Object)gPoint2Df);
        if (this.areaControl != null) {
            this.areaControl.setArea(this.mPoints);
        }
    }

    public boolean getSnapNode(float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, float f5, short s) {
        return false;
    }

    public void getSnapLoop(Vector2 vector2) {
        int n = 0;
        while (n < this.mPoints.size()) {
            vector2.addElement(this.mPoints.elementAt(n));
            ++n;
        }
    }

    public void getCenter(GPoint2Df gPoint2Df) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n);
            f += gPoint2Df2.x;
            f2 += gPoint2Df2.y;
            ++n;
        }
        gPoint2Df.x = f / (float)this.mPoints.size();
        gPoint2Df.y = f2 / (float)this.mPoints.size();
    }

    public GPoint2Df getNearNode(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, float f) {
        float f2 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df3 = null;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f3;
            GPoint2Df gPoint2Df4 = (GPoint2Df)this.mPoints.elementAt(n);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(gPoint2Df4.x, gPoint2Df4.y, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (f3 >= 0.0f && f4 < f && f4 < f2) {
                f2 = f4;
                gPoint2Df3 = gPoint2Df4;
            }
            ++n;
        }
        return gPoint2Df3;
    }

    public boolean getNearLine(float f, float f2, float f3, GPoint2Df[] gPoint2DfArray) {
        boolean bl = false;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f4;
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n + 1);
            float f5 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (f4 >= 0.0f && f5 < f3) {
                gPoint2DfArray[0] = gPoint2Df;
                gPoint2DfArray[1] = gPoint2Df2;
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public GPoint2Df getRotbasePoint() {
        return (GPoint2Df)this.mPoints.elementAt(0);
    }

    public void updateMinMax(Area area) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            area.updateMinMax(gPoint2Df.x, gPoint2Df.y);
            ++n;
        }
    }

    public Geometory getCopy() {
        return this.getCopy(new GPolyLine());
    }

    protected Geometory getCopy(Geometory geometory) {
        if (geometory == null || !(geometory instanceof GPolyLine)) {
            return null;
        }
        geometory = (GPolyLine)geometory;
        super.getCopy(geometory);
        RefList refList = new RefList();
        int n = 0;
        while (n < this.mPoints.size()) {
            refList.addElement((Object)((Geometory)this.mPoints.elementAt(n)).getCopy());
            ++n;
        }
        ((GPolyLine)geometory).mPoints = refList;
        ((GPolyLine)geometory).mType = this.mType;
        ((GPolyLine)geometory).mSmooth = this.mSmooth;
        ((GPolyLine)geometory).area.maximize();
        ((GPolyLine)geometory).updateMinMax(((GPolyLine)geometory).area);
        return geometory;
    }

    public GPoint2Df getNearNode(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df = null;
        int n = 0;
        while (n < this.mPoints.size()) {
            float f4;
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n);
            float f5 = (float)ToolMath.getLength2D(f, f2, gPoint2Df2.x, gPoint2Df2.y);
            if (f4 < f3) {
                f3 = f5;
                gPoint2Df = gPoint2Df2;
            }
            ++n;
        }
        return gPoint2Df;
    }

    public float getDistanceToPoint(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        int n = 0;
        while (n < this.mPoints.size() - 1) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(n + 1);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f4 < 0.0f) && f4 < f3) {
                f3 = f4;
            }
            ++n;
        }
        return f3;
    }

    public void offset(float f, float f2) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).offset(f, f2);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void rotate(float f, float f2, float f3) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).rotate(f, f2, f3);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public boolean isInner(float f, float f2, float f3, float f4) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = n == this.mPoints.size() - 1 ? (GPoint2Df)this.mPoints.elementAt(0) : (GPoint2Df)this.mPoints.elementAt(n + 1);
            boolean bl = false;
            boolean bl2 = false;
            if (gPoint2Df.x > f && gPoint2Df.x < f3 && gPoint2Df.y > f2 && gPoint2Df.y < f4) {
                bl = true;
            }
            if (gPoint2Df2.x > f && gPoint2Df2.x < f3 && gPoint2Df2.y > f2 && gPoint2Df2.y < f4) {
                bl2 = true;
            }
            if (!bl || !bl2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isInner(RefList refList) {
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            GPoint2Df gPoint2Df2 = n == this.mPoints.size() - 1 ? (GPoint2Df)this.mPoints.elementAt(0) : (GPoint2Df)this.mPoints.elementAt(n + 1);
            boolean bl = ToolPolygon.isInnerPolygon(refList, gPoint2Df.x, gPoint2Df.y);
            boolean bl2 = ToolPolygon.isInnerPolygon(refList, gPoint2Df2.x, gPoint2Df2.y);
            if (!bl || !bl2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public RefList getPoints() {
        return this.mPoints;
    }

    public static void readData(ObjectFolder objectFolder, Geometory geometory, GeomPerser object) throws Exception {
        if (!(geometory instanceof GPolyLine)) {
            return;
        }
        Geometory.readData(objectFolder, geometory, (GeomPerser)object);
        object = (GPolyLine)geometory;
        ((GPolyLine)geometory).mPoints = new RefList();
        int n = 0;
        geometory = objectFolder.getNode("smooth");
        if (geometory != null) {
            ((GPolyLine)object).mSmooth = Integer.valueOf((String)geometory.getObject());
        }
        if ((geometory = objectFolder.getNode("type")) != null) {
            ((GPolyLine)object).mType = Integer.valueOf((String)geometory.getObject());
        }
        if ((geometory = objectFolder.getNode("pointsize")) != null) {
            n = Integer.valueOf((String)geometory.getObject());
        }
        int n2 = 0;
        while (n2 < n) {
            float f = 0.0f;
            float f2 = 0.0f;
            geometory = objectFolder.getNode(new StringBuffer("x").append(n2 + 1).toString());
            if (geometory != null) {
                f = Float.valueOf((String)geometory.getObject()).floatValue();
            }
            if ((geometory = objectFolder.getNode(new StringBuffer("y").append(n2 + 1).toString())) != null) {
                f2 = Float.valueOf((String)geometory.getObject()).floatValue();
            }
            ((GPolyLine)object).mPoints.addElement((Object)new GPoint2Df(f, f2));
            ++n2;
        }
    }

    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        super.save(objectFolder);
        objectFolder.addChild(new ObjectNode("smooth", (Object)Integer.toString(this.mSmooth)));
        objectFolder.addChild(new ObjectNode("type", (Object)Integer.toString(this.mType)));
        objectFolder.addChild(new ObjectNode("pointsize", (Object)Integer.toString(this.mPoints.size())));
        int n = 0;
        while (n < this.mPoints.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
            objectFolder.addChild(new ObjectNode(new StringBuffer("x").append(n + 1).toString(), (Object)Float.toString(gPoint2Df.x)));
            objectFolder.addChild(new ObjectNode(new StringBuffer("y").append(n + 1).toString(), (Object)Float.toString(gPoint2Df.y)));
            ++n;
        }
    }

    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawGeom(iRichGraphics, null, null);
    }

    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, null);
    }

    public void drawHighLight(IRichGraphics iRichGraphics, Color color, boolean n) {
        if (n != 0) {
            iRichGraphics.setColor(color);
            iRichGraphics.drawPolyLine((KCollection)this.mPoints, IRichGraphics.LINE_DASH_1);
        }
        n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).drawHighLight(iRichGraphics, color, false);
            ++n;
        }
    }

    public void drawAlias(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
    }

    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        this._pbuf.removeAllElements();
        if (localAxis2Df != null) {
            int n = 0;
            while (n < this.mPoints.size()) {
                GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
                this._pbuf.addElement((Object)new GPoint2Df(localAxis2Df.getGlobalX(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY), localAxis2Df.getGlobalY(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY)));
                ++n;
            }
            color2 = this._pbuf;
        } else {
            color2 = this.mPoints;
        }
        iRichGraphics.setColor(color);
        iRichGraphics.drawPolyLine((KCollection)color2, null);
        this._pbuf.removeAllElements();
    }

    public void flipx(float f, float f2) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).flipx(f, f2);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void flipy(float f, float f2) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).flipy(f, f2);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void rot(float f, float f2, float f3, float f4) {
        int n = 0;
        while (n < this.mPoints.size()) {
            ((GPoint2Df)this.mPoints.elementAt(n)).rot(f, f2, f3, f4);
            ++n;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }
}

