/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.primitive;

import com.kt.geom.K2DPathFigureArc;
import com.kt.util.RefList;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.Color;
import java.io.Serializable;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import nethome.geom.AreaControl;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.IFillableGeometory;
import nethome.geom.primitive.Primitive;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

public class GCircle
extends Geometory
implements K2DPathFigureArc,
Serializable,
IFillableGeometory,
Primitive {
    private static final String GEOMNAME = "CIRCLE";
    protected GPoint2Df mCp;
    protected float _r;
    protected float _start;
    protected float _end;
    protected RefList _maxPts;
    private GPoint2Df aL = new GPoint2Df();
    public boolean mFill = false;
    private Color mFillColor;

    private GCircle() {
        this.setGeomName(GEOMNAME);
    }

    public GCircle(float f, float f2, float f3, float f4, float f5) {
        this();
        this.mGeomColor = Color.black;
        this.mCp = new GPoint2Df(f, f2);
        this._r = f3;
        this._start = f4;
        this._end = f5;
        this.areaControl = new AreaControl();
        this.a();
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public boolean getSnapNode(float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, float f5, short s) {
        return false;
    }

    public void getCenter(GPoint2Df gPoint2Df) {
        gPoint2Df.x = this.mCp.x;
        gPoint2Df.y = this.mCp.y;
    }

    public void getSnapLoop(Vector2 vector2) {
    }

    public GPoint2Df getNearNode(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, float f) {
        return null;
    }

    public boolean getNearLine(float f, float f2, float f3, GPoint2Df[] gPoint2DfArray) {
        return false;
    }

    public GPoint2Df getRotbasePoint() {
        return (GPoint2Df)this._maxPts.elementAt(0);
    }

    public static boolean isParallel(Geometory geometory, Geometory geometory2) {
        if (geometory == null || geometory2 == null) {
            return false;
        }
        if (!(geometory instanceof GCircle) || !(geometory2 instanceof GCircle)) {
            return false;
        }
        geometory = (GCircle)geometory;
        geometory2 = (GCircle)geometory2;
        return Math.abs(((GCircle)geometory).getR() - ((GCircle)geometory2).getR()) < 0.001f && ToolMath.getLength2D(((GCircle)geometory).getX(), ((GCircle)geometory).getY(), ((GCircle)geometory2).getX(), ((GCircle)geometory2).getY()) < (double)0.001f && (Math.abs(((GCircle)geometory).getStart() - ((GCircle)geometory2).getEnd()) < 0.001f ? !ToolMath.isInnderAngl360(((GCircle)geometory).getStart(), ((GCircle)geometory).getEnd(), ((GCircle)geometory2).getStart()) : Math.abs(((GCircle)geometory).getEnd() - ((GCircle)geometory2).getStart()) < 0.001f && !ToolMath.isInnderAngl360(((GCircle)geometory).getStart(), ((GCircle)geometory).getEnd(), ((GCircle)geometory2).getEnd()));
    }

    public static Geometory marge(Geometory geometory, Geometory geometory2) {
        if (GCircle.isParallel(geometory, geometory2)) {
            geometory = (GCircle)geometory;
            geometory2 = (GCircle)geometory2;
            if (Math.abs(((GCircle)geometory).getStart() - ((GCircle)geometory2).getEnd()) < 0.001f) {
                if (!ToolMath.isInnderAngl360(((GCircle)geometory).getStart(), ((GCircle)geometory).getEnd(), ((GCircle)geometory2).getStart())) {
                    return new GCircle(((GCircle)geometory).getX(), ((GCircle)geometory).getY(), ((GCircle)geometory).getR(), ((GCircle)geometory2).getStart(), ((GCircle)geometory).getEnd());
                }
            } else if (Math.abs(((GCircle)geometory).getEnd() - ((GCircle)geometory2).getStart()) < 0.001f && !ToolMath.isInnderAngl360(((GCircle)geometory).getStart(), ((GCircle)geometory).getEnd(), ((GCircle)geometory2).getEnd())) {
                return new GCircle(((GCircle)geometory).getX(), ((GCircle)geometory).getY(), ((GCircle)geometory).getR(), ((GCircle)geometory).getStart(), ((GCircle)geometory2).getEnd());
            }
        }
        return null;
    }

    public float getStart() {
        return this._start;
    }

    public void setStart(float f) {
        this._start = f;
    }

    public float getEnd() {
        return this._end;
    }

    public void setEnd(float f) {
        this._end = f;
    }

    public float getR() {
        return this._r;
    }

    public void setR(float f) {
        this._r = f;
    }

    public void setX(float f) {
        this.mCp.x = f;
    }

    public void setY(float f) {
        this.mCp.y = f;
    }

    public float getX() {
        return this.mCp.x;
    }

    public float getY() {
        return this.mCp.y;
    }

    public Geometory getCopy() {
        return this.getCopy(new GCircle());
    }

    protected Geometory getCopy(Geometory geometory) {
        if (geometory == null || !(geometory instanceof GCircle)) {
            return null;
        }
        geometory = (GCircle)geometory;
        super.getCopy(geometory);
        ((GCircle)geometory).mCp = new GPoint2Df(this.mCp.x, this.mCp.y);
        ((GCircle)geometory)._r = this._r;
        ((GCircle)geometory)._start = this._start;
        ((GCircle)geometory)._end = this._end;
        ((GCircle)geometory).setFillMode(this.mFill);
        ((GCircle)geometory).setFillColor(this.mFillColor);
        ((GCircle)geometory).areaControl = new AreaControl();
        super.a();
        ((GCircle)geometory).area.maximize();
        ((GCircle)geometory).updateMinMax(((GCircle)geometory).area);
        return geometory;
    }

    public void updateMinMax(Area area) {
        float f = this._start;
        float f2 = this._end;
        while (f > f2) {
            f -= 360.0f;
        }
        if (f <= 0.0f && f2 >= 0.0f) {
            area.maxX = Math.max(this.mCp.x + this._r, area.maxX);
        }
        if (f <= 90.0f && f2 >= 90.0f) {
            area.maxY = Math.max(this.mCp.y + this._r, area.maxY);
        }
        if (f <= 180.0f && f2 >= 180.0f) {
            area.minX = Math.min(this.mCp.x - this._r, area.minX);
        }
        if (f <= 270.0f && f2 >= 270.0f) {
            area.minY = Math.min(this.mCp.y - this._r, area.minY);
        }
        if (this._start == this._end) {
            area.updateMinMax(this.mCp.x + this._r, this.mCp.y + this._r);
            area.updateMinMax(this.mCp.x - this._r, this.mCp.y - this._r);
            return;
        }
        f = this.mCp.x + (float)((double)this._r * Math.cos((double)this._start * Math.PI / 180.0));
        f2 = this.mCp.y + (float)((double)this._r * Math.sin((double)this._start * Math.PI / 180.0));
        float f3 = this.mCp.x + (float)((double)this._r * Math.cos((double)this._end * Math.PI / 180.0));
        float f4 = this.mCp.y + (float)((double)this._r * Math.sin((double)this._end * Math.PI / 180.0));
        area.updateMinMax(f, f2);
        area.updateMinMax(f3, f4);
    }

    private void a() {
        float f = this._start;
        float f2 = this._end;
        while (f > f2) {
            f -= 360.0f;
        }
        this._maxPts = new RefList();
        if (f < 0.0f && f2 > 0.0f || this._start == this._end) {
            this._maxPts.addElement((Object)new GPoint2Df(this.mCp.x + this._r, this.mCp.y));
        }
        if (f < 90.0f && f2 > 90.0f || this._start == this._end) {
            this._maxPts.addElement((Object)new GPoint2Df(this.mCp.x, this.mCp.y + this._r));
        }
        if (f < 180.0f && f2 > 180.0f || this._start == this._end) {
            this._maxPts.addElement((Object)new GPoint2Df(this.mCp.x - this._r, this.mCp.y));
        }
        if (f < 270.0f && f2 > 270.0f || this._start == this._end) {
            this._maxPts.addElement((Object)new GPoint2Df(this.mCp.x, this.mCp.y - this._r));
        }
        if (this._start != this._end) {
            GPoint2Df gPoint2Df = new GPoint2Df(this.mCp.x + (float)((double)this._r * Math.cos((double)this._start * Math.PI / 180.0)), this.mCp.y + (float)((double)this._r * Math.sin((double)this._start * Math.PI / 180.0)));
            GPoint2Df gPoint2Df2 = new GPoint2Df(this.mCp.x + (float)((double)this._r * Math.cos((double)this._end * Math.PI / 180.0)), this.mCp.y + (float)((double)this._r * Math.sin((double)this._end * Math.PI / 180.0)));
            this._maxPts.addElement((Object)gPoint2Df);
            this._maxPts.addElement((Object)gPoint2Df2);
        }
        this.areaControl.getPoints().removeAllElements();
        int n = 0;
        while (n < this._maxPts.size()) {
            this.areaControl.getPoints().addElement(this._maxPts.elementAt(n));
            ++n;
        }
    }

    public GPoint2Df getNearNode(float f, float f2) {
        float f3;
        float f4;
        this.aL.x = this.mCp.x + (float)((double)this._r * Math.cos((double)this._start * Math.PI / 180.0));
        this.aL.y = this.mCp.y + (float)((double)this._r * Math.sin((double)this._start * Math.PI / 180.0));
        float f5 = (float)ToolMath.getLength2D(f, f2, this.aL.x, this.aL.y);
        if (f5 > (float)ToolMath.getLength2D(f, f2, f4 = this.mCp.x + (float)((double)this._r * Math.cos((double)this._end * Math.PI / 180.0)), f3 = this.mCp.y + (float)((double)this._r * Math.sin((double)this._end * Math.PI / 180.0)))) {
            this.aL.x = f4;
            this.aL.y = f3;
        }
        return this.aL;
    }

    public float getDistanceToPoint(float f, float f2) {
        float f3;
        float f4 = (float)(ToolMath.getAngle2D(this.mCp.x, this.mCp.y, f, f2) * 180.0 / Math.PI);
        float f5 = this._start;
        float f6 = this._end;
        f6 -= f5;
        f4 -= f5;
        f6 = (float)ToolMath.getAngl360(f6);
        f4 = (float)ToolMath.getAngl360(f4);
        if (f3 > 0.0f && f4 < f6 || 0.0f == f6) {
            return (float)Math.abs((double)this._r - ToolMath.getLength2D(this.mCp.x, this.mCp.y, f, f2));
        }
        f5 = this.mCp.x + (float)((double)this._r * Math.cos((double)this._start * Math.PI / 180.0));
        f6 = this.mCp.y + (float)((double)this._r * Math.sin((double)this._start * Math.PI / 180.0));
        f4 = (float)ToolMath.getLength2D(f, f2, f5, f6);
        f5 = this.mCp.x + (float)((double)this._r * Math.cos((double)this._end * Math.PI / 180.0));
        f6 = this.mCp.y + (float)((double)this._r * Math.sin((double)this._end * Math.PI / 180.0));
        f4 = Math.min(f4, (float)ToolMath.getLength2D(f, f2, f5, f6));
        return f4;
    }

    public void offset(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            return;
        }
        this.mCp.x += f;
        this.mCp.y += f2;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.a();
    }

    public void rotate(float f, float f2, float f3) {
        if (f3 == 0.0f) {
            return;
        }
        this.mCp.rotate(f, f2, f3);
        this._start += (float)((double)(f3 * 180.0f) / Math.PI);
        this._end += (float)((double)(f3 * 180.0f) / Math.PI);
        while (this._start >= 360.0f) {
            this._start -= 360.0f;
        }
        while (this._start < 0.0f) {
            this._start += 360.0f;
        }
        while (this._end >= 360.0f) {
            this._end -= 360.0f;
        }
        while (this._end < 0.0f) {
            this._end += 360.0f;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
        this.a();
    }

    public boolean isInner(float f, float f2, float f3, float f4) {
        int n = 0;
        while (n < this._maxPts.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this._maxPts.elementAt(n);
            if (gPoint2Df.x < f || gPoint2Df.x > f3 || gPoint2Df.y < f2 || gPoint2Df.y > f4) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isInner(RefList refList) {
        int n = 0;
        while (n < this._maxPts.size()) {
            GPoint2Df gPoint2Df = (GPoint2Df)this._maxPts.elementAt(n);
            if (!ToolPolygon.isInnerPolygon(refList, gPoint2Df.x, gPoint2Df.y)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        objectFolder.setName(GEOMNAME);
        super.save(objectFolder);
        objectFolder.addChild(new ObjectNode("cx", (Object)Float.toString(this.mCp.x)));
        objectFolder.addChild(new ObjectNode("cy", (Object)Float.toString(this.mCp.y)));
        objectFolder.addChild(new ObjectNode("r", (Object)Float.toString(this._r)));
        objectFolder.addChild(new ObjectNode("start", (Object)Float.toString(this._start)));
        objectFolder.addChild(new ObjectNode("end", (Object)Float.toString(this._end)));
        objectFolder.addChild(new ObjectNode("fill", (Object)(this.mFill ? "1" : "0")));
        if (this.mFillColor != null) {
            objectFolder.addChild(new ObjectNode("fillc", (Object)new StringBuffer(String.valueOf(this.mFillColor.getRed())).append(",").append(this.mFillColor.getGreen()).append(",").append(this.mFillColor.getBlue()).toString()));
        }
    }

    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawGeom(iRichGraphics, this.mGeomColor, null);
    }

    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, null);
    }

    public void drawAlias(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
    }

    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        float f = this.mCp.x;
        float f2 = this.mCp.y;
        float f3 = this._start;
        float f4 = this._end;
        float f5 = this._r;
        if (localAxis2Df != null) {
            f = localAxis2Df.getGlobalX(this.mCp.x, this.mCp.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            f2 = localAxis2Df.getGlobalY(this.mCp.x, this.mCp.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            f3 = (float)((double)(localAxis2Df.getGlobalAngl((double)this._start * Math.PI / 180.0) * 180.0f) / Math.PI);
            f4 = (float)((double)(localAxis2Df.getGlobalAngl((double)this._end * Math.PI / 180.0) * 180.0f) / Math.PI);
            f5 = localAxis2Df.getGlobalLength(this._r);
            while (f3 >= 360.0f) {
                f3 -= 360.0f;
            }
            while (f3 < 0.0f) {
                f3 += 360.0f;
            }
            while (f4 >= 360.0f) {
                f4 -= 360.0f;
            }
            while (f4 < 0.0f) {
                f4 += 360.0f;
            }
        }
        if (this.mFill && color2 != null) {
            iRichGraphics.setColor(color2);
            iRichGraphics.drawFillCircle(f, f2, f5, f3, f4, null);
        }
        iRichGraphics.setColor(color);
        iRichGraphics.drawCircle(f, f2, f5, f3, f4, null);
    }

    public void drawHighLight(IRichGraphics iRichGraphics, Color color, boolean n) {
        if (n != 0) {
            n = this.mFill;
            this.mFill = false;
            this.drawAbstDevice(iRichGraphics, color, color, null);
            this.mFill = n;
        }
        n = 0;
        while (n < this._maxPts.size()) {
            ((GPoint2Df)this._maxPts.elementAt(n)).drawHighLight(iRichGraphics, color, false);
            ++n;
        }
    }

    public void getLocalMinMax(Area area) {
        float f = (float)((double)this._start * Math.PI / 180.0);
        float f2 = (float)((double)this._end * Math.PI / 180.0);
        float f3 = f > f2 ? (float)(Math.PI * 2 - (double)(f - f2)) : f2 - f;
        float f4 = Float.POSITIVE_INFINITY;
        float f5 = Float.POSITIVE_INFINITY;
        float f6 = Float.NEGATIVE_INFINITY;
        float f7 = Float.NEGATIVE_INFINITY;
        if (Math.abs(f - f2) < 0.001f) {
            f4 = this.mCp.x - this._r;
            f6 = this.mCp.x + this._r;
            f5 = this.mCp.y - this._r;
            f7 = this.mCp.y + this._r;
        } else {
            if (f <= 0.0f && f + f3 >= 0.0f) {
                f6 = this.mCp.x + this._r;
            }
            if ((double)f <= Math.PI * 2 && (double)(f + f3) >= Math.PI * 2) {
                f6 = this.mCp.x + this._r;
            }
            if ((double)f <= 1.5707963267948966 && (double)(f + f3) >= 1.5707963267948966) {
                f7 = this.mCp.y + this._r;
            }
            if ((double)f <= 7.853981633974483 && (double)(f + f3) >= 7.853981633974483) {
                f7 = this.mCp.y + this._r;
            }
            if ((double)f <= Math.PI && (double)(f + f3) >= Math.PI) {
                f4 = this.mCp.x - this._r;
            }
            if ((double)f <= Math.PI * 3 && (double)(f + f3) >= Math.PI * 3) {
                f4 = this.mCp.x - this._r;
            }
            if ((double)f <= 4.71238898038469 && (double)(f + f3) >= 4.71238898038469) {
                f5 = this.mCp.y - this._r;
            }
            if ((double)f <= 10.995574287564276 && (double)(f + f3) >= 10.995574287564276) {
                f5 = this.mCp.y - this._r;
            }
            f4 = Math.min(f4, this.mCp.x + (float)((double)this._r * Math.cos(f)));
            f5 = Math.min(f5, this.mCp.y + (float)((double)this._r * Math.sin(f)));
            f6 = Math.max(f6, this.mCp.x + (float)((double)this._r * Math.cos(f2)));
            f7 = Math.max(f7, this.mCp.y + (float)((double)this._r * Math.sin(f2)));
        }
        area.updateMinMax(f4, f5);
        area.updateMinMax(f6, f7);
    }

    public Object getNearControlPoint(float f, float f2) {
        float f3 = Float.POSITIVE_INFINITY;
        GPoint2Df gPoint2Df = null;
        int n = 0;
        while (n < this._maxPts.size()) {
            float f4;
            GPoint2Df gPoint2Df2 = (GPoint2Df)this._maxPts.elementAt(n);
            float f5 = gPoint2Df2.getDistanceToPoint(f, f2);
            if (f4 < f3) {
                f3 = f5;
                gPoint2Df = gPoint2Df2;
            }
            ++n;
        }
        return gPoint2Df;
    }

    public void moveControlPoint(Object object, float f, float f2) {
        float f3;
        this._r = f3 = (float)ToolMath.getLength2D(f, f2, this.mCp.x, this.mCp.y);
        this.area.maximize();
        this.updateMinMax(this.area);
        this.a();
    }

    public void flipx(float f, float f2) {
        this.mCp.flipx(f, f2);
        this._start = (float)ToolMath.getAngl360(180.0f - this._start);
        this._end = (float)ToolMath.getAngl360(180.0f - this._end);
        f = this._start;
        this._start = this._end;
        this._end = f;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.a();
    }

    public void flipy(float f, float f2) {
        this.mCp.flipy(f, f2);
        this._start = (float)ToolMath.getAngl360(-this._start);
        this._end = (float)ToolMath.getAngl360(-this._end);
        f = this._start;
        this._start = this._end;
        this._end = f;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.a();
    }

    public void rot(float f, float f2, float f3, float f4) {
        this.mCp.rot(f, f2, f3, f4);
        this._start = (float)ToolMath.getAngl360(this._start + 90.0f);
        this._end = (float)ToolMath.getAngl360(this._end + 90.0f);
        if (Math.abs(this._start - this._end) < 0.001f) {
            this._end = 0.0f;
            this._start = 0.0f;
        }
        while (this._start >= 360.0f) {
            this._start -= 360.0f;
        }
        while (this._start < 0.0f) {
            this._start += 360.0f;
        }
        while (this._end >= 360.0f) {
            this._end -= 360.0f;
        }
        while (this._end < 0.0f) {
            this._end += 360.0f;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
        this.a();
    }

    public void setFillMode(boolean bl) {
        this.mFill = bl;
    }

    public boolean isFillMode() {
        return this.mFill;
    }

    public Color getFillColor() {
        return this.mFillColor;
    }

    public void setFillColor(Color color) {
        this.mFillColor = color;
    }

    public double getCX() {
        return this.mCp.getX();
    }

    public double getCY() {
        return this.mCp.getY();
    }

    public double getRadius() {
        return this._r;
    }

    public boolean isCw() {
        return false;
    }

    public void setCw(boolean bl) {
    }

    public void setCX(double d) {
        this.mCp.setX(d);
    }

    public void setCY(double d) {
        this.mCp.setY(d);
    }

    public void setRadius(double d) {
        this._r = (float)d;
    }

    public double getX1() {
        return (double)this.mCp.x + (double)this._r * Math.cos(this._start * ((float)Math.PI / 180));
    }

    public double getX2() {
        return (double)this.mCp.x + (double)this._r * Math.cos(this._end * ((float)Math.PI / 180));
    }

    public double getY1() {
        return (double)this.mCp.y + (double)this._r * Math.sin(this._start * ((float)Math.PI / 180));
    }

    public double getY2() {
        return (double)this.mCp.y + (double)this._r * Math.sin(this._end * ((float)Math.PI / 180));
    }

    public void setX1(double d) {
    }

    public void setX2(double d) {
    }

    public void setY1(double d) {
    }

    public void setY2(double d) {
    }

    public int getType() {
        return 3;
    }
}

