/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom;

import com.kt.io.AbstFile;
import com.kt.util.RefList;
import com.kt.util.tree.ObjectFolder;
import java.io.Serializable;
import java.util.StringTokenizer;
import nethome.doc.Document;
import nethome.geom.Ltype;
import nethome.geom.primitive.GLine;
import nethome.lib.Library;
import nethome.ui.MainComponent;

public class HatchPattern
implements Serializable {
    public static final short MINMAXFIT = 0;
    public static final short INTERVALFIT = 1;
    public static final short SIZEDEPEND = 2;
    public static final short SUBTYPESIZE = 3;
    private String e;
    private String[] m;
    public RefList mInfinityX;
    public RefList mInfinityY;
    public RefList mLines;
    public float mDisplaySize;
    public float mCycleX;
    public float mCycleY;
    public float mMinX;
    public float mMaxX;
    public float mMinY;
    public float mMaxY;
    public short mFitPattern;
    public float mOffsetToInside = 0.0f;
    public boolean mFrameLine = false;
    public Ltype mLtype = null;
    private boolean n;
    private RefList o;

    public HatchPattern(String[] stringArray) {
        this.m = stringArray;
        this.mMinY = Float.MAX_VALUE;
        this.mMinX = Float.MAX_VALUE;
        this.mMaxY = -3.4028235E38f;
        this.mMaxX = -3.4028235E38f;
        this.mInfinityX = new RefList();
        this.mInfinityY = new RefList();
        this.mLines = new RefList();
        this.mOffsetToInside = 0.0f;
        this.mFrameLine = false;
        this.n = false;
        this.mDisplaySize = -1.0f;
        this.o = new RefList();
    }

    public static HatchPattern readData(AbstFile abstFile, Document object, float f) throws Exception {
        HatchPattern hatchPattern = null;
        object = abstFile.readLineFromBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ,");
        String[] stringArray = null;
        object = MainComponent.getInstance().getLibrary("LIBHATCH");
        if (object == null || !(object instanceof Library)) {
            return null;
        }
        Library library = (Library)object;
        if (stringTokenizer.countTokens() > 1) {
            stringArray = new String[stringTokenizer.countTokens()];
        }
        if (stringArray != null) {
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                object = (String)stringTokenizer.nextElement();
                stringArray[n++] = object;
            }
            object = library.getLibraryTree("hatch");
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (object instanceof ObjectFolder && (object = ((ObjectFolder)object).getNode(stringArray[n2])) == null) break;
                ++n2;
            }
            if (object != null) {
                hatchPattern = (HatchPattern)object.getObject();
            }
        }
        while ((object = abstFile.readLineFromBuffer()) != null && !((String)object).trim().equalsIgnoreCase("</HATCH>")) {
        }
        return hatchPattern;
    }

    public void saveGeom(AbstFile abstFile, String string) throws Exception {
        String string2 = new StringBuffer(String.valueOf(string)).append(" ").toString();
        abstFile.writeStringToBuffer(new StringBuffer(String.valueOf(string)).append("<HATCH>\r\n").toString());
        String[] stringArray = this.getGroupName();
        abstFile.writeStringToBuffer(string2);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                abstFile.writeStringToBuffer(new StringBuffer(String.valueOf(stringArray[n])).append(",").toString());
                ++n;
            }
        }
        abstFile.writeStringToBuffer(new StringBuffer(String.valueOf(this.getName())).append("\r\n").toString());
        abstFile.writeStringToBuffer(new StringBuffer(String.valueOf(string)).append("</HATCH>\r\n").toString());
    }

    public RefList getSubTypes() {
        return this.o;
    }

    public void addSubType(int n, int n2, int n3, int n4) {
        int[] nArray = new int[]{n, n2, n3, n4};
        this.o.addElement((Object)nArray);
    }

    public void addSubType2(float f, float f2, float f3, float f4) {
        float[] fArray = new float[]{f, f2, f3, f4};
        this.o.addElement((Object)fArray);
    }

    public int[] getSubtype(int n, int n2) {
        int n3 = 0;
        while (n3 < this.o.size()) {
            int[] nArray = (int[])this.o.elementAt(n3);
            if (nArray[0] == n && nArray[1] == n2) {
                return nArray;
            }
            ++n3;
        }
        return null;
    }

    public float[] getSubtype2(int n, int n2) {
        int n3 = 0;
        while (n3 < this.o.size()) {
            float[] fArray;
            float[] fArray2 = (float[])this.o.elementAt(n3);
            if (Math.abs(fArray[0] - (float)n) < 0.001f && Math.abs(fArray2[1] - (float)n2) < 0.001f) {
                return fArray2;
            }
            ++n3;
        }
        return null;
    }

    public void setGroup(String[] stringArray) {
        this.m = stringArray;
    }

    public String[] getGroupName() {
        return this.m;
    }

    public void setName(String string) {
        this.e = string;
    }

    public String getName() {
        return this.e;
    }

    public void setArea(float f) {
        this.mDisplaySize = f;
    }

    public float getArea() {
        return this.mDisplaySize;
    }

    public void setFitPattern(short s) {
        this.mFitPattern = s;
    }

    public void setCycle(float f, float f2) {
        this.mCycleX = f;
        this.mCycleY = f2;
    }

    public void setSmooth(boolean bl) {
        this.n = bl;
    }

    public boolean getSmooth() {
        return this.n;
    }

    public void setMinMax(float f, float f2, float f3, float f4) {
        this.mMinX = f;
        this.mMaxX = f3;
        this.mMinY = f2;
        this.mMaxY = f4;
    }

    public void addInfinityX(float f) {
        Float f2 = new Float(f);
        this.mInfinityX.addElement((Object)f2);
    }

    public void addInfinityY(float f) {
        Float f2 = new Float(f);
        this.mInfinityY.addElement((Object)f2);
    }

    public void addLine(float f, float f2, float f3, float f4) {
        this.mLines.addElement((Object)new GLine(f, f2, f3, f4));
    }

    public void addMinMaxLine() {
        this.mLines.addElement((Object)new GLine(this.mMinX, this.mMinY, this.mMaxX, this.mMinY));
        this.mLines.addElement((Object)new GLine(this.mMinX, this.mMinY, this.mMinX, this.mMaxY));
        this.mLines.addElement((Object)new GLine(this.mMinX, this.mMaxY, this.mMaxX, this.mMaxY));
        this.mLines.addElement((Object)new GLine(this.mMaxX, this.mMinY, this.mMaxX, this.mMaxY));
    }
}

