/*
 * Decompiled with CFR 0.152.
 */
package nethome.doc;

import com.kt.util.History;
import com.kt.util.tree.ObjectFolder;
import java.util.Hashtable;
import java.util.Vector;
import nethome.doc.Layer;
import nethome.doc.LayerManager;
import nethome.geom.ILinkLine;
import nethome.geom.primitive.Geometory;
import nethome.ui.MainApplication;

public class Project {
    private History i;
    protected LayerManager mActiveLayerManager;
    protected Vector mLayerManagers = new Vector();
    protected boolean mSaved;
    protected Hashtable mProjectInfo = new Hashtable();

    public Project() {
        this.i = new History(6);
        this.setSaved(true);
    }

    public ObjectFolder save() {
        ObjectFolder objectFolder = new ObjectFolder("DATA");
        this.saveProjectInfomation(objectFolder);
        int n = 0;
        while (n < this.getLayerManagers().size()) {
            LayerManager layerManager = (LayerManager)this.getLayerManagers().elementAt(n);
            layerManager.save(objectFolder);
            ++n;
        }
        return objectFolder;
    }

    public void load(ObjectFolder object, MainApplication mainApplication) {
        if ((object = object.getNode("DATA")) != null && object instanceof ObjectFolder) {
            this.loadProjectInfomation((ObjectFolder)object);
            Vector vector = object.getNamedElement("LAYER");
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    object = (ObjectFolder)vector.elementAt(n);
                    object = this.loadLayer((ObjectFolder)object, mainApplication);
                    this.addLayerManager((LayerManager)object);
                    ++n;
                }
            }
        }
    }

    public LayerManager loadLayer(ObjectFolder objectFolder, MainApplication mainApplication) {
        return this.loadLayer(objectFolder, mainApplication, true);
    }

    public LayerManager loadLayer(ObjectFolder objectFolder, MainApplication mainApplication, boolean bl) {
        Object object = (String)objectFolder.getNode("NAME").getObject();
        object = this.createLoadLayer(mainApplication, (String)object);
        Layer layer = ((LayerManager)object).getLayer();
        int n = 0;
        while (n < objectFolder.getChildlen().size()) {
            Object object2 = objectFolder.getChildlen().elementAt(n);
            if (object2 instanceof ObjectFolder) {
                object2 = (ObjectFolder)object2;
                object2 = mainApplication.getGeomPerser().getGeomeroty((ObjectFolder)object2);
                this.addGeomToLayer(layer, (Geometory)object2);
            }
            ++n;
        }
        if (bl) {
            this.recoverAfterLoad(layer);
        }
        return object;
    }

    protected LayerManager createLoadLayer(MainApplication mainApplication, String string) {
        LayerManager layerManager = mainApplication.createLayerManager((Project)((Object)layerManager), string);
        return layerManager;
    }

    protected void saveProjectInfomation(ObjectFolder objectFolder) {
    }

    protected void loadProjectInfomation(ObjectFolder objectFolder) {
    }

    protected void addGeomToLayer(Layer layer, Geometory geometory) {
        if (geometory != null) {
            layer.addPrimitive(geometory);
        }
    }

    protected void recoverAfterLoad(Layer layer) {
        int n = 0;
        while (n < layer.getPrims().size()) {
            Object object = layer.getPrims().elementAt(n);
            if (object instanceof ILinkLine) {
                ((ILinkLine)object).recoverLink(layer.getPrims());
            }
            ++n;
        }
    }

    public Hashtable getProjectInfo() {
        return this.mProjectInfo;
    }

    public Object getProjectInfo(Object object) {
        if (this.mProjectInfo == null) {
            return null;
        }
        return this.mProjectInfo.get(object);
    }

    public void addLayerManager(LayerManager layerManager) {
        this.mLayerManagers.addElement(layerManager);
    }

    public void setCurrentLayer(int n) {
        if (n >= 0 && n <= this.mLayerManagers.size() - 1) {
            this.mActiveLayerManager = (LayerManager)this.mLayerManagers.elementAt(n);
        }
    }

    public void setCurrentLayer(String string) {
        int n = 0;
        while (n < this.mLayerManagers.size()) {
            LayerManager layerManager = (LayerManager)this.mLayerManagers.elementAt(n);
            String string2 = layerManager.getName();
            if (string2 != null && string2.equalsIgnoreCase(string)) {
                this.mActiveLayerManager = layerManager;
                return;
            }
            ++n;
        }
    }

    public Vector getLayerManagers() {
        return this.mLayerManagers;
    }

    public void setSaved(boolean bl) {
        this.mSaved = bl;
    }

    public boolean isSaved() {
        return this.mSaved;
    }

    public Layer getCurrentLayer() {
        if (this.mActiveLayerManager != null) {
            return this.mActiveLayerManager.getLayer();
        }
        return null;
    }

    public void documentReflesh() {
        this.mActiveLayerManager = null;
        int n = 0;
        while (n < this.mLayerManagers.size()) {
            LayerManager layerManager = (LayerManager)this.mLayerManagers.elementAt(n);
            layerManager.getLayer().deleteAll();
            layerManager.getLayer().clearSelectBuffer();
            ++n;
        }
        this.mLayerManagers.removeAllElements();
        this.i.flushHistory();
    }

    public LayerManager getCurrentLayerManager() {
        return this.mActiveLayerManager;
    }

    public void flushHistory() {
        this.i.flushHistory();
    }

    public void setHistoryObject(Object object) {
        this.mActiveLayerManager.setHistoryObject(object);
    }

    public Object getLastHistory() {
        return this.i.getLastHistory();
    }

    public boolean undo() {
        boolean bl;
        Object[] objectArray = this.i.undo();
        if (objectArray == null) {
            bl = false;
        } else {
            objectArray = objectArray;
            this.mLayerManagers = (Vector)objectArray[0];
            this.mActiveLayerManager = (LayerManager)objectArray[1];
            bl = true;
        }
        if (bl) {
            this.setSaved(false);
        }
        return bl;
    }

    public boolean redo() {
        boolean bl;
        Object[] objectArray = this.i.redo();
        if (objectArray == null) {
            bl = false;
        } else {
            objectArray = objectArray;
            this.mLayerManagers = (Vector)objectArray[0];
            this.mActiveLayerManager = (LayerManager)objectArray[1];
            bl = true;
        }
        if (bl) {
            this.setSaved(false);
        }
        return bl;
    }

    public void addHistory() {
        int n = 0;
        while (n < this.getLayerManagers().size()) {
            LayerManager layerManager = (LayerManager)this.getLayerManagers().elementAt(n);
            layerManager.getLayer().renumberID();
            ++n;
        }
        Object[] objectArray = new Object[]{this.getLayerManagers(), this.mActiveLayerManager};
        this.i.addHistory((Object)objectArray);
        this.setSaved(false);
    }

    public boolean isHasUndo() {
        return this.i.isHasUndo();
    }

    public boolean isHasRedo() {
        return this.i.isHasRedo();
    }
}

