/*
 * Decompiled with CFR 0.152.
 */
package option.io.png;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import option.io.png.PNGDataEncoder;
import option.io.png.PNGException;
import option.io.png.PNGInfo;

public class PNGEncoder {
    private PNGDataEncoder Encoder;
    private PNGInfo Info;
    private int Width;
    private int Height;
    private boolean InProgress;
    private PNGException EncodeException;
    private IOException OutputException;
    private OutputStream Out;
    private boolean CloseOut;
    private byte[] RawBuffer;

    public PNGEncoder(String string) throws IOException {
        this.Out = new FileOutputStream(string);
        this.CloseOut = false;
        this.InProgress = false;
        this.CloseOut = true;
    }

    public void setRawBuffer(byte[] byArray) {
        this.RawBuffer = byArray;
    }

    public void setImageSize(int n, int n2) {
        this.Width = n;
        this.Height = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode() throws PNGException, IOException {
        if (this.Out != null) {
            this.EncodeException = null;
            this.OutputException = null;
            this.Encoder = new PNGDataEncoder(this.Out);
            this.Info = new PNGInfo();
            this.InProgress = true;
            this.imageComplete();
            while (this.InProgress) {
                PNGEncoder pNGEncoder = this;
                synchronized (pNGEncoder) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.EncodeException != null) {
                throw this.EncodeException;
            }
            if (this.OutputException != null) {
                throw this.OutputException;
            }
            if (this.Out != null && this.CloseOut) {
                this.Out.flush();
                this.Out.close();
            }
        }
    }

    public void imageComplete() {
        if (this.RawBuffer != null && this.Width > 0) {
            try {
                this.Info.width = this.Width;
                this.Info.height = this.Height;
                this.Info.bit_depth = (byte)8;
                this.Info.color_type = (byte)2;
                this.Info.channels = (byte)3;
                this.Encoder.writeInfo(this.Info);
                int n = this.Width * 3;
                byte[] byArray = new byte[n];
                int n2 = 0;
                while (n2 < this.Height) {
                    System.arraycopy(this.RawBuffer, n2 * n, byArray, 0, n);
                    this.writePNGRow(byArray);
                    ++n2;
                }
                this.Encoder.writeEnd(this.Info);
            }
            catch (PNGException pNGException) {
                this.EncodeException = pNGException;
            }
            catch (IOException iOException) {
                this.OutputException = iOException;
            }
            catch (Exception exception) {
                this.EncodeException = new PNGException(exception.toString());
            }
        } else {
            this.EncodeException = new PNGException("Null image");
        }
        this.encodeDone();
    }

    protected synchronized void encodeDone() {
        this.InProgress = false;
        this.notify();
    }

    protected void writePNGRow(byte[] byArray) throws PNGException, IOException {
        if (byArray != null) {
            this.Encoder.writeRow(byArray);
        }
    }
}

