/*
 * Decompiled with CFR 0.152.
 */
package option.io.png;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import option.io.png.PNGData;
import option.io.png.PNGException;
import option.io.png.PNGInfo;
import option.io.png.PNGRowInfo;

class PNGDataEncoder
extends PNGData {
    private OutputStream png_ostream = null;
    private Deflater zstream = null;
    private int zout_len = 0;
    private static final int PNG_FILTER_NONE = 8;
    private static final int PNG_FILTER_SUB = 16;
    private static final int PNG_FILTER_UP = 32;
    private static final int PNG_FILTER_AVG = 64;
    private static final int PNG_FILTER_PAETH = 128;
    private static final int PNG_ALL_FILTERS = 248;

    public PNGDataEncoder(OutputStream outputStream) {
        this.png_ostream = outputStream;
        this.zstream = new Deflater();
        this.zbuf_size = 8192;
        this.zbuf = new byte[this.zbuf_size];
    }

    public void writeInfo(PNGInfo pNGInfo) throws PNGException, IOException {
        this.writeData(PNGData.png_sig, 8);
        this.writeIHDR(pNGInfo.width, pNGInfo.height, pNGInfo.bit_depth, pNGInfo.color_type, pNGInfo.compression_type, pNGInfo.filter_type, pNGInfo.interlace_type);
        if ((pNGInfo.valid & 8) != 0) {
            this.writePLTE(pNGInfo.palette, pNGInfo.num_palette);
        } else if (pNGInfo.color_type == 3) {
            throw new PNGException("Valid palette required for paletted images");
        }
    }

    public void writeRow(byte[] byArray) throws PNGException, IOException {
        if (this.row_number == 0 && this.pass == 0) {
            this.writeStartRow();
        }
        this.row_info.color_type = this.color_type;
        this.row_info.width = this.usr_width;
        this.row_info.channels = this.usr_channels;
        this.row_info.bit_depth = this.usr_bit_depth;
        this.row_info.pixel_depth = (byte)(this.row_info.bit_depth * this.row_info.channels);
        this.row_info.rowbytes = this.row_info.width * this.row_info.pixel_depth + 7 >> 3;
        this.memCopy(this.row_buf, 1, byArray, 0, this.row_info.rowbytes);
        this.writeFindFilter(this.row_info);
    }

    public void writeEnd(PNGInfo pNGInfo) throws PNGException, IOException {
        if ((this.mode & 4) == 0) {
            throw new PNGException("No IDATs written into file");
        }
        this.mode |= 8;
        this.writeIEND();
    }

    protected void writeIHDR(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws PNGException, IOException {
        byte[] byArray = new byte[13];
        block0 : switch (n4) {
            case 0: {
                switch (n3) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        this.channels = 1;
                        break block0;
                    }
                }
                new PNGException("Invalid bit depth for grayscale image");
                break;
            }
            case 2: {
                if (n3 != 8 && n3 != 16) {
                    new PNGException("Invalid bit depth for RGB image");
                }
                this.channels = (byte)3;
                break;
            }
            case 3: {
                switch (n3) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: {
                        this.channels = 1;
                        break block0;
                    }
                }
                new PNGException("Invalid bit depth for paletted image");
                break;
            }
            case 4: {
                if (n3 != 8 && n3 != 16) {
                    new PNGException("Invalid bit depth for grayscale+alpha image");
                }
                this.channels = (byte)2;
                break;
            }
            case 6: {
                if (n3 != 8 && n3 != 16) {
                    new PNGException("Invalid bit depth for RGBA image");
                }
                this.channels = (byte)4;
                break;
            }
            default: {
                new PNGException("Invalid image color type specified");
            }
        }
        if (n5 != 0) {
            this.warning("Invalid compression type specified");
            n5 = 0;
        }
        if (n6 != 0) {
            this.warning("Invalid filter type specified");
            n6 = 0;
        }
        if (n7 != 0 && n7 != 1) {
            this.warning("Invalid interlace type specified");
            n7 = 1;
        }
        this.bit_depth = (byte)n3;
        this.color_type = (byte)n4;
        this.interlaced = (byte)n7;
        this.width = n;
        this.height = n2;
        this.pixel_depth = (byte)(n3 * this.channels);
        this.rowbytes = n * this.pixel_depth + 7 >> 3;
        this.usr_width = this.width;
        this.usr_bit_depth = this.bit_depth;
        this.usr_channels = this.channels;
        this.saveInt32(byArray, n);
        this.saveInt32(byArray, 4, n2);
        byArray[8] = (byte)n3;
        byArray[9] = (byte)n4;
        byArray[10] = (byte)n5;
        byArray[11] = (byte)n6;
        byArray[12] = (byte)n7;
        this.writeChunk(PNGData.png_IHDR, byArray, 13);
        if (this.do_filter == 0) {
            this.do_filter = this.color_type == 3 || this.bit_depth < 8 ? 8 : 248;
        }
        if ((this.flags & 1) == 0) {
            this.zlib_strategy = this.do_filter != 8 ? 1 : 0;
        }
        if ((this.flags & 2) == 0) {
            this.zlib_level = -1;
        }
        if ((this.flags & 4) == 0) {
            this.zlib_mem_level = 8;
        }
        if ((this.flags & 8) == 0) {
            this.zlib_window_bits = 15;
        }
        if ((this.flags & 0x10) == 0) {
            this.zlib_method = 8;
        }
        this.zstream.setLevel(this.zlib_level);
        this.zstream.setStrategy(this.zlib_strategy);
        this.mode = 1;
    }

    protected void writePLTE(Color[] colorArray, int n) throws PNGException, IOException {
        if (n == 0 || n > 256) {
            if (this.color_type == 3) {
                new PNGException("Invalid number of colors in palette");
            } else {
                this.warning("Invalid number of colors in palette");
                return;
            }
        }
        byte[] byArray = new byte[3];
        this.num_palette = (short)n;
        this.writeChunkStart(PNGData.png_PLTE, n * 3);
        int n2 = 0;
        while (n2 < n) {
            byArray[0] = (byte)colorArray[n2].getRed();
            byArray[1] = (byte)colorArray[n2].getGreen();
            byArray[2] = (byte)colorArray[n2].getBlue();
            this.writeChunkData(byArray, 3);
            ++n2;
        }
        this.writeChunkEnd();
        this.mode |= 2;
    }

    protected void writeIDAT(byte[] byArray, int n) throws IOException {
        this.writeChunk(PNGData.png_IDAT, byArray, n);
        this.mode |= 4;
    }

    protected void writeIEND() throws IOException {
        this.writeChunk(PNGData.png_IEND, null, 0);
        this.mode |= 0x10;
    }

    protected void writeChunk(byte[] byArray, byte[] byArray2, int n) throws IOException {
        this.writeChunkStart(byArray, n);
        this.writeChunkData(byArray2, n);
        this.writeChunkEnd();
    }

    protected void writeChunkStart(byte[] byArray, int n) throws IOException {
        this.writeInt32(n);
        this.writeData(byArray, 4);
        this.resetCRC();
        this.calculateCRC(byArray, 4);
    }

    protected void writeChunkData(byte[] byArray, int n) throws IOException {
        if (n != 0) {
            this.calculateCRC(byArray, n);
            this.writeData(byArray, n);
        }
    }

    protected void writeChunkEnd() throws IOException {
        this.writeInt32(this.crc);
    }

    protected void writeStartRow() throws IOException {
        this.row_buf = new byte[(this.usr_channels * this.usr_bit_depth * this.width + 7 >> 3) + 1];
        this.row_buf[0] = 0;
        if ((this.do_filter & 0x10) != 0) {
            this.sub_row = new byte[this.rowbytes + 1];
            this.sub_row[0] = 1;
        }
        if ((this.do_filter & 0xE0) != 0) {
            this.prev_row = new byte[(this.usr_channels * this.usr_bit_depth * this.width + 7 >> 3) + 1];
            this.memSet(this.prev_row, 0, (this.usr_channels * this.usr_bit_depth * this.width + 7 >> 3) + 1);
            if ((this.do_filter & 0x20) != 0) {
                this.up_row = new byte[this.rowbytes + 1];
                this.up_row[0] = 2;
            }
            if ((this.do_filter & 0x40) != 0) {
                this.avg_row = new byte[this.rowbytes + 1];
                this.avg_row[0] = 3;
            }
            if ((this.do_filter & 0x80) != 0) {
                this.paeth_row = new byte[this.rowbytes + 1];
                this.paeth_row[0] = 4;
            }
        }
        if (this.interlaced != 0) {
            if ((this.transformations & 2) == 0) {
                this.num_rows = (this.height + PNGData.png_pass_yinc[0] - 1 - PNGData.png_pass_ystart[0]) / PNGData.png_pass_yinc[0];
                this.usr_width = (this.width + PNGData.png_pass_inc[0] - 1 - PNGData.png_pass_start[0]) / PNGData.png_pass_inc[0];
            } else {
                this.num_rows = this.height;
                this.usr_width = this.width;
            }
        } else {
            this.num_rows = this.height;
            this.usr_width = this.width;
        }
    }

    protected void writeFindFilter(PNGRowInfo pNGRowInfo) throws PNGException, IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = (pNGRowInfo.pixel_depth + 7) / 8;
        int n10 = -1;
        if ((this.do_filter & 8) != 0 && this.do_filter != 8) {
            n7 = 0;
            n6 = 0;
            n5 = 1;
            while (n6 < pNGRowInfo.rowbytes) {
                n4 = PNGData.ubyte(this.row_buf[n5]);
                n7 += n4 < 128 ? n4 : 256 - n4;
                ++n6;
                ++n5;
            }
            n10 = n7;
        }
        if ((this.do_filter & 0x10) != 0) {
            n4 = 0;
            n3 = 0;
            n5 = 1;
            n7 = 1;
            while (n3 < n9) {
                this.sub_row[n7] = this.row_buf[n5];
                n2 = PNGData.ubyte(this.sub_row[n7]);
                n4 += n2 < 128 ? n2 : 256 - n2;
                ++n3;
                ++n5;
                ++n7;
            }
            n6 = 1;
            while (n3 < pNGRowInfo.rowbytes) {
                n2 = PNGData.ubyte(this.row_buf[n5]) - PNGData.ubyte(this.row_buf[n6]) & 0xFF;
                this.sub_row[n7] = (byte)n2;
                n4 += n2 < 128 ? n2 : 256 - n2;
                ++n3;
                ++n5;
                ++n6;
                ++n7;
            }
            if (n4 < n10) {
                n10 = n4;
                n8 = 1;
            }
        }
        if ((this.do_filter & 0x20) != 0) {
            n4 = 0;
            n3 = 0;
            n5 = 1;
            n7 = 1;
            n6 = 1;
            while (n3 < pNGRowInfo.rowbytes) {
                n2 = PNGData.ubyte(this.row_buf[n5]) - PNGData.ubyte(this.prev_row[n6]) & 0xFF;
                this.up_row[n7] = (byte)n2;
                n4 += n2 < 128 ? n2 : 256 - n2;
                ++n3;
                ++n5;
                ++n6;
                ++n7;
            }
            if (n4 < n10) {
                n10 = n4;
                n8 = 2;
            }
        }
        if ((this.do_filter & 0x40) != 0) {
            n3 = 0;
            n2 = 0;
            n5 = 1;
            n7 = 1;
            n6 = 1;
            while (n2 < n9) {
                n = PNGData.ubyte(this.row_buf[n5]) - PNGData.ubyte(this.prev_row[n6]) / 2 & 0xFF;
                this.avg_row[n7] = (byte)n;
                n3 += n < 128 ? n : 256 - n;
                ++n2;
                ++n5;
                ++n6;
                ++n7;
            }
            n4 = 1;
            while (n2 < pNGRowInfo.rowbytes) {
                n = PNGData.ubyte(this.row_buf[n5]) - (PNGData.ubyte(this.prev_row[n6]) + PNGData.ubyte(this.row_buf[n4])) / 2 & 0xFF;
                this.avg_row[n7] = (byte)n;
                n3 += n < 128 ? n : 256 - n;
                ++n2;
                ++n5;
                ++n6;
                ++n4;
                ++n7;
            }
            if (n3 < n10) {
                n10 = n3;
                n8 = 3;
            }
        }
        if ((this.do_filter & 0x80) != 0) {
            int n11;
            n2 = 0;
            n = 0;
            n5 = 1;
            n7 = 1;
            n6 = 1;
            while (n < n9) {
                n11 = PNGData.ubyte(this.row_buf[n5]) - PNGData.ubyte(this.prev_row[n6]) & 0xFF;
                this.paeth_row[n7] = (byte)n11;
                n2 += n11 < 128 ? n11 : 256 - n11;
                ++n;
                ++n5;
                ++n6;
                ++n7;
            }
            n3 = 1;
            n4 = 1;
            while (n < pNGRowInfo.rowbytes) {
                int n12 = PNGData.ubyte(this.prev_row[n6]);
                int n13 = PNGData.ubyte(this.prev_row[n4]);
                int n14 = PNGData.ubyte(this.row_buf[n3]);
                int n15 = n14 + n12 - n13;
                int n16 = this.iAbs(n15 - n14);
                int n17 = this.iAbs(n15 - n12);
                int n18 = this.iAbs(n15 - n13);
                n15 = n16 <= n17 && n16 <= n18 ? n14 : (n17 <= n18 ? n12 : n13);
                n11 = PNGData.ubyte(this.row_buf[n5]) - n15 & 0xFF;
                this.paeth_row[n7] = (byte)n11;
                n2 += n11 < 128 ? n11 : 256 - n11;
                ++n;
                ++n5;
                ++n6;
                ++n3;
                ++n7;
                ++n4;
            }
            if (n2 < n10) {
                n8 = 4;
            }
        }
        if (n8 == 0) {
            this.writeFilteredRow(this.row_buf);
        } else if (n8 == 1) {
            this.writeFilteredRow(this.sub_row);
        } else if (n8 == 2) {
            this.writeFilteredRow(this.up_row);
        } else if (n8 == 3) {
            this.writeFilteredRow(this.avg_row);
        } else if (n8 == 4) {
            this.writeFilteredRow(this.paeth_row);
        }
    }

    protected void writeFilteredRow(byte[] byArray) throws PNGException, IOException {
        this.zstream.setInput(byArray, 0, this.row_info.rowbytes + 1);
        do {
            int n = this.zstream.deflate(this.zbuf, this.zout_len, this.zbuf_size - this.zout_len);
            this.zout_len += n;
            if (!this.zstream.finished() && this.zout_len < this.zbuf_size) continue;
            this.writeIDAT(this.zbuf, this.zbuf_size);
            this.zout_len = 0;
        } while (!this.zstream.needsInput());
        if (this.prev_row != null) {
            byte[] byArray2 = this.prev_row;
            this.prev_row = this.row_buf;
            this.row_buf = byArray2;
        }
        this.writeFinishRow();
    }

    protected void writeFinishRow() throws PNGException, IOException {
        ++this.row_number;
        if (this.row_number < this.num_rows) {
            return;
        }
        if (this.interlaced != 0) {
            this.row_number = 0;
            if ((this.transformations & 2) != 0) {
                this.pass = (byte)(this.pass + 1);
            } else {
                do {
                    this.pass = (byte)(this.pass + 1);
                    if (this.pass >= 7) break;
                    this.usr_width = (this.width + PNGData.png_pass_inc[this.pass] - 1 - PNGData.png_pass_start[this.pass]) / PNGData.png_pass_inc[this.pass];
                    this.num_rows = (this.height + PNGData.png_pass_yinc[this.pass] - 1 - PNGData.png_pass_ystart[this.pass]) / PNGData.png_pass_yinc[this.pass];
                } while ((this.transformations & 2) == 0 && (this.usr_width == 0 || this.num_rows == 0));
            }
            if (this.pass < 7) {
                if (this.prev_row != null) {
                    this.memSet(this.prev_row, 0, this.usr_channels * this.usr_bit_depth * this.width + 7 >> 4);
                }
                return;
            }
        }
        this.zstream.finish();
        do {
            int n = this.zstream.deflate(this.zbuf, this.zout_len, this.zbuf_size - this.zout_len);
            this.zout_len += n;
            if (this.zout_len < this.zbuf_size) continue;
            this.writeIDAT(this.zbuf, this.zbuf_size);
            this.zout_len = 0;
        } while (!this.zstream.finished());
        if (this.zout_len != 0) {
            this.writeIDAT(this.zbuf, this.zout_len);
            this.zout_len = 0;
        }
        this.zstream.reset();
    }

    protected void writeData(byte[] byArray, int n) throws IOException {
        this.png_ostream.write(byArray, 0, n);
    }

    protected void writeInt32(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.writeData(byArray, 4);
    }
}

