/*
 * Decompiled with CFR 0.152.
 */
package option.io.jpg;

import java.io.IOException;
import java.io.OutputStream;
import option.io.jpg.BitOutStream;

public class JPEGCoder {
    protected BitOutStream out;
    private int qfactor = 10;
    private static final byte[] qt0 = new byte[]{16, 11, 12, 14, 12, 10, 16, 14, 13, 14, 18, 17, 16, 19, 24, 40, 26, 24, 22, 22, 24, 49, 35, 37, 29, 40, 58, 51, 61, 60, 57, 51, 56, 55, 64, 72, 92, 78, 64, 68, 87, 69, 55, 56, 80, 109, 81, 87, 95, 98, 103, 104, 103, 62, 77, 113, 121, 112, 100, 120, 92, 101, 103, 99};
    private static final byte[] qt1 = new byte[]{17, 18, 18, 24, 21, 24, 47, 26, 26, 47, 99, 66, 56, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    private static final byte[] ht0;
    private static final byte[] hsizeT0;
    private static final short[] hcodeT0;
    private static final byte[] ht1;
    private static final byte[] hsizeT1;
    private static final short[] hcodeT1;
    private static final byte[] ht2;
    private static final byte[] hsizeT2;
    private static final short[] hcodeT2;
    private static final byte[] ht3;
    private static final byte[] hsizeT3;
    private static final short[] hcodeT3;
    private static final double iSqrt2;
    private static final double[][] mCosT;

    static {
        byte[] byArray = new byte[28];
        byArray[1] = 1;
        byArray[2] = 5;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 1;
        byArray[8] = 1;
        byArray[17] = 1;
        byArray[18] = 2;
        byArray[19] = 3;
        byArray[20] = 4;
        byArray[21] = 5;
        byArray[22] = 6;
        byArray[23] = 7;
        byArray[24] = 8;
        byArray[25] = 9;
        byArray[26] = 10;
        byArray[27] = 11;
        ht0 = byArray;
        hsizeT0 = new byte[]{2, 3, 3, 3, 3, 3, 4, 5, 6, 7, 8, 9};
        short[] sArray = new short[12];
        sArray[1] = 2;
        sArray[2] = 3;
        sArray[3] = 4;
        sArray[4] = 5;
        sArray[5] = 6;
        sArray[6] = 14;
        sArray[7] = 30;
        sArray[8] = 62;
        sArray[9] = 126;
        sArray[10] = 254;
        sArray[11] = 510;
        hcodeT0 = sArray;
        byte[] byArray2 = new byte[178];
        byArray2[1] = 2;
        byArray2[2] = 1;
        byArray2[3] = 3;
        byArray2[4] = 3;
        byArray2[5] = 2;
        byArray2[6] = 4;
        byArray2[7] = 3;
        byArray2[8] = 5;
        byArray2[9] = 5;
        byArray2[10] = 4;
        byArray2[11] = 4;
        byArray2[14] = 1;
        byArray2[15] = 125;
        byArray2[16] = 1;
        byArray2[17] = 2;
        byArray2[18] = 3;
        byArray2[20] = 4;
        byArray2[21] = 17;
        byArray2[22] = 5;
        byArray2[23] = 18;
        byArray2[24] = 33;
        byArray2[25] = 49;
        byArray2[26] = 65;
        byArray2[27] = 6;
        byArray2[28] = 19;
        byArray2[29] = 81;
        byArray2[30] = 97;
        byArray2[31] = 7;
        byArray2[32] = 34;
        byArray2[33] = 113;
        byArray2[34] = 20;
        byArray2[35] = 50;
        byArray2[36] = -127;
        byArray2[37] = -111;
        byArray2[38] = -95;
        byArray2[39] = 8;
        byArray2[40] = 35;
        byArray2[41] = 66;
        byArray2[42] = -79;
        byArray2[43] = -63;
        byArray2[44] = 21;
        byArray2[45] = 82;
        byArray2[46] = -47;
        byArray2[47] = -16;
        byArray2[48] = 36;
        byArray2[49] = 51;
        byArray2[50] = 98;
        byArray2[51] = 114;
        byArray2[52] = -126;
        byArray2[53] = 9;
        byArray2[54] = 10;
        byArray2[55] = 22;
        byArray2[56] = 23;
        byArray2[57] = 24;
        byArray2[58] = 25;
        byArray2[59] = 26;
        byArray2[60] = 37;
        byArray2[61] = 38;
        byArray2[62] = 39;
        byArray2[63] = 40;
        byArray2[64] = 41;
        byArray2[65] = 42;
        byArray2[66] = 52;
        byArray2[67] = 53;
        byArray2[68] = 54;
        byArray2[69] = 55;
        byArray2[70] = 56;
        byArray2[71] = 57;
        byArray2[72] = 58;
        byArray2[73] = 67;
        byArray2[74] = 68;
        byArray2[75] = 69;
        byArray2[76] = 70;
        byArray2[77] = 71;
        byArray2[78] = 72;
        byArray2[79] = 73;
        byArray2[80] = 74;
        byArray2[81] = 83;
        byArray2[82] = 84;
        byArray2[83] = 85;
        byArray2[84] = 86;
        byArray2[85] = 87;
        byArray2[86] = 88;
        byArray2[87] = 89;
        byArray2[88] = 90;
        byArray2[89] = 99;
        byArray2[90] = 100;
        byArray2[91] = 101;
        byArray2[92] = 102;
        byArray2[93] = 103;
        byArray2[94] = 104;
        byArray2[95] = 105;
        byArray2[96] = 106;
        byArray2[97] = 115;
        byArray2[98] = 116;
        byArray2[99] = 117;
        byArray2[100] = 118;
        byArray2[101] = 119;
        byArray2[102] = 120;
        byArray2[103] = 121;
        byArray2[104] = 122;
        byArray2[105] = -125;
        byArray2[106] = -124;
        byArray2[107] = -123;
        byArray2[108] = -122;
        byArray2[109] = -121;
        byArray2[110] = -120;
        byArray2[111] = -119;
        byArray2[112] = -118;
        byArray2[113] = -110;
        byArray2[114] = -109;
        byArray2[115] = -108;
        byArray2[116] = -107;
        byArray2[117] = -106;
        byArray2[118] = -105;
        byArray2[119] = -104;
        byArray2[120] = -103;
        byArray2[121] = -102;
        byArray2[122] = -94;
        byArray2[123] = -93;
        byArray2[124] = -92;
        byArray2[125] = -91;
        byArray2[126] = -90;
        byArray2[127] = -89;
        byArray2[128] = -88;
        byArray2[129] = -87;
        byArray2[130] = -86;
        byArray2[131] = -78;
        byArray2[132] = -77;
        byArray2[133] = -76;
        byArray2[134] = -75;
        byArray2[135] = -74;
        byArray2[136] = -73;
        byArray2[137] = -72;
        byArray2[138] = -71;
        byArray2[139] = -70;
        byArray2[140] = -62;
        byArray2[141] = -61;
        byArray2[142] = -60;
        byArray2[143] = -59;
        byArray2[144] = -58;
        byArray2[145] = -57;
        byArray2[146] = -56;
        byArray2[147] = -55;
        byArray2[148] = -54;
        byArray2[149] = -46;
        byArray2[150] = -45;
        byArray2[151] = -44;
        byArray2[152] = -43;
        byArray2[153] = -42;
        byArray2[154] = -41;
        byArray2[155] = -40;
        byArray2[156] = -39;
        byArray2[157] = -38;
        byArray2[158] = -31;
        byArray2[159] = -30;
        byArray2[160] = -29;
        byArray2[161] = -28;
        byArray2[162] = -27;
        byArray2[163] = -26;
        byArray2[164] = -25;
        byArray2[165] = -24;
        byArray2[166] = -23;
        byArray2[167] = -22;
        byArray2[168] = -15;
        byArray2[169] = -14;
        byArray2[170] = -13;
        byArray2[171] = -12;
        byArray2[172] = -11;
        byArray2[173] = -10;
        byArray2[174] = -9;
        byArray2[175] = -8;
        byArray2[176] = -7;
        byArray2[177] = -6;
        ht1 = byArray2;
        hsizeT1 = new byte[]{4, 2, 2, 3, 4, 5, 7, 8, 10, 16, 16, 4, 5, 7, 9, 11, 16, 16, 16, 16, 16, 5, 8, 10, 12, 16, 16, 16, 16, 16, 16, 6, 9, 12, 16, 16, 16, 16, 16, 16, 16, 6, 10, 16, 16, 16, 16, 16, 16, 16, 16, 7, 11, 16, 16, 16, 16, 16, 16, 16, 16, 7, 12, 16, 16, 16, 16, 16, 16, 16, 16, 8, 12, 16, 16, 16, 16, 16, 16, 16, 16, 9, 15, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
        short[] sArray2 = new short[162];
        sArray2[0] = 10;
        sArray2[2] = 1;
        sArray2[3] = 4;
        sArray2[4] = 11;
        sArray2[5] = 26;
        sArray2[6] = 120;
        sArray2[7] = 248;
        sArray2[8] = 1014;
        sArray2[9] = -126;
        sArray2[10] = -125;
        sArray2[11] = 12;
        sArray2[12] = 27;
        sArray2[13] = 121;
        sArray2[14] = 502;
        sArray2[15] = 2038;
        sArray2[16] = -124;
        sArray2[17] = -123;
        sArray2[18] = -122;
        sArray2[19] = -121;
        sArray2[20] = -120;
        sArray2[21] = 28;
        sArray2[22] = 249;
        sArray2[23] = 1015;
        sArray2[24] = 4084;
        sArray2[25] = -119;
        sArray2[26] = -118;
        sArray2[27] = -117;
        sArray2[28] = -116;
        sArray2[29] = -115;
        sArray2[30] = -114;
        sArray2[31] = 58;
        sArray2[32] = 503;
        sArray2[33] = 4085;
        sArray2[34] = -113;
        sArray2[35] = -112;
        sArray2[36] = -111;
        sArray2[37] = -110;
        sArray2[38] = -109;
        sArray2[39] = -108;
        sArray2[40] = -107;
        sArray2[41] = 59;
        sArray2[42] = 1016;
        sArray2[43] = -106;
        sArray2[44] = -105;
        sArray2[45] = -104;
        sArray2[46] = -103;
        sArray2[47] = -102;
        sArray2[48] = -101;
        sArray2[49] = -100;
        sArray2[50] = -99;
        sArray2[51] = 122;
        sArray2[52] = 2039;
        sArray2[53] = -98;
        sArray2[54] = -97;
        sArray2[55] = -96;
        sArray2[56] = -95;
        sArray2[57] = -94;
        sArray2[58] = -93;
        sArray2[59] = -92;
        sArray2[60] = -91;
        sArray2[61] = 123;
        sArray2[62] = 4086;
        sArray2[63] = -90;
        sArray2[64] = -89;
        sArray2[65] = -88;
        sArray2[66] = -87;
        sArray2[67] = -86;
        sArray2[68] = -85;
        sArray2[69] = -84;
        sArray2[70] = -83;
        sArray2[71] = 250;
        sArray2[72] = 4087;
        sArray2[73] = -82;
        sArray2[74] = -81;
        sArray2[75] = -80;
        sArray2[76] = -79;
        sArray2[77] = -78;
        sArray2[78] = -77;
        sArray2[79] = -76;
        sArray2[80] = -75;
        sArray2[81] = 504;
        sArray2[82] = 32704;
        sArray2[83] = -74;
        sArray2[84] = -73;
        sArray2[85] = -72;
        sArray2[86] = -71;
        sArray2[87] = -70;
        sArray2[88] = -69;
        sArray2[89] = -68;
        sArray2[90] = -67;
        sArray2[91] = 505;
        sArray2[92] = -66;
        sArray2[93] = -65;
        sArray2[94] = -64;
        sArray2[95] = -63;
        sArray2[96] = -62;
        sArray2[97] = -61;
        sArray2[98] = -60;
        sArray2[99] = -59;
        sArray2[100] = -58;
        sArray2[101] = 506;
        sArray2[102] = -57;
        sArray2[103] = -56;
        sArray2[104] = -55;
        sArray2[105] = -54;
        sArray2[106] = -53;
        sArray2[107] = -52;
        sArray2[108] = -51;
        sArray2[109] = -50;
        sArray2[110] = -49;
        sArray2[111] = 1017;
        sArray2[112] = -48;
        sArray2[113] = -47;
        sArray2[114] = -46;
        sArray2[115] = -45;
        sArray2[116] = -44;
        sArray2[117] = -43;
        sArray2[118] = -42;
        sArray2[119] = -41;
        sArray2[120] = -40;
        sArray2[121] = 1018;
        sArray2[122] = -39;
        sArray2[123] = -38;
        sArray2[124] = -37;
        sArray2[125] = -36;
        sArray2[126] = -35;
        sArray2[127] = -34;
        sArray2[128] = -33;
        sArray2[129] = -32;
        sArray2[130] = -31;
        sArray2[131] = 2040;
        sArray2[132] = -30;
        sArray2[133] = -29;
        sArray2[134] = -28;
        sArray2[135] = -27;
        sArray2[136] = -26;
        sArray2[137] = -25;
        sArray2[138] = -24;
        sArray2[139] = -23;
        sArray2[140] = -22;
        sArray2[141] = -21;
        sArray2[142] = -20;
        sArray2[143] = -19;
        sArray2[144] = -18;
        sArray2[145] = -17;
        sArray2[146] = -16;
        sArray2[147] = -15;
        sArray2[148] = -14;
        sArray2[149] = -13;
        sArray2[150] = -12;
        sArray2[151] = 2041;
        sArray2[152] = -11;
        sArray2[153] = -10;
        sArray2[154] = -9;
        sArray2[155] = -8;
        sArray2[156] = -7;
        sArray2[157] = -6;
        sArray2[158] = -5;
        sArray2[159] = -4;
        sArray2[160] = -3;
        sArray2[161] = -2;
        hcodeT1 = sArray2;
        byte[] byArray3 = new byte[28];
        byArray3[1] = 3;
        byArray3[2] = 1;
        byArray3[3] = 1;
        byArray3[4] = 1;
        byArray3[5] = 1;
        byArray3[6] = 1;
        byArray3[7] = 1;
        byArray3[8] = 1;
        byArray3[9] = 1;
        byArray3[10] = 1;
        byArray3[17] = 1;
        byArray3[18] = 2;
        byArray3[19] = 3;
        byArray3[20] = 4;
        byArray3[21] = 5;
        byArray3[22] = 6;
        byArray3[23] = 7;
        byArray3[24] = 8;
        byArray3[25] = 9;
        byArray3[26] = 10;
        byArray3[27] = 11;
        ht2 = byArray3;
        hsizeT2 = new byte[]{2, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        short[] sArray3 = new short[12];
        sArray3[1] = 1;
        sArray3[2] = 2;
        sArray3[3] = 6;
        sArray3[4] = 14;
        sArray3[5] = 30;
        sArray3[6] = 62;
        sArray3[7] = 126;
        sArray3[8] = 254;
        sArray3[9] = 510;
        sArray3[10] = 1022;
        sArray3[11] = 2046;
        hcodeT2 = sArray3;
        byte[] byArray4 = new byte[178];
        byArray4[1] = 2;
        byArray4[2] = 1;
        byArray4[3] = 2;
        byArray4[4] = 4;
        byArray4[5] = 4;
        byArray4[6] = 3;
        byArray4[7] = 4;
        byArray4[8] = 7;
        byArray4[9] = 5;
        byArray4[10] = 4;
        byArray4[11] = 4;
        byArray4[13] = 1;
        byArray4[14] = 2;
        byArray4[15] = 119;
        byArray4[17] = 1;
        byArray4[18] = 2;
        byArray4[19] = 3;
        byArray4[20] = 17;
        byArray4[21] = 4;
        byArray4[22] = 5;
        byArray4[23] = 33;
        byArray4[24] = 49;
        byArray4[25] = 6;
        byArray4[26] = 18;
        byArray4[27] = 65;
        byArray4[28] = 81;
        byArray4[29] = 7;
        byArray4[30] = 97;
        byArray4[31] = 113;
        byArray4[32] = 19;
        byArray4[33] = 34;
        byArray4[34] = 50;
        byArray4[35] = -127;
        byArray4[36] = 8;
        byArray4[37] = 20;
        byArray4[38] = 66;
        byArray4[39] = -111;
        byArray4[40] = -95;
        byArray4[41] = -79;
        byArray4[42] = -63;
        byArray4[43] = 9;
        byArray4[44] = 35;
        byArray4[45] = 51;
        byArray4[46] = 82;
        byArray4[47] = -16;
        byArray4[48] = 21;
        byArray4[49] = 98;
        byArray4[50] = 114;
        byArray4[51] = -47;
        byArray4[52] = 10;
        byArray4[53] = 22;
        byArray4[54] = 36;
        byArray4[55] = 52;
        byArray4[56] = -31;
        byArray4[57] = 37;
        byArray4[58] = -15;
        byArray4[59] = 23;
        byArray4[60] = 24;
        byArray4[61] = 25;
        byArray4[62] = 26;
        byArray4[63] = 38;
        byArray4[64] = 39;
        byArray4[65] = 40;
        byArray4[66] = 41;
        byArray4[67] = 42;
        byArray4[68] = 53;
        byArray4[69] = 54;
        byArray4[70] = 55;
        byArray4[71] = 56;
        byArray4[72] = 57;
        byArray4[73] = 58;
        byArray4[74] = 67;
        byArray4[75] = 68;
        byArray4[76] = 69;
        byArray4[77] = 70;
        byArray4[78] = 71;
        byArray4[79] = 72;
        byArray4[80] = 73;
        byArray4[81] = 74;
        byArray4[82] = 83;
        byArray4[83] = 84;
        byArray4[84] = 85;
        byArray4[85] = 86;
        byArray4[86] = 87;
        byArray4[87] = 88;
        byArray4[88] = 89;
        byArray4[89] = 90;
        byArray4[90] = 99;
        byArray4[91] = 100;
        byArray4[92] = 101;
        byArray4[93] = 102;
        byArray4[94] = 103;
        byArray4[95] = 104;
        byArray4[96] = 105;
        byArray4[97] = 106;
        byArray4[98] = 115;
        byArray4[99] = 116;
        byArray4[100] = 117;
        byArray4[101] = 118;
        byArray4[102] = 119;
        byArray4[103] = 120;
        byArray4[104] = 121;
        byArray4[105] = 122;
        byArray4[106] = -126;
        byArray4[107] = -125;
        byArray4[108] = -124;
        byArray4[109] = -123;
        byArray4[110] = -122;
        byArray4[111] = -121;
        byArray4[112] = -120;
        byArray4[113] = -119;
        byArray4[114] = -118;
        byArray4[115] = -110;
        byArray4[116] = -109;
        byArray4[117] = -108;
        byArray4[118] = -107;
        byArray4[119] = -106;
        byArray4[120] = -105;
        byArray4[121] = -104;
        byArray4[122] = -103;
        byArray4[123] = -102;
        byArray4[124] = -94;
        byArray4[125] = -93;
        byArray4[126] = -92;
        byArray4[127] = -91;
        byArray4[128] = -90;
        byArray4[129] = -89;
        byArray4[130] = -88;
        byArray4[131] = -87;
        byArray4[132] = -86;
        byArray4[133] = -78;
        byArray4[134] = -77;
        byArray4[135] = -76;
        byArray4[136] = -75;
        byArray4[137] = -74;
        byArray4[138] = -73;
        byArray4[139] = -72;
        byArray4[140] = -71;
        byArray4[141] = -70;
        byArray4[142] = -62;
        byArray4[143] = -61;
        byArray4[144] = -60;
        byArray4[145] = -59;
        byArray4[146] = -58;
        byArray4[147] = -57;
        byArray4[148] = -56;
        byArray4[149] = -55;
        byArray4[150] = -54;
        byArray4[151] = -46;
        byArray4[152] = -45;
        byArray4[153] = -44;
        byArray4[154] = -43;
        byArray4[155] = -42;
        byArray4[156] = -41;
        byArray4[157] = -40;
        byArray4[158] = -39;
        byArray4[159] = -38;
        byArray4[160] = -30;
        byArray4[161] = -29;
        byArray4[162] = -28;
        byArray4[163] = -27;
        byArray4[164] = -26;
        byArray4[165] = -25;
        byArray4[166] = -24;
        byArray4[167] = -23;
        byArray4[168] = -22;
        byArray4[169] = -14;
        byArray4[170] = -13;
        byArray4[171] = -12;
        byArray4[172] = -11;
        byArray4[173] = -10;
        byArray4[174] = -9;
        byArray4[175] = -8;
        byArray4[176] = -7;
        byArray4[177] = -6;
        ht3 = byArray4;
        hsizeT3 = new byte[]{2, 2, 3, 4, 5, 5, 6, 7, 9, 10, 12, 4, 6, 8, 9, 11, 12, 16, 16, 16, 16, 5, 8, 10, 12, 15, 16, 16, 16, 16, 16, 5, 8, 10, 12, 16, 16, 16, 16, 16, 16, 6, 9, 16, 16, 16, 16, 16, 16, 16, 16, 6, 10, 16, 16, 16, 16, 16, 16, 16, 16, 7, 11, 16, 16, 16, 16, 16, 16, 16, 16, 7, 11, 16, 16, 16, 16, 16, 16, 16, 16, 8, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16};
        short[] sArray4 = new short[162];
        sArray4[1] = 1;
        sArray4[2] = 4;
        sArray4[3] = 10;
        sArray4[4] = 24;
        sArray4[5] = 25;
        sArray4[6] = 56;
        sArray4[7] = 120;
        sArray4[8] = 500;
        sArray4[9] = 1014;
        sArray4[10] = 4084;
        sArray4[11] = 11;
        sArray4[12] = 57;
        sArray4[13] = 246;
        sArray4[14] = 501;
        sArray4[15] = 2038;
        sArray4[16] = 4085;
        sArray4[17] = -120;
        sArray4[18] = -119;
        sArray4[19] = -118;
        sArray4[20] = -117;
        sArray4[21] = 26;
        sArray4[22] = 247;
        sArray4[23] = 1015;
        sArray4[24] = 4086;
        sArray4[25] = 32706;
        sArray4[26] = -116;
        sArray4[27] = -115;
        sArray4[28] = -114;
        sArray4[29] = -113;
        sArray4[30] = -112;
        sArray4[31] = 27;
        sArray4[32] = 248;
        sArray4[33] = 1016;
        sArray4[34] = 4087;
        sArray4[35] = -111;
        sArray4[36] = -110;
        sArray4[37] = -109;
        sArray4[38] = -108;
        sArray4[39] = -107;
        sArray4[40] = -106;
        sArray4[41] = 58;
        sArray4[42] = 502;
        sArray4[43] = -105;
        sArray4[44] = -104;
        sArray4[45] = -103;
        sArray4[46] = -102;
        sArray4[47] = -101;
        sArray4[48] = -100;
        sArray4[49] = -99;
        sArray4[50] = -98;
        sArray4[51] = 59;
        sArray4[52] = 1017;
        sArray4[53] = -97;
        sArray4[54] = -96;
        sArray4[55] = -95;
        sArray4[56] = -94;
        sArray4[57] = -93;
        sArray4[58] = -92;
        sArray4[59] = -91;
        sArray4[60] = -90;
        sArray4[61] = 121;
        sArray4[62] = 2039;
        sArray4[63] = -89;
        sArray4[64] = -88;
        sArray4[65] = -87;
        sArray4[66] = -86;
        sArray4[67] = -85;
        sArray4[68] = -84;
        sArray4[69] = -83;
        sArray4[70] = -82;
        sArray4[71] = 122;
        sArray4[72] = 2040;
        sArray4[73] = -81;
        sArray4[74] = -80;
        sArray4[75] = -79;
        sArray4[76] = -78;
        sArray4[77] = -77;
        sArray4[78] = -76;
        sArray4[79] = -75;
        sArray4[80] = -74;
        sArray4[81] = 249;
        sArray4[82] = -73;
        sArray4[83] = -72;
        sArray4[84] = -71;
        sArray4[85] = -70;
        sArray4[86] = -69;
        sArray4[87] = -68;
        sArray4[88] = -67;
        sArray4[89] = -66;
        sArray4[90] = -65;
        sArray4[91] = 503;
        sArray4[92] = -64;
        sArray4[93] = -63;
        sArray4[94] = -62;
        sArray4[95] = -61;
        sArray4[96] = -60;
        sArray4[97] = -59;
        sArray4[98] = -58;
        sArray4[99] = -57;
        sArray4[100] = -56;
        sArray4[101] = 504;
        sArray4[102] = -55;
        sArray4[103] = -54;
        sArray4[104] = -53;
        sArray4[105] = -52;
        sArray4[106] = -51;
        sArray4[107] = -50;
        sArray4[108] = -49;
        sArray4[109] = -48;
        sArray4[110] = -47;
        sArray4[111] = 505;
        sArray4[112] = -46;
        sArray4[113] = -45;
        sArray4[114] = -44;
        sArray4[115] = -43;
        sArray4[116] = -42;
        sArray4[117] = -41;
        sArray4[118] = -40;
        sArray4[119] = -39;
        sArray4[120] = -38;
        sArray4[121] = 506;
        sArray4[122] = -37;
        sArray4[123] = -36;
        sArray4[124] = -35;
        sArray4[125] = -34;
        sArray4[126] = -33;
        sArray4[127] = -32;
        sArray4[128] = -31;
        sArray4[129] = -30;
        sArray4[130] = -29;
        sArray4[131] = 2041;
        sArray4[132] = -28;
        sArray4[133] = -27;
        sArray4[134] = -26;
        sArray4[135] = -25;
        sArray4[136] = -24;
        sArray4[137] = -23;
        sArray4[138] = -22;
        sArray4[139] = -21;
        sArray4[140] = -20;
        sArray4[141] = 16352;
        sArray4[142] = -19;
        sArray4[143] = -18;
        sArray4[144] = -17;
        sArray4[145] = -16;
        sArray4[146] = -15;
        sArray4[147] = -14;
        sArray4[148] = -13;
        sArray4[149] = -12;
        sArray4[150] = -11;
        sArray4[151] = 1018;
        sArray4[152] = 32707;
        sArray4[153] = -10;
        sArray4[154] = -9;
        sArray4[155] = -8;
        sArray4[156] = -7;
        sArray4[157] = -6;
        sArray4[158] = -5;
        sArray4[159] = -4;
        sArray4[160] = -3;
        sArray4[161] = -2;
        hcodeT3 = sArray4;
        iSqrt2 = 1.0 / Math.sqrt(2.0);
        mCosT = new double[8][8];
        int n = 0;
        while (n < 8) {
            int n2 = 0;
            while (n2 < 8) {
                JPEGCoder.mCosT[n][n2] = Math.cos((2.0 * (double)n2 + 1.0) * (double)n * Math.PI / 16.0);
                ++n2;
            }
            ++n;
        }
    }

    public JPEGCoder(OutputStream outputStream) throws IOException {
        this.out = new BitOutStream(outputStream);
    }

    public void setQFactor(int n) {
        this.qfactor = n;
    }

    public void encodePixels(int[] nArray, int n, int n2) throws IOException {
        byte[] byArray = new byte[20];
        byArray[0] = -1;
        byArray[1] = -40;
        byArray[2] = -1;
        byArray[3] = -32;
        byArray[5] = 16;
        byArray[6] = 74;
        byArray[7] = 70;
        byArray[8] = 73;
        byArray[9] = 70;
        byArray[11] = 1;
        byArray[12] = 1;
        byArray[13] = 1;
        byArray[15] = 72;
        byArray[17] = 72;
        byte[] byArray2 = byArray;
        this.out.write(byArray2);
        byte[] byArray3 = (byte[])qt0.clone();
        byte[] byArray4 = (byte[])qt1.clone();
        if (this.qfactor != 100) {
            int n3 = 0;
            while (n3 < 64) {
                byArray3[n3] = (byte)Math.max(Math.min(byArray3[n3] * this.qfactor / 100, 255), 1);
                byArray4[n3] = (byte)Math.max(Math.min(byArray4[n3] * this.qfactor / 100, 255), 1);
                ++n3;
            }
        }
        this.out.write(255);
        this.out.write(219);
        this.out.write(0);
        this.out.write(132);
        this.out.write(0);
        this.out.write(byArray3);
        this.out.write(1);
        this.out.write(byArray4);
        this.out.write(255);
        this.out.write(196);
        this.out.write(1);
        this.out.write(162);
        this.out.write(0);
        this.out.write(ht0);
        this.out.write(16);
        this.out.write(ht1);
        this.out.write(1);
        this.out.write(ht2);
        this.out.write(17);
        this.out.write(ht3);
        byte[] byArray5 = new byte[19];
        byArray5[0] = -1;
        byArray5[1] = -64;
        byArray5[3] = 17;
        byArray5[4] = 8;
        byArray5[9] = 3;
        byArray5[11] = 34;
        byArray5[13] = 1;
        byArray5[14] = 17;
        byArray5[15] = 1;
        byArray5[16] = 2;
        byArray5[17] = 17;
        byArray5[18] = 1;
        byte[] byArray6 = byArray5;
        byArray6[5] = (byte)(n2 >>> 8);
        byArray6[6] = (byte)(n2 & 0xFF);
        byArray6[7] = (byte)(n >>> 8);
        byArray6[8] = (byte)(n & 0xFF);
        this.out.write(byArray6);
        byte[] byArray7 = new byte[14];
        byArray7[0] = -1;
        byArray7[1] = -38;
        byArray7[3] = 12;
        byArray7[4] = 3;
        byArray7[7] = 1;
        byArray7[8] = 17;
        byArray7[9] = 2;
        byArray7[10] = 17;
        byArray7[12] = 63;
        byte[] byArray8 = byArray7;
        this.out.write(byArray8);
        int n4 = (int)Math.ceil((double)n / 16.0);
        int n5 = (int)Math.ceil((double)n2 / 16.0);
        int[] nArray2 = new int[64];
        int[] nArray3 = new int[64];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = 0;
            while (n10 < n4) {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21 = 0;
                while (n21 < 4) {
                    n20 = n9 * 16 + (n21 < 2 ? 0 : 8);
                    n19 = n20 + 8;
                    n18 = n10 * 16 + (n21 % 2 == 0 ? 0 : 8);
                    n17 = n18 + 8;
                    n16 = 0;
                    n15 = n20;
                    while (n15 < n19) {
                        n14 = n18;
                        while (n14 < n17) {
                            n13 = nArray[(n15 >= n2 ? n2 - 1 : n15) * n + (n14 >= n ? n - 1 : n14)];
                            n12 = n13 >>> 16 & 0xFF;
                            n11 = n13 >>> 8 & 0xFF;
                            int n22 = n13 & 0xFF;
                            nArray2[n16] = (int)(0.299 * (double)n12 + 0.587 * (double)n11 + 0.114 * (double)n22 - 128.0);
                            ++n16;
                            ++n14;
                        }
                        ++n15;
                    }
                    this.dct(nArray2);
                    this.qzn(nArray2, byArray3);
                    this.chf(nArray2, n6, hsizeT0, hcodeT0, hsizeT1, hcodeT1);
                    n6 = nArray2[0];
                    ++n21;
                }
                n21 = n9 * 16;
                n20 = n21 + 16;
                n19 = n10 * 16;
                n18 = n19 + 16;
                n17 = 0;
                n16 = n21;
                while (n16 < n20) {
                    n15 = n19;
                    while (n15 < n18) {
                        n14 = nArray[(n16 >= n2 ? n2 - 1 : n16) * n + (n15 >= n ? n - 1 : n15)];
                        n13 = n14 >>> 16 & 0xFF;
                        n12 = n14 >>> 8 & 0xFF;
                        n11 = n14 & 0xFF;
                        nArray2[n17] = (int)(-0.1687 * (double)n13 - 0.3313 * (double)n12 + 0.5 * (double)n11);
                        nArray3[n17] = (int)(0.5 * (double)n13 - 0.4187 * (double)n12 - 0.0813 * (double)n11);
                        ++n17;
                        n15 += 2;
                    }
                    n16 += 2;
                }
                this.dct(nArray2);
                this.qzn(nArray2, byArray4);
                this.chf(nArray2, n7, hsizeT2, hcodeT2, hsizeT3, hcodeT3);
                n7 = nArray2[0];
                this.dct(nArray3);
                this.qzn(nArray3, byArray4);
                this.chf(nArray3, n8, hsizeT2, hcodeT2, hsizeT3, hcodeT3);
                n8 = nArray3[0];
                ++n10;
            }
            ++n9;
        }
        this.out.write(255);
        this.out.write(217);
        this.out.flush();
    }

    private void dct(int[] nArray) {
        int[] nArray2 = new int[64];
        int n = 0;
        while (n < 8) {
            double d2 = n == 0 ? iSqrt2 : 1.0;
            int n2 = 0;
            while (n2 < 8) {
                double d3 = n2 == 0 ? iSqrt2 : 1.0;
                double d4 = 0.0;
                int n3 = 0;
                while (n3 < 8) {
                    int n4 = 0;
                    while (n4 < 8) {
                        d4 += (double)nArray[n3 * 8 + n4] * mCosT[n2][n4] * mCosT[n][n3];
                        ++n4;
                    }
                    ++n3;
                }
                nArray2[n * 8 + n2] = (int)(d4 * d3 * d2 / 4.0);
                ++n2;
            }
            ++n;
        }
        int[] nArray3 = new int[64];
        nArray3[1] = 1;
        nArray3[2] = 8;
        nArray3[3] = 16;
        nArray3[4] = 9;
        nArray3[5] = 2;
        nArray3[6] = 3;
        nArray3[7] = 10;
        nArray3[8] = 17;
        nArray3[9] = 24;
        nArray3[10] = 32;
        nArray3[11] = 25;
        nArray3[12] = 18;
        nArray3[13] = 11;
        nArray3[14] = 4;
        nArray3[15] = 5;
        nArray3[16] = 12;
        nArray3[17] = 19;
        nArray3[18] = 26;
        nArray3[19] = 33;
        nArray3[20] = 40;
        nArray3[21] = 48;
        nArray3[22] = 41;
        nArray3[23] = 34;
        nArray3[24] = 27;
        nArray3[25] = 20;
        nArray3[26] = 13;
        nArray3[27] = 6;
        nArray3[28] = 7;
        nArray3[29] = 14;
        nArray3[30] = 21;
        nArray3[31] = 28;
        nArray3[32] = 35;
        nArray3[33] = 42;
        nArray3[34] = 49;
        nArray3[35] = 56;
        nArray3[36] = 57;
        nArray3[37] = 50;
        nArray3[38] = 43;
        nArray3[39] = 36;
        nArray3[40] = 29;
        nArray3[41] = 22;
        nArray3[42] = 15;
        nArray3[43] = 23;
        nArray3[44] = 30;
        nArray3[45] = 37;
        nArray3[46] = 44;
        nArray3[47] = 51;
        nArray3[48] = 58;
        nArray3[49] = 59;
        nArray3[50] = 52;
        nArray3[51] = 45;
        nArray3[52] = 38;
        nArray3[53] = 31;
        nArray3[54] = 39;
        nArray3[55] = 46;
        nArray3[56] = 53;
        nArray3[57] = 60;
        nArray3[58] = 61;
        nArray3[59] = 54;
        nArray3[60] = 47;
        nArray3[61] = 55;
        nArray3[62] = 62;
        nArray3[63] = 63;
        int[] nArray4 = nArray3;
        int n5 = 0;
        while (n5 < 64) {
            nArray[n5] = nArray2[nArray4[n5]];
            ++n5;
        }
    }

    private void qzn(int[] nArray, byte[] byArray) {
        int n = 0;
        while (n < 64) {
            int n2 = n;
            nArray[n2] = nArray[n2] / byArray[n];
            ++n;
        }
    }

    private void chf(int[] nArray, int n, byte[] byArray, short[] sArray, byte[] byArray2, short[] sArray2) throws IOException {
        int n2 = nArray[0] - n;
        int n3 = Math.abs(n2);
        int n4 = 0;
        while (n3 > 0) {
            n3 >>= 1;
            ++n4;
        }
        this.out.writeBits(sArray[n4], byArray[n4]);
        if (n4 != 0) {
            if (n2 < 0) {
                --n2;
            }
            this.out.writeBits(n2, n4);
        }
        int n5 = 0;
        int n6 = 1;
        while (n6 < 64) {
            int n7 = Math.abs(nArray[n6]);
            if (n7 != 0) {
                while (n5 > 15) {
                    this.out.writeBits(sArray2[151], byArray2[151]);
                    n5 -= 16;
                }
                int n8 = 0;
                while (n7 > 0) {
                    n7 >>= 1;
                    ++n8;
                }
                int n9 = n5 * 10 + n8 + (n5 == 15 ? 1 : 0);
                this.out.writeBits(sArray2[n9], byArray2[n9]);
                int n10 = nArray[n6];
                if (n10 < 0) {
                    --n10;
                }
                this.out.writeBits(n10, n8);
                n5 = 0;
            } else if (n6 == 63) {
                this.out.writeBits(sArray2[0], byArray2[0]);
            } else {
                ++n5;
            }
            ++n6;
        }
    }
}

