/*
 * Decompiled with CFR 0.152.
 */
package option.io.jpg;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutStream
extends FilterOutputStream {
    private int bytes = 0;
    private int cnt = 0;

    public BitOutStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        this.fillBits();
        this.out.write(n);
    }

    public void writeBits(int n, int n2) throws IOException {
        if (n2 > 24) {
            throw new IOException();
        }
        this.bytes <<= n2;
        int n3 = 32 - n2;
        this.bytes |= n << n3 >>> n3;
        this.cnt += n2;
        this.send();
    }

    private void send() throws IOException {
        while (this.cnt >= 8) {
            int n = this.bytes >> (this.cnt -= 8) & 0xFF;
            this.out.write(n);
            if (n != 255) continue;
            this.out.write(0);
        }
    }

    private void fillBits() throws IOException {
        if (this.cnt % 8 > 0) {
            this.bytes <<= 8 - this.cnt % 8;
            this.bytes |= 255 >>> this.cnt % 8;
            this.cnt += 8 - this.cnt % 8;
        }
        this.send();
    }

    public void close() throws IOException {
        this.fillBits();
        this.out.close();
    }
}

