/*
 * Decompiled with CFR 0.152.
 */
package com.kt.db;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;

public class ErrorLog {
    public static final String ERR_DEFAULT = "DB_ACCESS_ERROR";
    protected static String mAppName = null;
    protected static String mLogFile = null;

    public static synchronized void writeErr(Exception exception) {
        ErrorLog.writeErr(exception, null, ERR_DEFAULT);
    }

    public static synchronized void writeErr(Exception exception, String string, String string2) {
        if (mLogFile == null) {
            return;
        }
        ErrorLog.createLock(mLogFile);
        File file = new File(mLogFile);
        FileWriter fileWriter = null;
        try {
            fileWriter = !file.exists() ? new FileWriter(file) : new FileWriter(file, true);
            if (fileWriter != null) {
                fileWriter.write(ErrorLog.getDate());
                if (exception instanceof SQLException) {
                    fileWriter.write("\u3010\u63a5\u7d9a\u969c\u5bb3\u3011 / ");
                } else {
                    fileWriter.write("\u3010\u305d\u306e\u4ed6\u969c\u5bb3\u3011 / ");
                }
                fileWriter.write(" " + string2 + " (" + mAppName + ") / ");
                fileWriter.write(String.valueOf(exception.toString()) + " / ");
                if (string != null) {
                    fileWriter.write(String.valueOf(string) + "\r\n");
                } else {
                    StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                    if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
                        fileWriter.write(String.valueOf(stackTraceElementArray[0].toString()) + "\r\n");
                    } else {
                        fileWriter.write("\r\n");
                    }
                }
                fileWriter.flush();
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            fileWriter = null;
        }
        ErrorLog.deleteLock(mLogFile);
    }

    private static void createLock(String string) {
        File file = new File(String.valueOf(string) + ".lock");
        while (file.exists()) {
            if (file.lastModified() < Calendar.getInstance().getTime().getTime() - 60000L) {
                file.delete();
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {}
    }

    private static void deleteLock(String string) {
        File file = new File(String.valueOf(string) + ".lock");
        if (file.exists()) {
            file.delete();
        }
    }

    private static String getDate() {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        return String.valueOf(n) + "\u5e74" + decimalFormat.format(n2) + "\u6708" + decimalFormat.format(n3) + "\u65e5" + decimalFormat.format(n4) + "\u6642" + decimalFormat.format(n5) + "\u5206" + decimalFormat.format(n6) + "\u79d2";
    }
}

