/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import option.io.pdfcommon.io.PdfOutFile;

public class PdfRect {
    private float lux;
    private float luy;
    private float rdx;
    private float rdy;

    public PdfRect() {
    }

    public PdfRect(float f, float f2, float f3, float f4) {
        this.setPoints(f, f2, f3, f4);
    }

    public float getWidth() {
        return this.rdx - this.lux;
    }

    public float getHeight() {
        return this.rdy - this.luy;
    }

    public float getLux() {
        return this.lux;
    }

    public float getLuy() {
        return this.luy;
    }

    public float getRdx() {
        return this.rdx;
    }

    public float getRdy() {
        return this.rdy;
    }

    public void setPoints(float f, float f2, float f3, float f4) {
        this.setLux(f);
        this.setLuy(f2);
        this.setRdx(f3);
        this.setRdy(f4);
    }

    public void setLux(float f) {
        this.lux = f;
    }

    public void setLuy(float f) {
        this.luy = f;
    }

    public void setRdx(float f) {
        this.rdx = f;
    }

    public void setRdy(float f) {
        this.rdy = f;
    }

    public void changeDirection() {
        float f = this.rdx;
        this.rdx = this.rdy;
        this.rdy = f;
    }

    public void rotate(float f) {
        float f2 = (float)Math.PI * f / 180.0f;
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        this.lux = f3 * this.lux - f4 * this.luy;
        this.luy = f4 * this.lux + f3 * this.luy;
        this.rdx = f3 * this.rdx - f4 * this.rdy;
        this.rdy = f4 * this.rdx + f3 * this.rdy;
    }

    public void scale(float f, float f2) {
        this.rdx = this.lux + (this.rdx - this.lux) * f;
        this.rdy = this.luy + (this.rdy - this.luy) * f2;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("[ ");
        printWriter.print(this.lux);
        printWriter.print(" ");
        printWriter.print(this.luy);
        printWriter.print(" ");
        printWriter.print(this.rdx);
        printWriter.print(" ");
        printWriter.print(this.rdy);
        printWriter.print(" ]");
        printWriter.close();
        return stringWriter.toString();
    }

    public void write(PdfOutFile pdfOutFile) {
        PrintStream printStream = pdfOutFile.getPrintStream();
        printStream.println(this.toString());
    }
}

