/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import option.io.pdfcommon.font.CmapTable;
import option.io.pdfcommon.font.DefaultTable;
import option.io.pdfcommon.font.FontDirectory;
import option.io.pdfcommon.font.HeadTable;
import option.io.pdfcommon.font.HheaTable;
import option.io.pdfcommon.font.HtmxTable;
import option.io.pdfcommon.font.LocaTable;
import option.io.pdfcommon.font.MaxpTable;
import option.io.pdfcommon.font.NameTable;
import option.io.pdfcommon.font.OS2Table;
import option.io.pdfcommon.font.PostTable;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class TrueTypeFile {
    static final String[] TABLE_NAMES_SIMPLE = new String[]{"cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
    static final int[] ENTRY_SELECTOR;
    private FontDirectory mFontDirectory;
    private HeadTable mHeadTable;
    private MaxpTable mMaxpTable;
    private HheaTable mHheaTable;
    private NameTable mNameTable;
    private LocaTable mLocaTable;
    private CmapTable mCmapTable;
    private OS2Table mOS2Table;
    private PostTable mPostTable;
    private HtmxTable mHtmxTable;
    private String copyRightNotice;
    private String familyName;
    private String subFamilyName;
    private String fullName;
    private String fontName;
    private int flags;
    private int capHeight;
    private int ascent;
    private int dscent;
    private int stemV;
    private float ItalicAngle;
    private int[] fontBox = new int[4];
    private byte[] panose = new byte[10];
    private Hashtable cmaps;
    private Hashtable glyphData;
    private int[] glyphWidths;
    private long[] offsets;
    private Vector usedChars;
    private int firstChar;
    private int lastChar;
    private Hashtable tableCollection;
    public TrueTypeFontFileReader fr;
    int[] newOffsets;
    byte[] newGTable;
    byte[] newLocaTable;
    int gTableRealSize;
    int lTableRealSize;
    int[] usedGIInt;
    int[] usedGWidths;
    Hashtable usedGI_GW;

    static {
        int[] nArray = new int[21];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 4;
        nArray[19] = 4;
        nArray[20] = 4;
        ENTRY_SELECTOR = nArray;
    }

    public TrueTypeFile() {
        this.mFontDirectory = new FontDirectory();
        this.usedChars = new Vector();
    }

    public void loadFontDirectory() {
        this.mFontDirectory.loadFontData(this.fr);
        this.tableCollection = this.mFontDirectory.tableCollection;
        DefaultTable defaultTable = (DefaultTable)this.tableCollection.get("name");
        if (defaultTable != null) {
            this.mNameTable = new NameTable();
            this.mNameTable.tableName = defaultTable.tableName;
            this.mNameTable.checkSum = defaultTable.checkSum;
            this.mNameTable.offset = defaultTable.offset;
            this.mNameTable.length = defaultTable.length;
            this.mNameTable.loadFontData(this.fr);
        }
        this.copyRightNotice = this.mNameTable.copyRightNotice;
        this.familyName = this.mNameTable.familyName;
        this.subFamilyName = this.mNameTable.subFamilyName;
        this.fullName = this.mNameTable.fullName;
        this.fontName = this.mNameTable.fontName;
    }

    public void checkTTC(String string) {
        String string2 = this.fr.readByteString(4);
        if (string2.equals("ttcf")) {
            try {
                this.fr.skipBytes(4);
                int n = (int)this.fr.readUInt32();
                long[] lArray = new long[n];
                int n2 = 0;
                while (n2 < n) {
                    lArray[n2] = this.fr.readUInt32();
                    ++n2;
                }
                n2 = 0;
                while (n2 < n) {
                    this.mFontDirectory.offset = lArray[n2];
                    this.mFontDirectory.loadFontData(this.fr);
                    this.tableCollection = this.mFontDirectory.tableCollection;
                    DefaultTable defaultTable = (DefaultTable)this.tableCollection.get("name");
                    if (defaultTable != null) {
                        this.mNameTable = new NameTable();
                        this.mNameTable.tableName = defaultTable.tableName;
                        this.mNameTable.checkSum = defaultTable.checkSum;
                        this.mNameTable.offset = defaultTable.offset;
                        this.mNameTable.length = defaultTable.length;
                        this.mNameTable.loadFontData(this.fr);
                    }
                    if (!string.equals(this.mNameTable.familyName)) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.out.println("IOException on checking ttc");
            }
        } else {
            try {
                this.fr.seek(0L);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void LoadFontData() {
        this.loadFontDirectory();
        DefaultTable defaultTable = (DefaultTable)this.tableCollection.get("head");
        if (defaultTable != null) {
            this.mHeadTable = new HeadTable();
            this.mHeadTable.tableName = defaultTable.tableName;
            this.mHeadTable.checkSum = defaultTable.checkSum;
            this.mHeadTable.offset = defaultTable.offset;
            this.mHeadTable.length = defaultTable.length;
            this.mHeadTable.loadFontData(this.fr);
        }
        if ((defaultTable = (DefaultTable)this.tableCollection.get("hhea")) != null) {
            this.mHheaTable = new HheaTable();
            this.mHheaTable.tableName = defaultTable.tableName;
            this.mHheaTable.checkSum = defaultTable.checkSum;
            this.mHheaTable.offset = defaultTable.offset;
            this.mHheaTable.length = defaultTable.length;
            this.mHheaTable.loadFontData(this.fr);
        }
        if ((defaultTable = (DefaultTable)this.tableCollection.get("hmtx")) != null) {
            this.mHtmxTable = new HtmxTable();
            this.mHtmxTable.tableName = defaultTable.tableName;
            this.mHtmxTable.checkSum = defaultTable.checkSum;
            this.mHtmxTable.offset = defaultTable.offset;
            this.mHtmxTable.length = defaultTable.length;
            this.mHtmxTable.numOfLongHorMetrics = this.mHheaTable.numOfLongHorMetrics;
            this.mHtmxTable.loadFontData(this.fr);
        }
        if ((defaultTable = (DefaultTable)this.tableCollection.get("maxp")) != null) {
            this.mMaxpTable = new MaxpTable();
            this.mMaxpTable.tableName = defaultTable.tableName;
            this.mMaxpTable.checkSum = defaultTable.checkSum;
            this.mMaxpTable.offset = defaultTable.offset;
            this.mMaxpTable.length = defaultTable.length;
            this.mMaxpTable.loadFontData(this.fr);
        }
        if ((defaultTable = (DefaultTable)this.tableCollection.get("loca")) != null) {
            this.mLocaTable = new LocaTable();
            this.mLocaTable.tableName = defaultTable.tableName;
            this.mLocaTable.checkSum = defaultTable.checkSum;
            this.mLocaTable.offset = defaultTable.offset;
            this.mLocaTable.length = defaultTable.length;
            this.mLocaTable.indexToLocFormat = this.mHeadTable.indexToLocFormat;
            this.mLocaTable.numGlyphs = this.mMaxpTable.numGlyphs;
            this.mLocaTable.loadFontData(this.fr);
        }
        if ((defaultTable = (DefaultTable)this.tableCollection.get("glyf")) != null && this.mLocaTable != null) {
            this.glyphData = new Hashtable();
            int n = 0;
            while (n < this.mLocaTable.numGlyphs) {
                int n2 = (int)(this.mLocaTable.offsets[n + 1] - this.mLocaTable.offsets[n]);
                if (n2 > 0) {
                    byte[] byArray = new byte[n2];
                    try {
                        this.fr.seek(defaultTable.offset + this.mLocaTable.offsets[n]);
                        this.fr.read(byArray);
                        if (byArray != null) {
                            this.glyphData.put(new Integer(n), byArray);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                ++n;
            }
        }
        if ((defaultTable = (DefaultTable)this.tableCollection.get("cmap")) != null) {
            this.mCmapTable = new CmapTable();
            this.mCmapTable.tableName = defaultTable.tableName;
            this.mCmapTable.checkSum = defaultTable.checkSum;
            this.mCmapTable.offset = defaultTable.offset;
            this.mCmapTable.length = defaultTable.length;
            this.mCmapTable.loadFontData(this.fr);
            this.cmaps = this.mCmapTable.getCmaps();
        }
        if ((defaultTable = (DefaultTable)this.tableCollection.get("OS/2")) != null) {
            this.mOS2Table = new OS2Table();
            this.mOS2Table.tableName = defaultTable.tableName;
            this.mOS2Table.checkSum = defaultTable.checkSum;
            this.mOS2Table.offset = defaultTable.offset;
            this.mOS2Table.length = defaultTable.length;
            this.mOS2Table.unitsPerEm = this.mHeadTable.unitsPerEm;
            this.mOS2Table.loadFontData(this.fr);
        }
        if ((defaultTable = (DefaultTable)this.tableCollection.get("post")) != null) {
            this.mPostTable = new PostTable();
            this.mPostTable.tableName = defaultTable.tableName;
            this.mPostTable.checkSum = defaultTable.checkSum;
            this.mPostTable.offset = defaultTable.offset;
            this.mPostTable.length = defaultTable.length;
            this.mPostTable.loadFontData(this.fr);
        }
        this.setFlags();
        this.flags = this.mHeadTable.flags;
        if (this.flags <= 0) {
            this.flags = 32;
        }
        this.fontBox[0] = this.mHeadTable.changeTTF2PdfUnit(this.mHeadTable.xMin, this.mHeadTable.unitsPerEm);
        this.fontBox[1] = this.mHeadTable.changeTTF2PdfUnit(this.mHeadTable.yMin, this.mHeadTable.unitsPerEm);
        this.fontBox[2] = this.mHeadTable.changeTTF2PdfUnit(this.mHeadTable.xMax, this.mHeadTable.unitsPerEm);
        this.fontBox[3] = this.mHeadTable.changeTTF2PdfUnit(this.mHeadTable.yMax, this.mHeadTable.unitsPerEm);
        this.ascent = this.mHheaTable.changeTTF2PdfUnit(this.mHheaTable.ascent, this.mHeadTable.unitsPerEm);
        this.dscent = this.mHheaTable.changeTTF2PdfUnit(this.mHheaTable.descent, this.mHeadTable.unitsPerEm);
        this.ItalicAngle = this.mPostTable.ItalicAngle;
        this.panose = this.mOS2Table.panose;
        this.capHeight = this.mOS2Table.changeTTF2PdfUnit(this.mOS2Table.sCapHeight, this.mHeadTable.unitsPerEm);
        this.glyphWidths = this.mHtmxTable.advanceWidths;
        this.offsets = this.mLocaTable.offsets;
    }

    private void setFlags() {
        if (this.mHeadTable == null) {
            return;
        }
        this.mHeadTable.flags = 0;
        if (this.mPostTable != null && this.mPostTable.ItalicAngle != 0.0f) {
            this.mHeadTable.flags |= 0x40;
        }
        if (this.mOS2Table != null) {
            if (this.mOS2Table.panose[0] == 3) {
                this.mHeadTable.flags |= 8;
            }
            if (this.mOS2Table.panose[1] != 0) {
                this.mHeadTable.flags |= 2;
            }
            if (this.mOS2Table.panose[2] >= 8) {
                this.mHeadTable.flags |= 0x40000;
            }
            if (this.mOS2Table.panose[3] != 9) {
                this.mHeadTable.flags |= 1;
            }
        }
        this.mHeadTable.flags |= 4;
        this.mHeadTable.flags |= 0x20000;
    }

    public void resetUsedChars(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = this.usedChars.size();
            if (n2 == 0) {
                this.usedChars.add(new Integer(c));
                this.firstChar = c;
                this.lastChar = c;
            } else if (this.usedChars.indexOf(new Integer(c)) < 0) {
                this.usedChars.add(new Integer(c));
            }
            if (c > this.lastChar) {
                this.lastChar = c;
            }
            if (c < this.firstChar) {
                this.firstChar = c;
            }
            ++n;
        }
    }

    static String toHex(int n) {
        String string = Integer.toHexString(n);
        return String.valueOf("<0000".substring(0, 5 - string.length())) + string + ">";
    }

    static void writeByte(byte[] byArray, int n, byte by) {
        byArray[n++] = by;
    }

    static void writeShort(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
    }

    static void writeInt(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)(l >> 24 & 0xFFL);
        byArray[n++] = (byte)(l >> 16 & 0xFFL);
        byArray[n++] = (byte)(l >> 8 & 0xFFL);
        byArray[n++] = (byte)(l & 0xFFL);
    }

    static void writeString(byte[] byArray, int n, String string) {
        try {
            byte[] byArray2 = string.getBytes("ISO-8859-1");
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public byte[] getFontData() {
        Object object;
        this.getNewGlyph();
        int n = 0;
        int n2 = 0;
        while (n2 < TABLE_NAMES_SIMPLE.length) {
            if (TABLE_NAMES_SIMPLE[n2] != "glyf" && TABLE_NAMES_SIMPLE[n2] != "loca") {
                DefaultTable defaultTable = (DefaultTable)this.tableCollection.get(TABLE_NAMES_SIMPLE[n2]);
                n += defaultTable.length + 3 & 0xFFFFFFFC;
            }
            ++n2;
        }
        n += this.newLocaTable.length;
        n += this.newGTable.length;
        byte[] byArray = new byte[n += 12 + 16 * TABLE_NAMES_SIMPLE.length];
        int n3 = 0;
        TrueTypeFile.writeInt(byArray, n3, 65536L);
        TrueTypeFile.writeShort(byArray, n3 += 4, TABLE_NAMES_SIMPLE.length);
        n2 = ENTRY_SELECTOR[TABLE_NAMES_SIMPLE.length];
        TrueTypeFile.writeShort(byArray, n3 += 2, (1 << n2) * 16);
        TrueTypeFile.writeShort(byArray, n3 += 2, n2);
        TrueTypeFile.writeShort(byArray, n3 += 2, (TABLE_NAMES_SIMPLE.length - (1 << n2)) * 16);
        n3 += 2;
        int n4 = 12 + 16 * TABLE_NAMES_SIMPLE.length;
        int n5 = 0;
        while (n5 < TABLE_NAMES_SIMPLE.length) {
            object = TABLE_NAMES_SIMPLE[n5];
            TrueTypeFile.writeString(byArray, n3, (String)object);
            n3 += 4;
            DefaultTable defaultTable = (DefaultTable)this.tableCollection.get(TABLE_NAMES_SIMPLE[n5]);
            if (TABLE_NAMES_SIMPLE[n5] == "glyf") {
                TrueTypeFile.writeInt(byArray, n3, this.calculateChecksum(this.newGTable));
                defaultTable.length = this.gTableRealSize;
            } else if (TABLE_NAMES_SIMPLE[n5] == "loca") {
                TrueTypeFile.writeInt(byArray, n3, this.calculateChecksum(this.newLocaTable));
                defaultTable.length = this.lTableRealSize;
            } else {
                TrueTypeFile.writeInt(byArray, n3, defaultTable.checkSum);
            }
            TrueTypeFile.writeInt(byArray, n3 += 4, n4);
            int n6 = defaultTable.length + 3 & 0xFFFFFFFC;
            TrueTypeFile.writeInt(byArray, n3 += 4, defaultTable.length);
            n3 += 4;
            n4 += n6;
            ++n5;
        }
        n5 = 0;
        while (n5 < TABLE_NAMES_SIMPLE.length) {
            object = (DefaultTable)this.tableCollection.get(TABLE_NAMES_SIMPLE[n5]);
            if (TABLE_NAMES_SIMPLE[n5] == "glyf") {
                System.arraycopy(this.newGTable, 0, byArray, n3, this.newGTable.length);
                n3 += this.newGTable.length;
            } else if (TABLE_NAMES_SIMPLE[n5] == "loca") {
                System.arraycopy(this.newLocaTable, 0, byArray, n3, this.newLocaTable.length);
                n3 += this.newLocaTable.length;
            } else {
                try {
                    this.fr.seek(((TTFTable)object).offset);
                    this.fr.readFully(byArray, n3, ((TTFTable)object).length);
                    n3 += ((TTFTable)object).length + 3 & 0xFFFFFFFC;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            ++n5;
        }
        return byArray;
    }

    public void getUsedGlyphIndexs() {
        if (this.usedChars != null) {
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < this.usedChars.size()) {
                Integer n2 = (Integer)this.usedChars.elementAt(n);
                vector.add(this.cmaps.get(n2));
                ++n;
            }
            if (vector.size() > 0 && !vector.contains(new Integer(0))) {
                vector.add(new Integer(0));
            }
            this.usedGIInt = new int[vector.size()];
            n = 0;
            while (n < vector.size()) {
                this.usedGIInt[n] = (Integer)vector.elementAt(n);
                ++n;
            }
            Arrays.sort(this.usedGIInt);
            this.usedGWidths = new int[this.usedGIInt.length];
            this.usedGI_GW = new Hashtable();
            n = 0;
            while (n < this.usedGIInt.length) {
                this.usedGWidths[n] = this.mHtmxTable.changeTTF2PdfUnit(this.mHtmxTable.advanceWidths[this.usedGIInt[n]], this.mHeadTable.unitsPerEm);
                this.usedGI_GW.put(new Integer(this.usedGIInt[n]), new Integer(this.usedGWidths[n]));
                ++n;
            }
        }
    }

    private void getNewGlyph() {
        int[] nArray = this.usedGIInt;
        this.newGTable = null;
        this.newOffsets = new int[this.mLocaTable.numGlyphs + 1];
        int n = 0;
        if (this.fr != null && this.tableCollection != null && this.usedChars != null) {
            int n2;
            int n3 = 0;
            while (n3 < nArray.length) {
                n2 = nArray[n3];
                int n4 = (int)(this.offsets[n2 + 1] - this.offsets[n2]);
                n += n4;
                ++n3;
            }
            this.gTableRealSize = n;
            this.newGTable = new byte[n + 3 & 0xFFFFFFFC];
            n3 = 0;
            n2 = 0;
            DefaultTable defaultTable = (DefaultTable)this.tableCollection.get("glyf");
            int n5 = 0;
            while (n5 < this.newOffsets.length) {
                this.newOffsets[n5] = n3;
                if (n2 < nArray.length && nArray[n2] == n5) {
                    ++n2;
                    this.newOffsets[n5] = n3;
                    long l = this.offsets[n5];
                    int n6 = (int)(this.offsets[n5 + 1] - l);
                    if (n6 > 0) {
                        try {
                            this.fr.seek(defaultTable.offset + l);
                            this.fr.readFully(this.newGTable, n3, n6);
                            n3 += n6;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                ++n5;
            }
            n5 = this.mLocaTable.indexToLocFormat == 0 ? this.newOffsets.length * 2 : this.newOffsets.length * 4;
            this.newLocaTable = new byte[n5 + 3 & 0xFFFFFFFC];
            this.lTableRealSize = n5;
            int n7 = 0;
            int n8 = 0;
            while (n8 < this.newOffsets.length) {
                if (this.mLocaTable.indexToLocFormat == 0) {
                    TrueTypeFile.writeShort(this.newLocaTable, n7, this.newOffsets[n8] / 2);
                    n7 += 2;
                } else {
                    TrueTypeFile.writeInt(this.newLocaTable, n7, this.newOffsets[n8]);
                    n7 += 4;
                }
                ++n8;
            }
        }
    }

    public String getUsedCmaps() {
        if (this.usedChars.size() == 0) {
            return null;
        }
        int n = (Integer)this.cmaps.get(new Integer(this.firstChar));
        int n2 = (Integer)this.cmaps.get(new Integer(this.lastChar));
        StringBuffer stringBuffer = new StringBuffer("/CIDInit /ProcSet findresource begin\n");
        stringBuffer.append("12 dict begin\n");
        stringBuffer.append("begincmap\n");
        stringBuffer.append("/CIDSystemInfo\n");
        stringBuffer.append("<< /Registry (Adobe)\n");
        stringBuffer.append("/Ordering (UCS)\n");
        stringBuffer.append("/Supplement 0\n");
        stringBuffer.append(">> def\n");
        stringBuffer.append("/CMapName /Adobe-Identity-UCS def\n");
        stringBuffer.append("/CMapType 2 def\n");
        stringBuffer.append("1 begincodespacerange\n");
        stringBuffer.append(TrueTypeFile.toHex(n));
        stringBuffer.append(TrueTypeFile.toHex(n2));
        stringBuffer.append("\nendcodespacerange\n");
        stringBuffer.append(this.usedChars.size());
        stringBuffer.append(" beginbfrange\n");
        int n3 = 0;
        while (n3 < this.usedChars.size()) {
            Integer n4 = (Integer)this.usedChars.elementAt(n3);
            int n5 = n4;
            int n6 = (Integer)this.cmaps.get(n4);
            stringBuffer.append(TrueTypeFile.toHex(n5));
            stringBuffer.append(" ");
            stringBuffer.append(TrueTypeFile.toHex(n5));
            stringBuffer.append(" ");
            stringBuffer.append(n6);
            stringBuffer.append("\n");
            ++n3;
        }
        stringBuffer.append("endbfrange\n");
        stringBuffer.append("endcmap\n");
        stringBuffer.append("CMapName currentdict /CMap defineresource pop\n");
        stringBuffer.append("end end\n");
        return stringBuffer.toString();
    }

    public CmapTable getMCmapTable() {
        return this.mCmapTable;
    }

    public FontDirectory getMFontDirectory() {
        return this.mFontDirectory;
    }

    public HeadTable getMHeadTable() {
        return this.mHeadTable;
    }

    public HheaTable getMHheaTable() {
        return this.mHheaTable;
    }

    public LocaTable getMLocaTable() {
        return this.mLocaTable;
    }

    public MaxpTable getMMaxpTable() {
        return this.mMaxpTable;
    }

    public NameTable getMNameTable() {
        return this.mNameTable;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public Hashtable getCmaps() {
        return this.cmaps;
    }

    public String getCopyRightNotice() {
        return this.copyRightNotice;
    }

    public int getDscent() {
        return this.dscent;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getFontBox() {
        return this.fontBox;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Hashtable getGlyphData() {
        return this.glyphData;
    }

    public int[] getGlyphWidths() {
        return this.glyphWidths;
    }

    public float getItalicAngle() {
        return this.ItalicAngle;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public HtmxTable getMHtmxTable() {
        return this.mHtmxTable;
    }

    public OS2Table getMOS2Table() {
        return this.mOS2Table;
    }

    public PostTable getMPostTable() {
        return this.mPostTable;
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public byte[] getPanose() {
        return this.panose;
    }

    public int getStemV() {
        return this.stemV;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }

    public Vector getUsedChars() {
        return this.usedChars;
    }

    public void setMCmapTable(CmapTable cmapTable) {
        this.mCmapTable = cmapTable;
    }

    public void setMFontDirectory(FontDirectory fontDirectory) {
        this.mFontDirectory = fontDirectory;
    }

    public void setMHeadTable(HeadTable headTable) {
        this.mHeadTable = headTable;
    }

    public void setMHheaTable(HheaTable hheaTable) {
        this.mHheaTable = hheaTable;
    }

    public void setMLocaTable(LocaTable locaTable) {
        this.mLocaTable = locaTable;
    }

    public void setMMaxpTable(MaxpTable maxpTable) {
        this.mMaxpTable = maxpTable;
    }

    public void setMNameTable(NameTable nameTable) {
        this.mNameTable = nameTable;
    }

    protected int calculateChecksum(byte[] byArray) {
        int n = byArray.length / 4;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            n5 += byArray[n6++] & 0xFF;
            n4 += byArray[n6++] & 0xFF;
            n3 += byArray[n6++] & 0xFF;
            n2 += byArray[n6++] & 0xFF;
            ++n7;
        }
        return n2 + (n3 << 8) + (n4 << 16) + (n5 << 24);
    }

    public static void main(String[] stringArray) {
        try {
            TrueTypeFontFileReader trueTypeFontFileReader = new TrueTypeFontFileReader("d:\\HGRPP1.TTC", "r");
            TrueTypeFile trueTypeFile = new TrueTypeFile();
            trueTypeFile.fr = trueTypeFontFileReader;
            trueTypeFile.LoadFontData();
            trueTypeFile.resetUsedChars("\u65e5");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public Hashtable getUsedGI_GW() {
        return this.usedGI_GW;
    }

    public int[] getUsedGIInt() {
        return this.usedGIInt;
    }

    public int[] getUsedGWidths() {
        return this.usedGWidths;
    }
}

